/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public final class AntFilterReader
extends DataType
implements Cloneable {
    private String className;
    private final Vector parameters = new Vector();
    private Path classpath;

    public void setClassName(String string) {
        this.className = string;
    }

    public String getClassName() {
        return this.className;
    }

    public void addParam(Parameter parameter) {
        this.parameters.addElement(parameter);
    }

    public void setClasspath(Path path) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public void setClasspathRef(Reference reference) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createClasspath().setRefid(reference);
    }

    public Parameter[] getParams() {
        Object[] objectArray = new Parameter[this.parameters.size()];
        this.parameters.copyInto(objectArray);
        return objectArray;
    }

    @Override
    public void setRefid(Reference reference) throws BuildException {
        if (!this.parameters.isEmpty() || this.className != null || this.classpath != null) {
            throw this.tooManyAttributes();
        }
        Object object = reference.getReferencedObject(this.getProject());
        if (object instanceof AntFilterReader) {
            AntFilterReader antFilterReader = (AntFilterReader)object;
            this.setClassName(antFilterReader.getClassName());
            this.setClasspath(antFilterReader.getClasspath());
            Parameter[] parameterArray = antFilterReader.getParams();
            if (parameterArray != null) {
                for (int i = 0; i < parameterArray.length; ++i) {
                    this.addParam(parameterArray[i]);
                }
            }
        } else {
            String string = reference.getRefId() + " doesn't refer to a FilterReader";
            throw new BuildException(string);
        }
        super.setRefid(reference);
    }
}

