/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.rmic;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.rmic.DefaultRmicAdapter;
import org.apache.tools.ant.types.Commandline;

public class SunRmic
extends DefaultRmicAdapter {
    public static final String RMIC_CLASSNAME = "sun.rmi.rmic.Main";
    public static final String COMPILER_NAME = "sun";
    public static final String RMIC_EXECUTABLE = "rmic";
    public static final String ERROR_NO_RMIC_ON_CLASSPATH = "Cannot use SUN rmic, as it is not available.  A common solution is to set the environment variable JAVA_HOME";
    public static final String ERROR_RMIC_FAILED = "Error starting SUN rmic: ";

    @Override
    public boolean execute() throws BuildException {
        this.getRmic().log("Using SUN rmic compiler", 3);
        Commandline commandline = this.setupRmicCommand();
        LogOutputStream logOutputStream = new LogOutputStream(this.getRmic(), 1);
        try {
            Class<?> clazz = Class.forName(RMIC_CLASSNAME);
            Constructor<?> constructor = clazz.getConstructor(OutputStream.class, String.class);
            Object obj = constructor.newInstance(logOutputStream, RMIC_EXECUTABLE);
            Method method = clazz.getMethod("compile", String[].class);
            Boolean bl = (Boolean)method.invoke(obj, new Object[]{commandline.getArguments()});
            boolean bl2 = bl;
            return bl2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BuildException(ERROR_NO_RMIC_ON_CLASSPATH, this.getRmic().getLocation());
        }
        catch (Exception exception) {
            if (exception instanceof BuildException) {
                throw (BuildException)exception;
            }
            throw new BuildException(ERROR_RMIC_FAILED, exception, this.getRmic().getLocation());
        }
        finally {
            try {
                logOutputStream.close();
            }
            catch (IOException iOException) {
                throw new BuildException(iOException);
            }
        }
    }

    @Override
    protected String[] preprocessCompilerArgs(String[] stringArray) {
        return this.filterJvmCompilerArgs(stringArray);
    }
}

