/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.rmic;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.ExecuteJava;
import org.apache.tools.ant.taskdefs.rmic.DefaultRmicAdapter;
import org.apache.tools.ant.types.Commandline;

public class KaffeRmic
extends DefaultRmicAdapter {
    private static final String[] RMIC_CLASSNAMES = new String[]{"gnu.classpath.tools.rmi.rmic.RMIC", "gnu.java.rmi.rmic.RMIC", "kaffe.rmi.rmic.RMIC"};
    public static final String COMPILER_NAME = "kaffe";

    @Override
    public boolean execute() throws BuildException {
        this.getRmic().log("Using Kaffe rmic", 3);
        Commandline commandline = this.setupRmicCommand();
        Class clazz = KaffeRmic.getRmicClass();
        if (clazz == null) {
            StringBuffer stringBuffer = new StringBuffer("Cannot use Kaffe rmic, as it is not available.  None of ");
            for (int i = 0; i < RMIC_CLASSNAMES.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(RMIC_CLASSNAMES[i]);
            }
            stringBuffer.append(" have been found. A common solution is to set the environment variable JAVA_HOME or CLASSPATH.");
            throw new BuildException(stringBuffer.toString(), this.getRmic().getLocation());
        }
        commandline.setExecutable(clazz.getName());
        if (!clazz.getName().equals(RMIC_CLASSNAMES[RMIC_CLASSNAMES.length - 1])) {
            commandline.createArgument().setValue("-verbose");
            this.getRmic().log(Commandline.describeCommand(commandline));
        }
        ExecuteJava executeJava = new ExecuteJava();
        executeJava.setJavaCommand(commandline);
        return executeJava.fork(this.getRmic()) == 0;
    }

    public static boolean isAvailable() {
        return KaffeRmic.getRmicClass() != null;
    }

    private static Class getRmicClass() {
        for (int i = 0; i < RMIC_CLASSNAMES.length; ++i) {
            try {
                return Class.forName(RMIC_CLASSNAMES[i]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
        }
        return null;
    }
}

