/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.email;

import java.io.File;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.email.EmailAddress;
import org.apache.tools.ant.taskdefs.email.Header;
import org.apache.tools.ant.taskdefs.email.Mailer;
import org.apache.tools.ant.taskdefs.email.Message;
import org.apache.tools.ant.taskdefs.email.PlainMailer;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.ClasspathUtils;

public class EmailTask
extends Task {
    private static final int SMTP_PORT = 25;
    public static final String AUTO = "auto";
    public static final String MIME = "mime";
    public static final String UU = "uu";
    public static final String PLAIN = "plain";
    private String encoding = "auto";
    private String host = "localhost";
    private int port = 25;
    private String subject = null;
    private Message message = null;
    private boolean failOnError = true;
    private boolean includeFileNames = false;
    private String messageMimeType = null;
    private EmailAddress from = null;
    private Vector replyToList = new Vector();
    private Vector toList = new Vector();
    private Vector ccList = new Vector();
    private Vector bccList = new Vector();
    private Vector headers = new Vector();
    private Path attachments = null;
    private String charset = null;
    private String user = null;
    private String password = null;
    private boolean ssl = false;

    public void setUser(String string) {
        this.user = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setSSL(boolean bl) {
        this.ssl = bl;
    }

    public void setEncoding(Encoding encoding) {
        this.encoding = encoding.getValue();
    }

    public void setMailport(int n) {
        this.port = n;
    }

    public void setMailhost(String string) {
        this.host = string;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public void setMessage(String string) {
        if (this.message != null) {
            throw new BuildException("Only one message can be sent in an email");
        }
        this.message = new Message(string);
        this.message.setProject(this.getProject());
    }

    public void setMessageFile(File file) {
        if (this.message != null) {
            throw new BuildException("Only one message can be sent in an email");
        }
        this.message = new Message(file);
        this.message.setProject(this.getProject());
    }

    public void setMessageMimeType(String string) {
        this.messageMimeType = string;
    }

    public void addMessage(Message message) throws BuildException {
        if (this.message != null) {
            throw new BuildException("Only one message can be sent in an email");
        }
        this.message = message;
    }

    public void addFrom(EmailAddress emailAddress) {
        if (this.from != null) {
            throw new BuildException("Emails can only be from one address");
        }
        this.from = emailAddress;
    }

    public void setFrom(String string) {
        if (this.from != null) {
            throw new BuildException("Emails can only be from one address");
        }
        this.from = new EmailAddress(string);
    }

    public void addReplyTo(EmailAddress emailAddress) {
        this.replyToList.add(emailAddress);
    }

    public void setReplyTo(String string) {
        this.replyToList.add(new EmailAddress(string));
    }

    public void addTo(EmailAddress emailAddress) {
        this.toList.addElement(emailAddress);
    }

    public void setToList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.toList.addElement(new EmailAddress(stringTokenizer.nextToken()));
        }
    }

    public void addCc(EmailAddress emailAddress) {
        this.ccList.addElement(emailAddress);
    }

    public void setCcList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.ccList.addElement(new EmailAddress(stringTokenizer.nextToken()));
        }
    }

    public void addBcc(EmailAddress emailAddress) {
        this.bccList.addElement(emailAddress);
    }

    public void setBccList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.bccList.addElement(new EmailAddress(stringTokenizer.nextToken()));
        }
    }

    public void setFailOnError(boolean bl) {
        this.failOnError = bl;
    }

    public void setFiles(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        while (stringTokenizer.hasMoreTokens()) {
            this.createAttachments().add(new FileResource(this.getProject().resolveFile(stringTokenizer.nextToken())));
        }
    }

    public void addFileset(FileSet fileSet) {
        this.createAttachments().add(fileSet);
    }

    public Path createAttachments() {
        if (this.attachments == null) {
            this.attachments = new Path(this.getProject());
        }
        return this.attachments.createPath();
    }

    public Header createHeader() {
        Header header = new Header();
        this.headers.add(header);
        return header;
    }

    public void setIncludefilenames(boolean bl) {
        this.includeFileNames = bl;
    }

    public boolean getIncludeFileNames() {
        return this.includeFileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        Message message = this.message;
        try {
            Mailer mailer = null;
            boolean bl = false;
            if (this.encoding.equals(MIME) || this.encoding.equals(AUTO) && !bl) {
                try {
                    mailer = (Mailer)ClasspathUtils.newInstance("org.apache.tools.ant.taskdefs.email.MimeMailer", EmailTask.class.getClassLoader(), Mailer.class);
                    bl = true;
                    this.log("Using MIME mail", 3);
                }
                catch (BuildException buildException) {
                    this.logBuildException("Failed to initialise MIME mail: ", buildException);
                    this.message = message;
                    return;
                }
            }
            if (!(bl || this.user == null && this.password == null || !this.encoding.equals(UU) && !this.encoding.equals(PLAIN))) {
                throw new BuildException("SMTP auth only possible with MIME mail");
            }
            if (!bl && this.ssl && (this.encoding.equals(UU) || this.encoding.equals(PLAIN))) {
                throw new BuildException("SSL only possible with MIME mail");
            }
            if (this.encoding.equals(UU) || this.encoding.equals(AUTO) && !bl) {
                try {
                    mailer = (Mailer)ClasspathUtils.newInstance("org.apache.tools.ant.taskdefs.email.UUMailer", EmailTask.class.getClassLoader(), Mailer.class);
                    bl = true;
                    this.log("Using UU mail", 3);
                }
                catch (BuildException buildException) {
                    this.logBuildException("Failed to initialise UU mail: ", buildException);
                    this.message = message;
                    return;
                }
            }
            if (this.encoding.equals(PLAIN) || this.encoding.equals(AUTO) && !bl) {
                mailer = new PlainMailer();
                bl = true;
                this.log("Using plain mail", 3);
            }
            if (mailer == null) {
                throw new BuildException("Failed to initialise encoding: " + this.encoding);
            }
            if (this.message == null) {
                this.message = new Message();
                this.message.setProject(this.getProject());
            }
            if (this.from == null || this.from.getAddress() == null) {
                throw new BuildException("A from element is required");
            }
            if (this.toList.isEmpty() && this.ccList.isEmpty() && this.bccList.isEmpty()) {
                throw new BuildException("At least one of to, cc or bcc must be supplied");
            }
            if (this.messageMimeType != null) {
                if (this.message.isMimeTypeSpecified()) {
                    throw new BuildException("The mime type can only be specified in one location");
                }
                this.message.setMimeType(this.messageMimeType);
            }
            if (this.charset != null) {
                if (this.message.getCharset() != null) {
                    throw new BuildException("The charset can only be specified in one location");
                }
                this.message.setCharset(this.charset);
            }
            Vector<File> vector = new Vector<File>();
            if (this.attachments != null) {
                Iterator iterator = this.attachments.iterator();
                while (iterator.hasNext()) {
                    FileResource fileResource = (FileResource)iterator.next();
                    vector.addElement(fileResource.getFile());
                }
            }
            this.log("Sending email: " + this.subject, 2);
            this.log("From " + this.from, 3);
            this.log("ReplyTo " + this.replyToList, 3);
            this.log("To " + this.toList, 3);
            this.log("Cc " + this.ccList, 3);
            this.log("Bcc " + this.bccList, 3);
            mailer.setHost(this.host);
            mailer.setPort(this.port);
            mailer.setUser(this.user);
            mailer.setPassword(this.password);
            mailer.setSSL(this.ssl);
            mailer.setMessage(this.message);
            mailer.setFrom(this.from);
            mailer.setReplyToList(this.replyToList);
            mailer.setToList(this.toList);
            mailer.setCcList(this.ccList);
            mailer.setBccList(this.bccList);
            mailer.setFiles(vector);
            mailer.setSubject(this.subject);
            mailer.setTask(this);
            mailer.setIncludeFileNames(this.includeFileNames);
            mailer.setHeaders(this.headers);
            mailer.send();
            int n = vector.size();
            this.log("Sent email with " + n + " attachment" + (n == 1 ? "" : "s"), 2);
        }
        catch (BuildException buildException) {
            this.logBuildException("Failed to send email: ", buildException);
            if (this.failOnError) {
                throw buildException;
            }
        }
        catch (Exception exception) {
            this.log("Failed to send email: " + exception.getMessage(), 1);
            if (this.failOnError) {
                throw new BuildException(exception);
            }
        }
        finally {
            this.message = message;
        }
    }

    private void logBuildException(String string, BuildException buildException) {
        Throwable throwable = buildException.getCause() == null ? buildException : buildException.getCause();
        this.log(string + throwable.getMessage(), 1);
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public String getCharset() {
        return this.charset;
    }

    public static class Encoding
    extends EnumeratedAttribute {
        @Override
        public String[] getValues() {
            return new String[]{EmailTask.AUTO, EmailTask.MIME, EmailTask.UU, EmailTask.PLAIN};
        }
    }
}

