/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.condition;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileUtils;

public class ResourceContains
implements Condition {
    private Project project;
    private String substring;
    private Resource resource;
    private String refid;
    private boolean casesensitive = true;

    public void setProject(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public void setResource(String string) {
        this.resource = new FileResource(new File(string));
    }

    public void setRefid(String string) {
        this.refid = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveRefid() {
        try {
            if (this.getProject() == null) {
                throw new BuildException("Cannot retrieve refid; project unset");
            }
            Object object = this.getProject().getReference(this.refid);
            if (!(object instanceof Resource)) {
                if (object instanceof ResourceCollection) {
                    ResourceCollection resourceCollection = (ResourceCollection)object;
                    if (resourceCollection.size() == 1) {
                        object = resourceCollection.iterator().next();
                    }
                } else {
                    throw new BuildException("Illegal value at '" + this.refid + "': " + String.valueOf(object));
                }
            }
            this.resource = (Resource)object;
        }
        finally {
            this.refid = null;
        }
    }

    public void setSubstring(String string) {
        this.substring = string;
    }

    public void setCasesensitive(boolean bl) {
        this.casesensitive = bl;
    }

    private void validate() {
        if (this.resource != null && this.refid != null) {
            throw new BuildException("Cannot set both resource and refid");
        }
        if (this.resource == null && this.refid != null) {
            this.resolveRefid();
        }
        if (this.resource == null || this.substring == null) {
            throw new BuildException("both resource and substring are required in <resourcecontains>");
        }
    }

    @Override
    public synchronized boolean eval() throws BuildException {
        boolean bl;
        this.validate();
        if (this.substring.length() == 0) {
            if (this.getProject() != null) {
                this.getProject().log("Substring is empty; returning true", 3);
            }
            return true;
        }
        if (this.resource.getSize() == 0L) {
            return false;
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(this.resource.getInputStream()));
            String string = FileUtils.safeReadFully(bufferedReader);
            String string2 = this.substring;
            if (!this.casesensitive) {
                string = string.toLowerCase();
                string2 = string2.toLowerCase();
            }
            bl = string.indexOf(string2) >= 0;
        }
        catch (IOException iOException) {
            try {
                throw new BuildException("There was a problem accessing resource : " + this.resource);
            }
            catch (Throwable throwable) {
                FileUtils.close(bufferedReader);
                throw throwable;
            }
        }
        FileUtils.close(bufferedReader);
        return bl;
    }
}

