/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.condition;

import java.util.Locale;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.condition.Condition;

public class Os
implements Condition {
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    private static final String OS_ARCH = System.getProperty("os.arch").toLowerCase(Locale.US);
    private static final String OS_VERSION = System.getProperty("os.version").toLowerCase(Locale.US);
    private static final String PATH_SEP = System.getProperty("path.separator");
    private String family;
    private String name;
    private String version;
    private String arch;
    public static final String FAMILY_WINDOWS = "windows";
    public static final String FAMILY_9X = "win9x";
    public static final String FAMILY_NT = "winnt";
    public static final String FAMILY_OS2 = "os/2";
    public static final String FAMILY_NETWARE = "netware";
    public static final String FAMILY_DOS = "dos";
    public static final String FAMILY_MAC = "mac";
    public static final String FAMILY_TANDEM = "tandem";
    public static final String FAMILY_UNIX = "unix";
    public static final String FAMILY_VMS = "openvms";
    public static final String FAMILY_ZOS = "z/os";
    public static final String FAMILY_OS400 = "os/400";

    public Os() {
    }

    public Os(String string) {
        this.setFamily(string);
    }

    public void setFamily(String string) {
        this.family = string.toLowerCase(Locale.US);
    }

    public void setName(String string) {
        this.name = string.toLowerCase(Locale.US);
    }

    public void setArch(String string) {
        this.arch = string.toLowerCase(Locale.US);
    }

    public void setVersion(String string) {
        this.version = string.toLowerCase(Locale.US);
    }

    @Override
    public boolean eval() throws BuildException {
        return Os.isOs(this.family, this.name, this.arch, this.version);
    }

    public static boolean isFamily(String string) {
        return Os.isOs(string, null, null, null);
    }

    public static boolean isName(String string) {
        return Os.isOs(null, string, null, null);
    }

    public static boolean isArch(String string) {
        return Os.isOs(null, null, string, null);
    }

    public static boolean isVersion(String string) {
        return Os.isOs(null, null, null, string);
    }

    public static boolean isOs(String string, String string2, String string3, String string4) {
        boolean bl = false;
        if (string != null || string2 != null || string3 != null || string4 != null) {
            boolean bl2 = true;
            boolean bl3 = true;
            boolean bl4 = true;
            boolean bl5 = true;
            if (string != null) {
                boolean bl6 = OS_NAME.indexOf(FAMILY_WINDOWS) > -1;
                boolean bl7 = false;
                boolean bl8 = false;
                if (bl6) {
                    bl7 = OS_NAME.indexOf("95") >= 0 || OS_NAME.indexOf("98") >= 0 || OS_NAME.indexOf("me") >= 0 || OS_NAME.indexOf("ce") >= 0;
                    boolean bl9 = bl8 = !bl7;
                }
                if (string.equals(FAMILY_WINDOWS)) {
                    bl2 = bl6;
                } else if (string.equals(FAMILY_9X)) {
                    bl2 = bl6 && bl7;
                } else if (string.equals(FAMILY_NT)) {
                    bl2 = bl6 && bl8;
                } else if (string.equals(FAMILY_OS2)) {
                    bl2 = OS_NAME.indexOf(FAMILY_OS2) > -1;
                } else if (string.equals(FAMILY_NETWARE)) {
                    bl2 = OS_NAME.indexOf(FAMILY_NETWARE) > -1;
                } else if (string.equals(FAMILY_DOS)) {
                    bl2 = PATH_SEP.equals(";") && !Os.isFamily(FAMILY_NETWARE);
                } else if (string.equals(FAMILY_MAC)) {
                    bl2 = OS_NAME.indexOf(FAMILY_MAC) > -1;
                } else if (string.equals(FAMILY_TANDEM)) {
                    bl2 = OS_NAME.indexOf("nonstop_kernel") > -1;
                } else if (string.equals(FAMILY_UNIX)) {
                    bl2 = PATH_SEP.equals(":") && !Os.isFamily(FAMILY_VMS) && (!Os.isFamily(FAMILY_MAC) || OS_NAME.endsWith("x"));
                } else if (string.equals(FAMILY_ZOS)) {
                    bl2 = OS_NAME.indexOf(FAMILY_ZOS) > -1 || OS_NAME.indexOf("os/390") > -1;
                } else if (string.equals(FAMILY_OS400)) {
                    bl2 = OS_NAME.indexOf(FAMILY_OS400) > -1;
                } else if (string.equals(FAMILY_VMS)) {
                    bl2 = OS_NAME.indexOf(FAMILY_VMS) > -1;
                } else {
                    throw new BuildException("Don't know how to detect os family \"" + string + "\"");
                }
            }
            if (string2 != null) {
                bl3 = string2.equals(OS_NAME);
            }
            if (string3 != null) {
                bl4 = string3.equals(OS_ARCH);
            }
            if (string4 != null) {
                bl5 = string4.equals(OS_VERSION);
            }
            bl = bl2 && bl3 && bl4 && bl5;
        }
        return bl;
    }
}

