/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.condition;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.condition.Condition;

public class Http
extends ProjectComponent
implements Condition {
    private static final int ERROR_BEGINS = 400;
    private String spec = null;
    private int errorsBeginAt = 400;

    public void setUrl(String string) {
        this.spec = string;
    }

    public void setErrorsBeginAt(int n) {
        this.errorsBeginAt = n;
    }

    @Override
    public boolean eval() throws BuildException {
        if (this.spec == null) {
            throw new BuildException("No url specified in http condition");
        }
        this.log("Checking for " + this.spec, 3);
        try {
            URL uRL = new URL(this.spec);
            try {
                URLConnection uRLConnection = uRL.openConnection();
                if (uRLConnection instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    int n = httpURLConnection.getResponseCode();
                    this.log("Result code for " + this.spec + " was " + n, 3);
                    return n > 0 && n < this.errorsBeginAt;
                }
            }
            catch (IOException iOException) {
                return false;
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new BuildException("Badly formed URL: " + this.spec, malformedURLException);
        }
        return true;
    }
}

