/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.compilers;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapter;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.StringUtils;

public abstract class DefaultCompilerAdapter
implements CompilerAdapter {
    private static final int COMMAND_LINE_LIMIT = 4096;
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    protected Path src;
    protected File destDir;
    protected String encoding;
    protected boolean debug = false;
    protected boolean optimize = false;
    protected boolean deprecation = false;
    protected boolean depend = false;
    protected boolean verbose = false;
    protected String target;
    protected Path bootclasspath;
    protected Path extdirs;
    protected Path compileClasspath;
    protected Path compileSourcepath;
    protected Project project;
    protected Location location;
    protected boolean includeAntRuntime;
    protected boolean includeJavaRuntime;
    protected String memoryInitialSize;
    protected String memoryMaximumSize;
    protected File[] compileList;
    protected Javac attributes;
    protected static final String lSep = StringUtils.LINE_SEP;

    @Override
    public void setJavac(Javac javac) {
        this.attributes = javac;
        this.src = javac.getSrcdir();
        this.destDir = javac.getDestdir();
        this.encoding = javac.getEncoding();
        this.debug = javac.getDebug();
        this.optimize = javac.getOptimize();
        this.deprecation = javac.getDeprecation();
        this.depend = javac.getDepend();
        this.verbose = javac.getVerbose();
        this.target = javac.getTarget();
        this.bootclasspath = javac.getBootclasspath();
        this.extdirs = javac.getExtdirs();
        this.compileList = javac.getFileList();
        this.compileClasspath = javac.getClasspath();
        this.compileSourcepath = javac.getSourcepath();
        this.project = javac.getProject();
        this.location = javac.getLocation();
        this.includeAntRuntime = javac.getIncludeantruntime();
        this.includeJavaRuntime = javac.getIncludejavaruntime();
        this.memoryInitialSize = javac.getMemoryInitialSize();
        this.memoryMaximumSize = javac.getMemoryMaximumSize();
    }

    public Javac getJavac() {
        return this.attributes;
    }

    protected Project getProject() {
        return this.project;
    }

    protected Path getCompileClasspath() {
        Path path;
        Path path2 = new Path(this.project);
        if (this.destDir != null && this.getJavac().isIncludeDestClasses()) {
            path2.setLocation(this.destDir);
        }
        if ((path = this.compileClasspath) == null) {
            path = new Path(this.project);
        }
        if (this.includeAntRuntime) {
            path2.addExisting(path.concatSystemClasspath("last"));
        } else {
            path2.addExisting(path.concatSystemClasspath("ignore"));
        }
        if (this.includeJavaRuntime) {
            path2.addJavaRuntime();
        }
        return path2;
    }

    protected Commandline setupJavacCommandlineSwitches(Commandline commandline) {
        return this.setupJavacCommandlineSwitches(commandline, false);
    }

    protected Commandline setupJavacCommandlineSwitches(Commandline commandline, boolean bl) {
        Object object;
        String string;
        Path path = this.getCompileClasspath();
        Path path2 = null;
        path2 = this.compileSourcepath != null ? this.compileSourcepath : this.src;
        String string2 = string = this.assumeJava11() ? "-J-" : "-J-X";
        if (this.memoryInitialSize != null) {
            if (!this.attributes.isForkedJavac()) {
                this.attributes.log("Since fork is false, ignoring memoryInitialSize setting.", 1);
            } else {
                commandline.createArgument().setValue(string + "ms" + this.memoryInitialSize);
            }
        }
        if (this.memoryMaximumSize != null) {
            if (!this.attributes.isForkedJavac()) {
                this.attributes.log("Since fork is false, ignoring memoryMaximumSize setting.", 1);
            } else {
                commandline.createArgument().setValue(string + "mx" + this.memoryMaximumSize);
            }
        }
        if (this.attributes.getNowarn()) {
            commandline.createArgument().setValue("-nowarn");
        }
        if (this.deprecation) {
            commandline.createArgument().setValue("-deprecation");
        }
        if (this.destDir != null) {
            commandline.createArgument().setValue("-d");
            commandline.createArgument().setFile(this.destDir);
        }
        commandline.createArgument().setValue("-classpath");
        if (this.assumeJava11()) {
            object = new Path(this.project);
            Path path3 = this.getBootClassPath();
            if (path3.size() > 0) {
                ((Path)object).append(path3);
            }
            if (this.extdirs != null) {
                ((Path)object).addExtdirs(this.extdirs);
            }
            ((Path)object).append(path);
            ((Path)object).append(path2);
            commandline.createArgument().setPath((Path)object);
        } else {
            commandline.createArgument().setPath(path);
            if (path2.size() > 0) {
                commandline.createArgument().setValue("-sourcepath");
                commandline.createArgument().setPath(path2);
            }
            if (this.target != null) {
                commandline.createArgument().setValue("-target");
                commandline.createArgument().setValue(this.target);
            }
            if (((Path)(object = this.getBootClassPath())).size() > 0) {
                commandline.createArgument().setValue("-bootclasspath");
                commandline.createArgument().setPath((Path)object);
            }
            if (this.extdirs != null && this.extdirs.size() > 0) {
                commandline.createArgument().setValue("-extdirs");
                commandline.createArgument().setPath(this.extdirs);
            }
        }
        if (this.encoding != null) {
            commandline.createArgument().setValue("-encoding");
            commandline.createArgument().setValue(this.encoding);
        }
        if (this.debug) {
            if (bl && !this.assumeJava11()) {
                object = this.attributes.getDebugLevel();
                if (object != null) {
                    commandline.createArgument().setValue("-g:" + (String)object);
                } else {
                    commandline.createArgument().setValue("-g");
                }
            } else {
                commandline.createArgument().setValue("-g");
            }
        } else if (this.getNoDebugArgument() != null) {
            commandline.createArgument().setValue(this.getNoDebugArgument());
        }
        if (this.optimize) {
            commandline.createArgument().setValue("-O");
        }
        if (this.depend) {
            if (this.assumeJava11()) {
                commandline.createArgument().setValue("-depend");
            } else if (this.assumeJava12()) {
                commandline.createArgument().setValue("-Xdepend");
            } else {
                this.attributes.log("depend attribute is not supported by the modern compiler", 1);
            }
        }
        if (this.verbose) {
            commandline.createArgument().setValue("-verbose");
        }
        this.addCurrentCompilerArgs(commandline);
        return commandline;
    }

    protected Commandline setupModernJavacCommandlineSwitches(Commandline commandline) {
        String string;
        this.setupJavacCommandlineSwitches(commandline, true);
        if (this.attributes.getSource() != null && !this.assumeJava13()) {
            commandline.createArgument().setValue("-source");
            String string2 = this.attributes.getSource();
            if (string2.equals("1.1") || string2.equals("1.2")) {
                commandline.createArgument().setValue("1.3");
            } else {
                commandline.createArgument().setValue(string2);
            }
        } else if ((this.assumeJava15() || this.assumeJava16()) && this.attributes.getTarget() != null && ((string = this.attributes.getTarget()).equals("1.1") || string.equals("1.2") || string.equals("1.3") || string.equals("1.4"))) {
            String string3 = string;
            if (string.equals("1.1")) {
                string3 = "1.2";
            }
            this.attributes.log("", 1);
            this.attributes.log("          WARNING", 1);
            this.attributes.log("", 1);
            this.attributes.log("The -source switch defaults to 1.5 in JDK 1.5 and 1.6.", 1);
            this.attributes.log("If you specify -target " + string + " you now must also specify -source " + string3 + ".", 1);
            this.attributes.log("Ant will implicitly add -source " + string3 + " for you.  Please change your build file.", 1);
            commandline.createArgument().setValue("-source");
            commandline.createArgument().setValue(string3);
        }
        return commandline;
    }

    protected Commandline setupModernJavacCommand() {
        Commandline commandline = new Commandline();
        this.setupModernJavacCommandlineSwitches(commandline);
        this.logAndAddFilesToCompile(commandline);
        return commandline;
    }

    protected Commandline setupJavacCommand() {
        return this.setupJavacCommand(false);
    }

    protected Commandline setupJavacCommand(boolean bl) {
        Commandline commandline = new Commandline();
        this.setupJavacCommandlineSwitches(commandline, bl);
        this.logAndAddFilesToCompile(commandline);
        return commandline;
    }

    protected void logAndAddFilesToCompile(Commandline commandline) {
        this.attributes.log("Compilation " + commandline.describeArguments(), 3);
        StringBuffer stringBuffer = new StringBuffer("File");
        if (this.compileList.length != 1) {
            stringBuffer.append("s");
        }
        stringBuffer.append(" to be compiled:");
        stringBuffer.append(StringUtils.LINE_SEP);
        for (int i = 0; i < this.compileList.length; ++i) {
            String string = this.compileList[i].getAbsolutePath();
            commandline.createArgument().setValue(string);
            stringBuffer.append("    ");
            stringBuffer.append(string);
            stringBuffer.append(StringUtils.LINE_SEP);
        }
        this.attributes.log(stringBuffer.toString(), 3);
    }

    protected int executeExternalCompile(String[] stringArray, int n) {
        return this.executeExternalCompile(stringArray, n, true);
    }

    protected int executeExternalCompile(String[] stringArray, int n, boolean bl) {
        String[] stringArray2 = null;
        File file = null;
        try {
            int n2;
            Object object;
            block15: {
                block14: {
                    if (Commandline.toString(stringArray).length() <= 4096 || n < 0) break block14;
                    object = null;
                    try {
                        file = FILE_UTILS.createTempFile("files", "", this.getJavac().getTempdir(), true, true);
                        object = new PrintWriter(new FileWriter(file));
                        for (n2 = n; n2 < stringArray.length; ++n2) {
                            if (bl && stringArray[n2].indexOf(" ") > -1) {
                                stringArray[n2] = stringArray[n2].replace(File.separatorChar, '/');
                                ((PrintWriter)object).println("\"" + stringArray[n2] + "\"");
                                continue;
                            }
                            ((PrintWriter)object).println(stringArray[n2]);
                        }
                        ((PrintWriter)object).flush();
                        stringArray2 = new String[n + 1];
                        System.arraycopy(stringArray, 0, stringArray2, 0, n);
                        stringArray2[n] = "@" + file;
                    }
                    catch (IOException iOException) {
                        try {
                            throw new BuildException("Error creating temporary file", iOException, this.location);
                        }
                        catch (Throwable throwable) {
                            FileUtils.close(object);
                            throw throwable;
                        }
                    }
                    FileUtils.close((Writer)object);
                    break block15;
                }
                stringArray2 = stringArray;
            }
            try {
                object = new Execute(new LogStreamHandler(this.attributes, 2, 1));
                if (Os.isFamily("openvms")) {
                    ((Execute)object).setVMLauncher(true);
                }
                ((Execute)object).setAntRun(this.project);
                ((Execute)object).setWorkingDirectory(this.project.getBaseDir());
                ((Execute)object).setCommandline(stringArray2);
                ((Execute)object).execute();
                n2 = ((Execute)object).getExitValue();
                return n2;
            }
            catch (IOException iOException) {
                throw new BuildException("Error running " + stringArray[0] + " compiler", iOException, this.location);
            }
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    protected void addExtdirsToClasspath(Path path) {
        path.addExtdirs(this.extdirs);
    }

    protected void addCurrentCompilerArgs(Commandline commandline) {
        commandline.addArguments(this.getJavac().getCurrentCompilerArgs());
    }

    protected boolean assumeJava11() {
        return "javac1.1".equals(this.attributes.getCompilerVersion());
    }

    protected boolean assumeJava12() {
        return "javac1.2".equals(this.attributes.getCompilerVersion()) || "classic".equals(this.attributes.getCompilerVersion()) && JavaEnvUtils.isJavaVersion("1.2") || "extJavac".equals(this.attributes.getCompilerVersion()) && JavaEnvUtils.isJavaVersion("1.2");
    }

    protected boolean assumeJava13() {
        return "javac1.3".equals(this.attributes.getCompilerVersion()) || "classic".equals(this.attributes.getCompilerVersion()) && JavaEnvUtils.isJavaVersion("1.3") || "modern".equals(this.attributes.getCompilerVersion()) && JavaEnvUtils.isJavaVersion("1.3") || "extJavac".equals(this.attributes.getCompilerVersion()) && JavaEnvUtils.isJavaVersion("1.3");
    }

    protected boolean assumeJava14() {
        return "javac1.4".equals(this.attributes.getCompilerVersion()) || "classic".equals(this.attributes.getCompilerVersion()) && JavaEnvUtils.isJavaVersion("1.4") || "modern".equals(this.attributes.getCompilerVersion()) && JavaEnvUtils.isJavaVersion("1.4") || "extJavac".equals(this.attributes.getCompilerVersion()) && JavaEnvUtils.isJavaVersion("1.4");
    }

    protected boolean assumeJava15() {
        return "javac1.5".equals(this.attributes.getCompilerVersion()) || "classic".equals(this.attributes.getCompilerVersion()) && JavaEnvUtils.isJavaVersion("1.5") || "modern".equals(this.attributes.getCompilerVersion()) && JavaEnvUtils.isJavaVersion("1.5") || "extJavac".equals(this.attributes.getCompilerVersion()) && JavaEnvUtils.isJavaVersion("1.5");
    }

    protected boolean assumeJava16() {
        return "javac1.6".equals(this.attributes.getCompilerVersion()) || "classic".equals(this.attributes.getCompilerVersion()) && JavaEnvUtils.isJavaVersion("1.6") || "modern".equals(this.attributes.getCompilerVersion()) && JavaEnvUtils.isJavaVersion("1.6") || "extJavac".equals(this.attributes.getCompilerVersion()) && JavaEnvUtils.isJavaVersion("1.6");
    }

    protected Path getBootClassPath() {
        Path path = new Path(this.project);
        if (this.bootclasspath != null) {
            path.append(this.bootclasspath);
        }
        return path.concatSystemBootClasspath("ignore");
    }

    protected String getNoDebugArgument() {
        return this.assumeJava11() ? null : "-g:none";
    }
}

