/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.compilers;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapter;
import org.apache.tools.ant.taskdefs.compilers.Gcj;
import org.apache.tools.ant.taskdefs.compilers.Javac12;
import org.apache.tools.ant.taskdefs.compilers.Javac13;
import org.apache.tools.ant.taskdefs.compilers.JavacExternal;
import org.apache.tools.ant.taskdefs.compilers.Jikes;
import org.apache.tools.ant.taskdefs.compilers.Jvc;
import org.apache.tools.ant.taskdefs.compilers.Kjc;
import org.apache.tools.ant.taskdefs.compilers.Sj;
import org.apache.tools.ant.util.ClasspathUtils;
import org.apache.tools.ant.util.JavaEnvUtils;

public final class CompilerAdapterFactory {
    private static final String MODERN_COMPILER = "com.sun.tools.javac.Main";

    private CompilerAdapterFactory() {
    }

    public static CompilerAdapter getCompiler(String string, Task task) throws BuildException {
        boolean bl = true;
        if (!JavaEnvUtils.isJavaVersion("1.2") && !JavaEnvUtils.isJavaVersion("1.3")) {
            bl = false;
        }
        if (string.equalsIgnoreCase("jikes")) {
            return new Jikes();
        }
        if (string.equalsIgnoreCase("extJavac")) {
            return new JavacExternal();
        }
        if (string.equalsIgnoreCase("classic") || string.equalsIgnoreCase("javac1.1") || string.equalsIgnoreCase("javac1.2")) {
            if (bl) {
                return new Javac12();
            }
            task.log("This version of java does not support the classic compiler; upgrading to modern", 1);
            string = "modern";
        }
        if (string.equalsIgnoreCase("modern") || string.equalsIgnoreCase("javac1.3") || string.equalsIgnoreCase("javac1.4") || string.equalsIgnoreCase("javac1.5") || string.equalsIgnoreCase("javac1.6")) {
            if (CompilerAdapterFactory.doesModernCompilerExist()) {
                return new Javac13();
            }
            if (bl) {
                task.log("Modern compiler not found - looking for classic compiler", 1);
                return new Javac12();
            }
            throw new BuildException("Unable to find a javac compiler;\ncom.sun.tools.javac.Main is not on the classpath.\nPerhaps JAVA_HOME does not point to the JDK.\nIt is currently set to \"" + JavaEnvUtils.getJavaHome() + "\"");
        }
        if (string.equalsIgnoreCase("jvc") || string.equalsIgnoreCase("microsoft")) {
            return new Jvc();
        }
        if (string.equalsIgnoreCase("kjc")) {
            return new Kjc();
        }
        if (string.equalsIgnoreCase("gcj")) {
            return new Gcj();
        }
        if (string.equalsIgnoreCase("sj") || string.equalsIgnoreCase("symantec")) {
            return new Sj();
        }
        return CompilerAdapterFactory.resolveClassName(string);
    }

    private static boolean doesModernCompilerExist() {
        try {
            Class.forName(MODERN_COMPILER);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                ClassLoader classLoader = CompilerAdapterFactory.class.getClassLoader();
                if (classLoader != null) {
                    classLoader.loadClass(MODERN_COMPILER);
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException2) {
                // empty catch block
            }
            return false;
        }
    }

    private static CompilerAdapter resolveClassName(String string) throws BuildException {
        return (CompilerAdapter)ClasspathUtils.newInstance(string, CompilerAdapterFactory.class.getClassLoader(), CompilerAdapter.class);
    }
}

