/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import java.util.zip.CRC32;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.ArchiveFileSet;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.types.ZipScanner;
import org.apache.tools.ant.types.resources.ArchiveResource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.IdentityMapper;
import org.apache.tools.ant.util.MergingMapper;
import org.apache.tools.ant.util.ResourceUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipExtraField;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class Zip
extends MatchingTask {
    private static final int BUFFER_SIZE = 8192;
    private static final int ROUNDUP_MILLIS = 1999;
    protected File zipFile;
    private ZipScanner zs;
    private File baseDir;
    protected Hashtable entries = new Hashtable();
    private Vector groupfilesets = new Vector();
    private Vector filesetsFromGroupfilesets = new Vector();
    protected String duplicate = "add";
    private boolean doCompress = true;
    private boolean doUpdate = false;
    private boolean savedDoUpdate = false;
    private boolean doFilesonly = false;
    protected String archiveType = "zip";
    private static final long EMPTY_CRC = new CRC32().getValue();
    protected String emptyBehavior = "skip";
    private Vector resources = new Vector();
    protected Hashtable addedDirs = new Hashtable();
    private Vector addedFiles = new Vector();
    protected boolean doubleFilePass = false;
    protected boolean skipWriting = false;
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private boolean updatedFile = false;
    private boolean addingNewFiles = false;
    private String encoding;
    private boolean keepCompression = false;
    private boolean roundUp = true;
    private String comment = "";
    private int level = -1;

    public void setZipfile(File file) {
        this.setDestFile(file);
    }

    public void setFile(File file) {
        this.setDestFile(file);
    }

    public void setDestFile(File file) {
        this.zipFile = file;
    }

    public File getDestFile() {
        return this.zipFile;
    }

    public void setBasedir(File file) {
        this.baseDir = file;
    }

    public void setCompress(boolean bl) {
        this.doCompress = bl;
    }

    public boolean isCompress() {
        return this.doCompress;
    }

    public void setFilesonly(boolean bl) {
        this.doFilesonly = bl;
    }

    public void setUpdate(boolean bl) {
        this.doUpdate = bl;
        this.savedDoUpdate = bl;
    }

    public boolean isInUpdateMode() {
        return this.doUpdate;
    }

    public void addFileset(FileSet fileSet) {
        this.add(fileSet);
    }

    public void addZipfileset(ZipFileSet zipFileSet) {
        this.add(zipFileSet);
    }

    public void add(ResourceCollection resourceCollection) {
        this.resources.add(resourceCollection);
    }

    public void addZipGroupFileset(FileSet fileSet) {
        this.groupfilesets.addElement(fileSet);
    }

    public void setDuplicate(Duplicate duplicate) {
        this.duplicate = duplicate.getValue();
    }

    public void setWhenempty(WhenEmpty whenEmpty) {
        this.emptyBehavior = whenEmpty.getValue();
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setKeepCompression(boolean bl) {
        this.keepCompression = bl;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public int getLevel() {
        return this.level;
    }

    public void setRoundUp(boolean bl) {
        this.roundUp = bl;
    }

    @Override
    public void execute() throws BuildException {
        if (this.doubleFilePass) {
            this.skipWriting = true;
            this.executeMain();
            this.skipWriting = false;
            this.executeMain();
        } else {
            this.executeMain();
        }
    }

    protected boolean hasUpdatedFile() {
        return this.updatedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeMain() throws BuildException {
        this.checkAttributesAndElements();
        File file = null;
        this.addingNewFiles = true;
        this.processDoUpdate();
        this.processGroupFilesets();
        Vector<ResourceCollection> vector = new Vector<ResourceCollection>();
        if (this.baseDir != null) {
            FileSet fileSet = (FileSet)this.getImplicitFileSet().clone();
            fileSet.setDir(this.baseDir);
            vector.addElement(fileSet);
        }
        for (int i = 0; i < this.resources.size(); ++i) {
            ResourceCollection resourceCollection = (ResourceCollection)this.resources.elementAt(i);
            vector.addElement(resourceCollection);
        }
        Object[] objectArray = new ResourceCollection[vector.size()];
        vector.copyInto(objectArray);
        boolean bl = false;
        try {
            ArchiveState archiveState = this.getResourcesToAdd((ResourceCollection[])objectArray, this.zipFile, false);
            if (!archiveState.isOutOfDate()) {
                return;
            }
            this.updatedFile = true;
            if (!this.zipFile.exists() && archiveState.isWithoutAnyResources()) {
                this.createEmptyZip(this.zipFile);
                return;
            }
            Resource[][] resourceArray = archiveState.getResourcesToAdd();
            if (this.doUpdate) {
                file = this.renameFile();
            }
            String string = this.doUpdate ? "Updating " : "Building ";
            this.log(string + this.archiveType + ": " + this.zipFile.getAbsolutePath());
            ZipOutputStream zipOutputStream = null;
            try {
                if (!this.skipWriting) {
                    zipOutputStream = new ZipOutputStream(this.zipFile);
                    zipOutputStream.setEncoding(this.encoding);
                    zipOutputStream.setMethod(this.doCompress ? 8 : 0);
                    zipOutputStream.setLevel(this.level);
                }
                this.initZipOutputStream(zipOutputStream);
                for (int i = 0; i < objectArray.length; ++i) {
                    if (resourceArray[i].length == 0) continue;
                    this.addResources((ResourceCollection)objectArray[i], resourceArray[i], zipOutputStream);
                }
                if (this.doUpdate) {
                    String[] stringArray;
                    this.addingNewFiles = false;
                    ZipFileSet zipFileSet = new ZipFileSet();
                    zipFileSet.setProject(this.getProject());
                    zipFileSet.setSrc(file);
                    zipFileSet.setDefaultexcludes(false);
                    for (int i = 0; i < this.addedFiles.size(); ++i) {
                        stringArray = zipFileSet.createExclude();
                        stringArray.setName((String)this.addedFiles.elementAt(i));
                    }
                    DirectoryScanner directoryScanner = zipFileSet.getDirectoryScanner(this.getProject());
                    ((ZipScanner)directoryScanner).setEncoding(this.encoding);
                    stringArray = directoryScanner.getIncludedFiles();
                    Resource[] resourceArray2 = new Resource[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        resourceArray2[i] = directoryScanner.getResource(stringArray[i]);
                    }
                    if (!this.doFilesonly) {
                        String[] stringArray2 = directoryScanner.getIncludedDirectories();
                        Resource[] resourceArray3 = new Resource[stringArray2.length];
                        for (int i = 0; i < stringArray2.length; ++i) {
                            resourceArray3[i] = directoryScanner.getResource(stringArray2[i]);
                        }
                        Resource[] resourceArray4 = resourceArray2;
                        resourceArray2 = new Resource[resourceArray4.length + resourceArray3.length];
                        System.arraycopy(resourceArray3, 0, resourceArray2, 0, resourceArray3.length);
                        System.arraycopy(resourceArray4, 0, resourceArray2, resourceArray3.length, resourceArray4.length);
                    }
                    this.addResources(zipFileSet, resourceArray2, zipOutputStream);
                }
                if (zipOutputStream != null) {
                    zipOutputStream.setComment(this.comment);
                }
                this.finalizeZipOutputStream(zipOutputStream);
                if (this.doUpdate && !file.delete()) {
                    this.log("Warning: unable to delete temporary file " + file.getName(), 1);
                }
                bl = true;
            }
            catch (Throwable throwable) {
                this.closeZout(zipOutputStream, bl);
                throw throwable;
            }
            this.closeZout(zipOutputStream, bl);
        }
        catch (IOException iOException) {
            String string = "Problem creating " + this.archiveType + ": " + iOException.getMessage();
            if (!(this.doUpdate && file == null || this.zipFile.delete())) {
                string = string + " (and the archive is probably corrupt but I could not delete it)";
            }
            if (this.doUpdate && file != null) {
                try {
                    FILE_UTILS.rename(file, this.zipFile);
                }
                catch (IOException iOException2) {
                    string = string + " (and I couldn't rename the temporary file " + file.getName() + " back)";
                }
            }
            throw new BuildException(string, iOException, this.getLocation());
        }
        finally {
            this.cleanUp();
        }
    }

    private File renameFile() {
        File file = FILE_UTILS.createTempFile("zip", ".tmp", this.zipFile.getParentFile(), true, true);
        try {
            FILE_UTILS.rename(this.zipFile, file);
        }
        catch (SecurityException securityException) {
            throw new BuildException("Not allowed to rename old file (" + this.zipFile.getAbsolutePath() + ") to temporary file");
        }
        catch (IOException iOException) {
            throw new BuildException("Unable to rename old file (" + this.zipFile.getAbsolutePath() + ") to temporary file");
        }
        return file;
    }

    private void closeZout(ZipOutputStream zipOutputStream, boolean bl) throws IOException {
        block3: {
            if (zipOutputStream == null) {
                return;
            }
            try {
                zipOutputStream.close();
            }
            catch (IOException iOException) {
                if (!bl) break block3;
                throw iOException;
            }
        }
    }

    private void checkAttributesAndElements() {
        if (this.baseDir == null && this.resources.size() == 0 && this.groupfilesets.size() == 0 && "zip".equals(this.archiveType)) {
            throw new BuildException("basedir attribute must be set, or at least one resource collection must be given!");
        }
        if (this.zipFile == null) {
            throw new BuildException("You must specify the " + this.archiveType + " file to create!");
        }
        if (this.zipFile.exists() && !this.zipFile.isFile()) {
            throw new BuildException(this.zipFile + " is not a file.");
        }
        if (this.zipFile.exists() && !this.zipFile.canWrite()) {
            throw new BuildException(this.zipFile + " is read-only.");
        }
    }

    private void processDoUpdate() {
        if (this.doUpdate && !this.zipFile.exists()) {
            this.doUpdate = false;
            this.log("ignoring update attribute as " + this.archiveType + " doesn't exist.", 4);
        }
    }

    private void processGroupFilesets() {
        for (int i = 0; i < this.groupfilesets.size(); ++i) {
            this.log("Processing groupfileset ", 3);
            FileSet fileSet = (FileSet)this.groupfilesets.elementAt(i);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            String[] stringArray = directoryScanner.getIncludedFiles();
            File file = directoryScanner.getBasedir();
            for (int j = 0; j < stringArray.length; ++j) {
                this.log("Adding file " + stringArray[j] + " to fileset", 3);
                ZipFileSet zipFileSet = new ZipFileSet();
                zipFileSet.setProject(this.getProject());
                zipFileSet.setSrc(new File(file, stringArray[j]));
                this.add(zipFileSet);
                this.filesetsFromGroupfilesets.addElement(zipFileSet);
            }
        }
    }

    protected final boolean isAddingNewFiles() {
        return this.addingNewFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addResources(FileSet fileSet, Resource[] resourceArray, ZipOutputStream zipOutputStream) throws IOException {
        String string = "";
        String string2 = "";
        int n = 16877;
        int n2 = 33188;
        ArchiveFileSet archiveFileSet = null;
        if (fileSet instanceof ArchiveFileSet) {
            archiveFileSet = (ArchiveFileSet)fileSet;
            string = archiveFileSet.getPrefix(this.getProject());
            string2 = archiveFileSet.getFullpath(this.getProject());
            n = archiveFileSet.getDirMode(this.getProject());
            n2 = archiveFileSet.getFileMode(this.getProject());
        }
        if (string.length() > 0 && string2.length() > 0) {
            throw new BuildException("Both prefix and fullpath attributes must not be set on the same fileset.");
        }
        if (resourceArray.length != 1 && string2.length() > 0) {
            throw new BuildException("fullpath attribute may only be specified for filesets that specify a single file.");
        }
        if (string.length() > 0) {
            if (!string.endsWith("/") && !string.endsWith("\\")) {
                string = string + "/";
            }
            this.addParentDirs(null, string, zipOutputStream, "", n);
        }
        ZipFile zipFile = null;
        try {
            boolean bl = false;
            File file = null;
            if (archiveFileSet == null || archiveFileSet.getSrc(this.getProject()) == null) {
                bl = true;
                file = fileSet.getDir(this.getProject());
            } else if (archiveFileSet instanceof ZipFileSet) {
                zipFile = new ZipFile(archiveFileSet.getSrc(this.getProject()), this.encoding);
            }
            for (int i = 0; i < resourceArray.length; ++i) {
                Object object;
                String string3 = null;
                string3 = string2.length() > 0 ? string2 : resourceArray[i].getName();
                if ("".equals(string3 = string3.replace(File.separatorChar, '/'))) continue;
                if (resourceArray[i].isDirectory() && !string3.endsWith("/")) {
                    string3 = string3 + "/";
                }
                if (!this.doFilesonly && !bl && resourceArray[i].isDirectory() && !archiveFileSet.hasDirModeBeenSet()) {
                    int n3 = string3.lastIndexOf("/", string3.length() - 2);
                    if (n3 != -1) {
                        this.addParentDirs(file, string3.substring(0, n3 + 1), zipOutputStream, string, n);
                    }
                    if (zipFile != null) {
                        object = zipFile.getEntry(resourceArray[i].getName());
                        this.addParentDirs(file, string3, zipOutputStream, string, ((ZipEntry)object).getUnixMode());
                    } else {
                        object = (ArchiveResource)resourceArray[i];
                        this.addParentDirs(file, string3, zipOutputStream, string, ((ArchiveResource)object).getMode());
                    }
                } else {
                    this.addParentDirs(file, string3, zipOutputStream, string, n);
                }
                if (!resourceArray[i].isDirectory() && bl) {
                    File file2 = FILE_UTILS.resolveFile(file, resourceArray[i].getName());
                    this.zipFile(file2, zipOutputStream, string + string3, n2);
                    continue;
                }
                if (resourceArray[i].isDirectory()) continue;
                if (zipFile != null) {
                    ZipEntry zipEntry = zipFile.getEntry(resourceArray[i].getName());
                    if (zipEntry == null) continue;
                    boolean bl2 = this.doCompress;
                    if (this.keepCompression) {
                        this.doCompress = zipEntry.getMethod() == 8;
                    }
                    InputStream inputStream = null;
                    try {
                        inputStream = zipFile.getInputStream(zipEntry);
                        this.zipFile(inputStream, zipOutputStream, string + string3, zipEntry.getTime(), archiveFileSet.getSrc(this.getProject()), archiveFileSet.hasFileModeBeenSet() ? n2 : zipEntry.getUnixMode());
                        continue;
                    }
                    finally {
                        this.doCompress = bl2;
                        FileUtils.close(inputStream);
                    }
                }
                ArchiveResource archiveResource = (ArchiveResource)resourceArray[i];
                object = null;
                try {
                    object = archiveResource.getInputStream();
                    this.zipFile((InputStream)object, zipOutputStream, string + string3, resourceArray[i].getLastModified(), archiveFileSet.getSrc(this.getProject()), archiveFileSet.hasFileModeBeenSet() ? n2 : archiveResource.getMode());
                    continue;
                }
                finally {
                    FileUtils.close((InputStream)object);
                }
            }
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addResources(ResourceCollection resourceCollection, Resource[] resourceArray, ZipOutputStream zipOutputStream) throws IOException {
        if (resourceCollection instanceof FileSet) {
            this.addResources((FileSet)resourceCollection, resourceArray, zipOutputStream);
            return;
        }
        for (int i = 0; i < resourceArray.length; ++i) {
            Object object;
            String string = resourceArray[i].getName().replace(File.separatorChar, '/');
            if ("".equals(string) || resourceArray[i].isDirectory() && this.doFilesonly) continue;
            File file = null;
            if (resourceArray[i] instanceof FileResource) {
                file = ((FileResource)resourceArray[i]).getBaseDir();
            }
            if (resourceArray[i].isDirectory() && !string.endsWith("/")) {
                string = string + "/";
            }
            this.addParentDirs(file, string, zipOutputStream, "", 16877);
            if (resourceArray[i].isDirectory()) continue;
            if (resourceArray[i] instanceof FileResource) {
                object = ((FileResource)resourceArray[i]).getFile();
                this.zipFile((File)object, zipOutputStream, string, 33188);
                continue;
            }
            object = null;
            try {
                object = resourceArray[i].getInputStream();
                this.zipFile((InputStream)object, zipOutputStream, string, resourceArray[i].getLastModified(), null, 33188);
                continue;
            }
            finally {
                FileUtils.close((InputStream)object);
            }
        }
    }

    protected void initZipOutputStream(ZipOutputStream zipOutputStream) throws IOException, BuildException {
    }

    protected void finalizeZipOutputStream(ZipOutputStream zipOutputStream) throws IOException, BuildException {
    }

    protected boolean createEmptyZip(File file) throws BuildException {
        this.log("Note: creating empty " + this.archiveType + " archive " + file, 2);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[22];
            byArray[0] = 80;
            byArray[1] = 75;
            byArray[2] = 5;
            byArray[3] = 6;
            ((OutputStream)fileOutputStream).write(byArray);
        }
        catch (IOException iOException) {
            try {
                throw new BuildException("Could not create empty ZIP archive (" + iOException.getMessage() + ")", iOException, this.getLocation());
            }
            catch (Throwable throwable) {
                FileUtils.close(fileOutputStream);
                throw throwable;
            }
        }
        FileUtils.close(fileOutputStream);
        return true;
    }

    private synchronized ZipScanner getZipScanner() {
        if (this.zs == null) {
            this.zs = new ZipScanner();
            this.zs.setEncoding(this.encoding);
            this.zs.setSrc(this.zipFile);
        }
        return this.zs;
    }

    protected ArchiveState getResourcesToAdd(ResourceCollection[] resourceCollectionArray, File file, boolean bl) throws BuildException {
        ArrayList<ResourceCollection> arrayList = new ArrayList<ResourceCollection>();
        ArrayList<ResourceCollection> arrayList2 = new ArrayList<ResourceCollection>();
        for (int i = 0; i < resourceCollectionArray.length; ++i) {
            if (resourceCollectionArray[i] instanceof FileSet) {
                arrayList.add(resourceCollectionArray[i]);
                continue;
            }
            arrayList2.add(resourceCollectionArray[i]);
        }
        ResourceCollection[] resourceCollectionArray2 = arrayList2.toArray(new ResourceCollection[arrayList2.size()]);
        ArchiveState archiveState = this.getNonFileSetResourcesToAdd(resourceCollectionArray2, file, bl);
        FileSet[] fileSetArray = arrayList.toArray(new FileSet[arrayList.size()]);
        ArchiveState archiveState2 = this.getResourcesToAdd(fileSetArray, file, archiveState.isOutOfDate());
        if (!archiveState.isOutOfDate() && archiveState2.isOutOfDate()) {
            archiveState = this.getNonFileSetResourcesToAdd(resourceCollectionArray2, file, true);
        }
        Resource[][] resourceArray = new Resource[resourceCollectionArray.length][];
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < resourceCollectionArray.length; ++i) {
            resourceArray[i] = resourceCollectionArray[i] instanceof FileSet ? archiveState2.getResourcesToAdd()[n++] : archiveState.getResourcesToAdd()[n2++];
        }
        return new ArchiveState(archiveState2.isOutOfDate(), resourceArray);
    }

    protected ArchiveState getResourcesToAdd(FileSet[] fileSetArray, File file, boolean bl) throws BuildException {
        Object object;
        Object object2;
        int n;
        Resource[][] resourceArray = this.grabResources(fileSetArray);
        if (Zip.isEmpty(resourceArray)) {
            if (bl && this.doUpdate) {
                return new ArchiveState(true, resourceArray);
            }
            if (this.emptyBehavior.equals("skip")) {
                if (this.doUpdate) {
                    this.log(this.archiveType + " archive " + file + " not updated because no new files were included.", 3);
                } else {
                    this.log("Warning: skipping " + this.archiveType + " archive " + file + " because no files were included.", 1);
                }
            } else {
                if (this.emptyBehavior.equals("fail")) {
                    throw new BuildException("Cannot create " + this.archiveType + " archive " + file + ": no files were included.", this.getLocation());
                }
                if (!file.exists()) {
                    bl = true;
                }
            }
            return new ArchiveState(bl, resourceArray);
        }
        if (!file.exists()) {
            return new ArchiveState(true, resourceArray);
        }
        if (bl && !this.doUpdate) {
            return new ArchiveState(true, resourceArray);
        }
        Resource[][] resourceArray2 = new Resource[fileSetArray.length][];
        for (n = 0; n < fileSetArray.length; ++n) {
            if (this.fileset instanceof ZipFileSet && ((ZipFileSet)this.fileset).getSrc(this.getProject()) != null) continue;
            object2 = fileSetArray[n].getDir(this.getProject());
            for (int i = 0; i < resourceArray[n].length; ++i) {
                object = FILE_UTILS.resolveFile((File)object2, resourceArray[n][i].getName());
                if (!((File)object).equals(file)) continue;
                throw new BuildException("A zip file cannot include itself", this.getLocation());
            }
        }
        for (n = 0; n < fileSetArray.length; ++n) {
            Object object3;
            if (resourceArray[n].length == 0) {
                resourceArray2[n] = new Resource[0];
                continue;
            }
            object2 = new IdentityMapper();
            if (fileSetArray[n] instanceof ZipFileSet) {
                object3 = (ZipFileSet)fileSetArray[n];
                if (((ArchiveFileSet)object3).getFullpath(this.getProject()) != null && !((ArchiveFileSet)object3).getFullpath(this.getProject()).equals("")) {
                    object = new MergingMapper();
                    ((MergingMapper)object).setTo(((ArchiveFileSet)object3).getFullpath(this.getProject()));
                    object2 = object;
                } else if (((ArchiveFileSet)object3).getPrefix(this.getProject()) != null && !((ArchiveFileSet)object3).getPrefix(this.getProject()).equals("")) {
                    object = new GlobPatternMapper();
                    ((GlobPatternMapper)object).setFrom("*");
                    String string = ((ArchiveFileSet)object3).getPrefix(this.getProject());
                    if (!string.endsWith("/") && !string.endsWith("\\")) {
                        string = string + "/";
                    }
                    ((GlobPatternMapper)object).setTo(string + "*");
                    object2 = object;
                }
            }
            object3 = resourceArray[n];
            if (this.doFilesonly) {
                object3 = this.selectFileResources((Resource[])object3);
            }
            resourceArray2[n] = ResourceUtils.selectOutOfDateSources(this, (Resource[])object3, (FileNameMapper)object2, this.getZipScanner());
            boolean bl2 = bl = bl || resourceArray2[n].length > 0;
            if (bl && !this.doUpdate) break;
        }
        if (bl && !this.doUpdate) {
            return new ArchiveState(true, resourceArray);
        }
        return new ArchiveState(bl, resourceArray2);
    }

    protected ArchiveState getNonFileSetResourcesToAdd(ResourceCollection[] resourceCollectionArray, File file, boolean bl) throws BuildException {
        Resource[][] resourceArray = this.grabNonFileSetResources(resourceCollectionArray);
        if (Zip.isEmpty(resourceArray)) {
            return new ArchiveState(bl, resourceArray);
        }
        if (!file.exists()) {
            return new ArchiveState(true, resourceArray);
        }
        if (bl && !this.doUpdate) {
            return new ArchiveState(true, resourceArray);
        }
        Resource[][] resourceArray2 = new Resource[resourceCollectionArray.length][];
        for (int i = 0; i < resourceCollectionArray.length; ++i) {
            if (resourceArray[i].length == 0) {
                resourceArray2[i] = new Resource[0];
                continue;
            }
            for (int j = 0; j < resourceArray[i].length; ++j) {
                if (!(resourceArray[i][j] instanceof FileResource) || !file.equals(((FileResource)resourceArray[i][j]).getFile())) continue;
                throw new BuildException("A zip file cannot include itself", this.getLocation());
            }
            Resource[] resourceArray3 = resourceArray[i];
            if (this.doFilesonly) {
                resourceArray3 = this.selectFileResources(resourceArray3);
            }
            resourceArray2[i] = ResourceUtils.selectOutOfDateSources(this, resourceArray3, new IdentityMapper(), this.getZipScanner());
            boolean bl2 = bl = bl || resourceArray2[i].length > 0;
            if (bl && !this.doUpdate) break;
        }
        if (bl && !this.doUpdate) {
            return new ArchiveState(true, resourceArray);
        }
        return new ArchiveState(bl, resourceArray2);
    }

    protected Resource[][] grabResources(FileSet[] fileSetArray) {
        Resource[][] resourceArray = new Resource[fileSetArray.length][];
        for (int i = 0; i < fileSetArray.length; ++i) {
            int n;
            String[] stringArray;
            Object object;
            boolean bl = true;
            if (fileSetArray[i] instanceof ZipFileSet) {
                object = (ZipFileSet)fileSetArray[i];
                boolean bl2 = bl = ((ArchiveFileSet)object).getPrefix(this.getProject()).equals("") && ((ArchiveFileSet)object).getFullpath(this.getProject()).equals("");
            }
            if ((object = fileSetArray[i].getDirectoryScanner(this.getProject())) instanceof ZipScanner) {
                ((ZipScanner)object).setEncoding(this.encoding);
            }
            Vector<Resource> vector = new Vector<Resource>();
            if (!this.doFilesonly) {
                stringArray = ((DirectoryScanner)object).getIncludedDirectories();
                for (n = 0; n < stringArray.length; ++n) {
                    if ("".equals(stringArray[n]) && bl) continue;
                    vector.addElement(((DirectoryScanner)object).getResource(stringArray[n]));
                }
            }
            stringArray = ((DirectoryScanner)object).getIncludedFiles();
            for (n = 0; n < stringArray.length; ++n) {
                if ("".equals(stringArray[n]) && bl) continue;
                vector.addElement(((DirectoryScanner)object).getResource(stringArray[n]));
            }
            resourceArray[i] = new Resource[vector.size()];
            vector.copyInto(resourceArray[i]);
        }
        return resourceArray;
    }

    protected Resource[][] grabNonFileSetResources(ResourceCollection[] resourceCollectionArray) {
        Resource[][] resourceArray = new Resource[resourceCollectionArray.length][];
        for (int i = 0; i < resourceCollectionArray.length; ++i) {
            Iterator iterator = resourceCollectionArray[i].iterator();
            ArrayList<Resource> arrayList = new ArrayList<Resource>();
            int n = 0;
            while (iterator.hasNext()) {
                Resource resource = (Resource)iterator.next();
                if (!resource.isExists()) continue;
                if (resource.isDirectory()) {
                    arrayList.add(n++, resource);
                    continue;
                }
                arrayList.add(resource);
            }
            resourceArray[i] = arrayList.toArray(new Resource[arrayList.size()]);
        }
        return resourceArray;
    }

    protected void zipDir(File file, ZipOutputStream zipOutputStream, String string, int n) throws IOException {
        this.zipDir(file, zipOutputStream, string, n, null);
    }

    protected void zipDir(File file, ZipOutputStream zipOutputStream, String string, int n, ZipExtraField[] zipExtraFieldArray) throws IOException {
        if (this.doFilesonly) {
            this.log("skipping directory " + string + " for file-only archive", 3);
            return;
        }
        if (this.addedDirs.get(string) != null) {
            return;
        }
        this.log("adding directory " + string, 3);
        this.addedDirs.put(string, string);
        if (!this.skipWriting) {
            ZipEntry zipEntry = new ZipEntry(string);
            if (file != null && file.exists()) {
                zipEntry.setTime(file.lastModified() + (long)(this.roundUp ? 1999 : 0));
            } else {
                zipEntry.setTime(System.currentTimeMillis() + (long)(this.roundUp ? 1999 : 0));
            }
            zipEntry.setSize(0L);
            zipEntry.setMethod(0);
            zipEntry.setCrc(EMPTY_CRC);
            zipEntry.setUnixMode(n);
            if (zipExtraFieldArray != null) {
                zipEntry.setExtraFields(zipExtraFieldArray);
            }
            zipOutputStream.putNextEntry(zipEntry);
        }
    }

    protected void zipFile(InputStream inputStream, ZipOutputStream zipOutputStream, String string, long l, File file, int n) throws IOException {
        if (this.entries.contains(string)) {
            if (this.duplicate.equals("preserve")) {
                this.log(string + " already added, skipping", 2);
                return;
            }
            if (this.duplicate.equals("fail")) {
                throw new BuildException("Duplicate file " + string + " was found and the duplicate " + "attribute is 'fail'.");
            }
            this.log("duplicate file " + string + " found, adding.", 3);
        } else {
            this.log("adding entry " + string, 3);
        }
        this.entries.put(string, string);
        if (!this.skipWriting) {
            ZipEntry zipEntry = new ZipEntry(string);
            zipEntry.setTime(l);
            zipEntry.setMethod(this.doCompress ? 8 : 0);
            if (!zipOutputStream.isSeekable() && !this.doCompress) {
                Object object;
                long l2 = 0L;
                CRC32 cRC32 = new CRC32();
                if (!inputStream.markSupported()) {
                    object = new ByteArrayOutputStream();
                    byte[] byArray = new byte[8192];
                    int n2 = 0;
                    do {
                        l2 += (long)n2;
                        cRC32.update(byArray, 0, n2);
                        ((ByteArrayOutputStream)object).write(byArray, 0, n2);
                    } while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1);
                    inputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
                } else {
                    inputStream.mark(Integer.MAX_VALUE);
                    object = new byte[8192];
                    int n3 = 0;
                    do {
                        l2 += (long)n3;
                        cRC32.update((byte[])object, 0, n3);
                    } while ((n3 = inputStream.read((byte[])object, 0, ((Object)object).length)) != -1);
                    inputStream.reset();
                }
                zipEntry.setSize(l2);
                zipEntry.setCrc(cRC32.getValue());
            }
            zipEntry.setUnixMode(n);
            zipOutputStream.putNextEntry(zipEntry);
            byte[] byArray = new byte[8192];
            int n4 = 0;
            do {
                if (n4 == 0) continue;
                zipOutputStream.write(byArray, 0, n4);
            } while ((n4 = inputStream.read(byArray, 0, byArray.length)) != -1);
        }
        this.addedFiles.addElement(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zipFile(File file, ZipOutputStream zipOutputStream, String string, int n) throws IOException {
        if (file.equals(this.zipFile)) {
            throw new BuildException("A zip file cannot include itself", this.getLocation());
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.zipFile(fileInputStream, zipOutputStream, string, file.lastModified() + (long)(this.roundUp ? 1999 : 0), null, n);
        }
        finally {
            fileInputStream.close();
        }
    }

    protected final void addParentDirs(File file, String string, ZipOutputStream zipOutputStream, String string2, int n) throws IOException {
        if (!this.doFilesonly) {
            String string3;
            Stack<String> stack = new Stack<String>();
            int n2 = string.length();
            while ((n2 = string.lastIndexOf(47, n2 - 1)) != -1) {
                string3 = string.substring(0, n2 + 1);
                if (this.addedDirs.get(string2 + string3) != null) break;
                stack.push(string3);
            }
            while (!stack.isEmpty()) {
                string3 = (String)stack.pop();
                File file2 = null;
                file2 = file != null ? new File(file, string3) : new File(string3);
                this.zipDir(file2, zipOutputStream, string2 + string3, n);
            }
        }
    }

    protected void cleanUp() {
        this.addedDirs.clear();
        this.addedFiles.removeAllElements();
        this.entries.clear();
        this.addingNewFiles = false;
        this.doUpdate = this.savedDoUpdate;
        Enumeration enumeration = this.filesetsFromGroupfilesets.elements();
        while (enumeration.hasMoreElements()) {
            ZipFileSet zipFileSet = (ZipFileSet)enumeration.nextElement();
            this.resources.removeElement(zipFileSet);
        }
        this.filesetsFromGroupfilesets.removeAllElements();
    }

    public void reset() {
        this.resources.removeAllElements();
        this.zipFile = null;
        this.baseDir = null;
        this.groupfilesets.removeAllElements();
        this.duplicate = "add";
        this.archiveType = "zip";
        this.doCompress = true;
        this.emptyBehavior = "skip";
        this.doUpdate = false;
        this.doFilesonly = false;
        this.encoding = null;
    }

    protected static final boolean isEmpty(Resource[][] resourceArray) {
        for (int i = 0; i < resourceArray.length; ++i) {
            if (resourceArray[i].length <= 0) continue;
            return false;
        }
        return true;
    }

    protected Resource[] selectFileResources(Resource[] resourceArray) {
        if (resourceArray.length == 0) {
            return resourceArray;
        }
        Vector<Resource> vector = new Vector<Resource>(resourceArray.length);
        for (int i = 0; i < resourceArray.length; ++i) {
            if (!resourceArray[i].isDirectory()) {
                vector.addElement(resourceArray[i]);
                continue;
            }
            this.log("Ignoring directory " + resourceArray[i].getName() + " as only files will be added.", 3);
        }
        if (vector.size() != resourceArray.length) {
            Object[] objectArray = new Resource[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return resourceArray;
    }

    public static class ArchiveState {
        private boolean outOfDate;
        private Resource[][] resourcesToAdd;

        ArchiveState(boolean bl, Resource[][] resourceArray) {
            this.outOfDate = bl;
            this.resourcesToAdd = resourceArray;
        }

        public boolean isOutOfDate() {
            return this.outOfDate;
        }

        public Resource[][] getResourcesToAdd() {
            return this.resourcesToAdd;
        }

        public boolean isWithoutAnyResources() {
            if (this.resourcesToAdd == null) {
                return true;
            }
            for (int i = 0; i < this.resourcesToAdd.length; ++i) {
                if (this.resourcesToAdd[i] == null || this.resourcesToAdd[i].length <= 0) continue;
                return false;
            }
            return true;
        }
    }

    public static class Duplicate
    extends EnumeratedAttribute {
        @Override
        public String[] getValues() {
            return new String[]{"add", "preserve", "fail"};
        }
    }

    public static class WhenEmpty
    extends EnumeratedAttribute {
        @Override
        public String[] getValues() {
            return new String[]{"fail", "skip", "create"};
        }
    }
}

