/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.XMLCatalog;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class XmlProperty
extends Task {
    private Resource src;
    private String prefix = "";
    private boolean keepRoot = true;
    private boolean validate = false;
    private boolean collapseAttributes = false;
    private boolean semanticAttributes = false;
    private boolean includeSemanticAttribute = false;
    private File rootDirectory = null;
    private Hashtable addedAttributes = new Hashtable();
    private XMLCatalog xmlCatalog = new XMLCatalog();
    private String delimiter = ",";
    private static final String ID = "id";
    private static final String REF_ID = "refid";
    private static final String LOCATION = "location";
    private static final String VALUE = "value";
    private static final String PATH = "path";
    private static final String PATHID = "pathid";
    private static final String[] ATTRIBUTES = new String[]{"id", "refid", "location", "value", "path", "pathid"};
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();

    @Override
    public void init() {
        super.init();
        this.xmlCatalog.setProject(this.getProject());
    }

    protected EntityResolver getEntityResolver() {
        return this.xmlCatalog;
    }

    @Override
    public void execute() throws BuildException {
        Resource resource = this.getResource();
        if (resource == null) {
            String string = "XmlProperty task requires a source resource";
            throw new BuildException(string);
        }
        try {
            this.log("Loading " + this.src, 3);
            if (resource.isExists()) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setValidating(this.validate);
                documentBuilderFactory.setNamespaceAware(false);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                documentBuilder.setEntityResolver(this.getEntityResolver());
                Document document = null;
                document = this.src instanceof FileResource ? documentBuilder.parse(((FileResource)this.src).getFile()) : documentBuilder.parse(this.src.getInputStream());
                Element element = document.getDocumentElement();
                this.addedAttributes = new Hashtable();
                if (this.keepRoot) {
                    this.addNodeRecursively(element, this.prefix, null);
                } else {
                    NodeList nodeList = element.getChildNodes();
                    int n = nodeList.getLength();
                    for (int i = 0; i < n; ++i) {
                        this.addNodeRecursively(nodeList.item(i), this.prefix, null);
                    }
                }
            } else {
                this.log("Unable to find property resource: " + resource, 3);
            }
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            throw new BuildException("Failed to load " + this.src, exception);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new BuildException(parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new BuildException("Failed to load " + this.src, iOException);
        }
    }

    private void addNodeRecursively(Node node, String string, Object object) {
        String string2 = string;
        if (node.getNodeType() != 3) {
            if (string.trim().length() > 0) {
                string2 = string2 + ".";
            }
            string2 = string2 + node.getNodeName();
        }
        Object object2 = this.processNode(node, string2, object);
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                this.addNodeRecursively(nodeList.item(i), string2, object2);
            }
        }
    }

    void addNodeRecursively(Node node, String string) {
        this.addNodeRecursively(node, string, null);
    }

    public Object processNode(Node node, String string, Object object) {
        int n;
        Object object2;
        Object object3 = null;
        String string2 = null;
        if (node.hasAttributes()) {
            object2 = node.getAttributes();
            Node node2 = object2.getNamedItem(ID);
            string2 = this.semanticAttributes && node2 != null ? node2.getNodeValue() : null;
            for (n = 0; n < object2.getLength(); ++n) {
                Path path;
                String string3;
                String string4;
                Node node3 = object2.item(n);
                if (!this.semanticAttributes) {
                    string4 = this.getAttributeName(node3);
                    string3 = this.getAttributeValue(node3);
                    this.addProperty(string + string4, string3, null);
                    continue;
                }
                string4 = node3.getNodeName();
                string3 = this.getAttributeValue(node3);
                Path path2 = path = object != null && object instanceof Path ? (Path)object : null;
                if (string4.equals(ID)) continue;
                if (path != null && string4.equals(PATH)) {
                    path.setPath(string3);
                    continue;
                }
                if (object instanceof Path && string4.equals(REF_ID)) {
                    path.setPath(string3);
                    continue;
                }
                if (object instanceof Path && string4.equals(LOCATION)) {
                    path.setLocation(this.resolveFile(string3));
                    continue;
                }
                if (string4.equals(PATHID)) {
                    if (object != null) {
                        throw new BuildException("XmlProperty does not support nested paths");
                    }
                    object3 = new Path(this.getProject());
                    this.getProject().addReference(string3, object3);
                    continue;
                }
                String string5 = this.getAttributeName(node3);
                this.addProperty(string + string5, string3, string2);
            }
        }
        object2 = null;
        boolean bl = false;
        n = 0;
        if (node.getNodeType() == 1 && this.semanticAttributes && node.hasAttributes() && (node.getAttributes().getNamedItem(VALUE) != null || node.getAttributes().getNamedItem(LOCATION) != null || node.getAttributes().getNamedItem(REF_ID) != null || node.getAttributes().getNamedItem(PATH) != null || node.getAttributes().getNamedItem(PATHID) != null)) {
            n = 1;
        }
        if (node.getNodeType() == 3) {
            object2 = this.getAttributeValue(node);
        } else if (node.getNodeType() == 1 && node.getChildNodes().getLength() == 1 && node.getFirstChild().getNodeType() == 4) {
            object2 = node.getFirstChild().getNodeValue();
            if ("".equals(object2) && n == 0) {
                bl = true;
            }
        } else if (node.getNodeType() == 1 && node.getChildNodes().getLength() == 0 && n == 0) {
            object2 = "";
            bl = true;
        } else if (node.getNodeType() == 1 && node.getChildNodes().getLength() == 1 && node.getFirstChild().getNodeType() == 3 && "".equals(node.getFirstChild().getNodeValue()) && n == 0) {
            object2 = "";
            bl = true;
        }
        if (object2 != null) {
            if (this.semanticAttributes && string2 == null && object instanceof String) {
                string2 = (String)object;
            }
            if (((String)object2).trim().length() != 0 || bl) {
                this.addProperty(string, (String)object2, string2);
            }
        }
        return object3 != null ? object3 : string2;
    }

    private void addProperty(String string, String string2, String string3) {
        String string4 = string + ":" + string2;
        if (string3 != null) {
            string4 = string4 + "(id=" + string3 + ")";
        }
        this.log(string4, 4);
        if (this.addedAttributes.containsKey(string)) {
            string2 = (String)this.addedAttributes.get(string) + this.getDelimiter() + string2;
            this.getProject().setProperty(string, string2);
            this.addedAttributes.put(string, string2);
        } else if (this.getProject().getProperty(string) == null) {
            this.getProject().setNewProperty(string, string2);
            this.addedAttributes.put(string, string2);
        } else {
            this.log("Override ignored for property " + string, 3);
        }
        if (string3 != null) {
            this.getProject().addReference(string3, string2);
        }
    }

    private String getAttributeName(Node node) {
        String string = node.getNodeName();
        if (this.semanticAttributes) {
            if (string.equals(REF_ID)) {
                return "";
            }
            if (!XmlProperty.isSemanticAttribute(string) || this.includeSemanticAttribute) {
                return "." + string;
            }
            return "";
        }
        if (this.collapseAttributes) {
            return "." + string;
        }
        return "(" + string + ")";
    }

    private static boolean isSemanticAttribute(String string) {
        for (int i = 0; i < ATTRIBUTES.length; ++i) {
            if (!string.equals(ATTRIBUTES[i])) continue;
            return true;
        }
        return false;
    }

    private String getAttributeValue(Node node) {
        String string = node.getNodeValue().trim();
        if (this.semanticAttributes) {
            Object object;
            String string2 = node.getNodeName();
            string = this.getProject().replaceProperties(string);
            if (string2.equals(LOCATION)) {
                File file = this.resolveFile(string);
                return file.getPath();
            }
            if (string2.equals(REF_ID) && (object = this.getProject().getReference(string)) != null) {
                return object.toString();
            }
        }
        return string;
    }

    public void setFile(File file) {
        this.setSrcResource(new FileResource(file));
    }

    public void setSrcResource(Resource resource) {
        if (resource.isDirectory()) {
            throw new BuildException("the source can't be a directory");
        }
        if (resource instanceof FileResource && !this.supportsNonFileResources()) {
            throw new BuildException("Only FileSystem resources are supported.");
        }
        this.src = resource;
    }

    public void addConfigured(ResourceCollection resourceCollection) {
        if (resourceCollection.size() != 1) {
            throw new BuildException("only single argument resource collections are supported as archives");
        }
        this.setSrcResource((Resource)resourceCollection.iterator().next());
    }

    public void setPrefix(String string) {
        this.prefix = string.trim();
    }

    public void setKeeproot(boolean bl) {
        this.keepRoot = bl;
    }

    public void setValidate(boolean bl) {
        this.validate = bl;
    }

    public void setCollapseAttributes(boolean bl) {
        this.collapseAttributes = bl;
    }

    public void setSemanticAttributes(boolean bl) {
        this.semanticAttributes = bl;
    }

    public void setRootDirectory(File file) {
        this.rootDirectory = file;
    }

    public void setIncludeSemanticAttribute(boolean bl) {
        this.includeSemanticAttribute = bl;
    }

    public void addConfiguredXMLCatalog(XMLCatalog xMLCatalog) {
        this.xmlCatalog.addConfiguredXMLCatalog(xMLCatalog);
    }

    protected File getFile() {
        if (this.src instanceof FileResource) {
            return ((FileResource)this.src).getFile();
        }
        return null;
    }

    protected Resource getResource() {
        File file = this.getFile();
        if (file != null) {
            return new FileResource(file);
        }
        return this.src;
    }

    protected String getPrefix() {
        return this.prefix;
    }

    protected boolean getKeeproot() {
        return this.keepRoot;
    }

    protected boolean getValidate() {
        return this.validate;
    }

    protected boolean getCollapseAttributes() {
        return this.collapseAttributes;
    }

    protected boolean getSemanticAttributes() {
        return this.semanticAttributes;
    }

    protected File getRootDirectory() {
        return this.rootDirectory;
    }

    protected boolean getIncludeSementicAttribute() {
        return this.includeSemanticAttribute;
    }

    private File resolveFile(String string) {
        if (this.rootDirectory == null) {
            return FILE_UTILS.resolveFile(this.getProject().getBaseDir(), string);
        }
        return FILE_UTILS.resolveFile(this.rootDirectory, string);
    }

    protected boolean supportsNonFileResources() {
        return this.getClass().equals(XmlProperty.class);
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }
}

