/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

public class Untar
extends Expand {
    private UntarCompressionMethod compression = new UntarCompressionMethod();

    public void setCompression(UntarCompressionMethod untarCompressionMethod) {
        this.compression = untarCompressionMethod;
    }

    @Override
    public void setEncoding(String string) {
        throw new BuildException("The " + this.getTaskName() + " task doesn't support the encoding" + " attribute", this.getLocation());
    }

    @Override
    protected void expandFile(FileUtils fileUtils, File file, File file2) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            this.expandStream(file.getPath(), fileInputStream, file2);
        }
        catch (IOException iOException) {
            try {
                throw new BuildException("Error while expanding " + file.getPath(), iOException, this.getLocation());
            }
            catch (Throwable throwable) {
                FileUtils.close(fileInputStream);
                throw throwable;
            }
        }
        FileUtils.close(fileInputStream);
    }

    @Override
    protected void expandResource(Resource resource, File file) {
        InputStream inputStream = null;
        try {
            inputStream = resource.getInputStream();
            this.expandStream(resource.getName(), inputStream, file);
        }
        catch (IOException iOException) {
            throw new BuildException("Error while expanding " + resource.getName(), iOException, this.getLocation());
        }
        finally {
            FileUtils.close(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandStream(String string, InputStream inputStream, File file) throws IOException {
        TarInputStream tarInputStream = null;
        try {
            tarInputStream = new TarInputStream(this.compression.decompress(string, new BufferedInputStream(inputStream)));
            this.log("Expanding: " + string + " into " + file, 2);
            TarEntry tarEntry = null;
            FileNameMapper fileNameMapper = this.getMapper();
            while ((tarEntry = tarInputStream.getNextEntry()) != null) {
                this.extractFile(FileUtils.getFileUtils(), null, file, tarInputStream, tarEntry.getName(), tarEntry.getModTime(), tarEntry.isDirectory(), fileNameMapper);
            }
            this.log("expand complete", 3);
        }
        catch (Throwable throwable) {
            FileUtils.close(tarInputStream);
            throw throwable;
        }
        FileUtils.close(tarInputStream);
    }

    public static final class UntarCompressionMethod
    extends EnumeratedAttribute {
        private static final String NONE = "none";
        private static final String GZIP = "gzip";
        private static final String BZIP2 = "bzip2";

        public UntarCompressionMethod() {
            this.setValue(NONE);
        }

        @Override
        public String[] getValues() {
            return new String[]{NONE, GZIP, BZIP2};
        }

        public InputStream decompress(String string, InputStream inputStream) throws IOException, BuildException {
            String string2 = this.getValue();
            if (GZIP.equals(string2)) {
                return new GZIPInputStream(inputStream);
            }
            if (BZIP2.equals(string2)) {
                char[] cArray = new char[]{'B', 'Z'};
                for (int i = 0; i < cArray.length; ++i) {
                    if (inputStream.read() == cArray[i]) continue;
                    throw new BuildException("Invalid bz2 file." + string);
                }
                return new CBZip2InputStream(inputStream);
            }
            return inputStream;
        }
    }
}

