/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;

public abstract class Unpack
extends Task {
    protected File source;
    protected File dest;
    protected Resource srcResource;

    public void setSrc(String string) {
        this.log("DEPRECATED - The setSrc(String) method has been deprecated. Use setSrc(File) instead.");
        this.setSrc(this.getProject().resolveFile(string));
    }

    public void setDest(String string) {
        this.log("DEPRECATED - The setDest(String) method has been deprecated. Use setDest(File) instead.");
        this.setDest(this.getProject().resolveFile(string));
    }

    public void setSrc(File file) {
        this.setSrcResource(new FileResource(file));
    }

    public void setSrcResource(Resource resource) {
        if (!resource.isExists()) {
            throw new BuildException("the archive " + resource.getName() + " doesn't exist");
        }
        if (resource.isDirectory()) {
            throw new BuildException("the archive " + resource.getName() + " can't be a directory");
        }
        if (resource instanceof FileResource) {
            this.source = ((FileResource)resource).getFile();
        } else if (!this.supportsNonFileResources()) {
            throw new BuildException("The source " + resource.getName() + " is not a FileSystem " + "Only FileSystem resources are" + " supported.");
        }
        this.srcResource = resource;
    }

    public void addConfigured(ResourceCollection resourceCollection) {
        if (resourceCollection.size() != 1) {
            throw new BuildException("only single argument resource collections are supported as archives");
        }
        this.setSrcResource((Resource)resourceCollection.iterator().next());
    }

    public void setDest(File file) {
        this.dest = file;
    }

    private void validate() throws BuildException {
        if (this.srcResource == null) {
            throw new BuildException("No Src specified", this.getLocation());
        }
        if (this.dest == null) {
            this.dest = new File(this.source.getParent());
        }
        if (this.dest.isDirectory()) {
            String string = this.getDefaultExtension();
            this.createDestFile(string);
        }
    }

    private void createDestFile(String string) {
        String string2 = this.source.getName();
        int n = string2.length();
        this.dest = string != null && n > string.length() && string.equalsIgnoreCase(string2.substring(n - string.length())) ? new File(this.dest, string2.substring(0, n - string.length())) : new File(this.dest, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        File file = this.dest;
        try {
            this.validate();
            this.extract();
        }
        finally {
            this.dest = file;
        }
    }

    protected abstract String getDefaultExtension();

    protected abstract void extract();

    protected boolean supportsNonFileResources() {
        return false;
    }
}

