/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileUtils;

public class Truncate
extends Task {
    private static final int BUFFER_SIZE = 1024;
    private static final Long ZERO = new Long(0L);
    private static final String NO_CHILD = "No files specified.";
    private static final String INVALID_LENGTH = "Cannot truncate to length ";
    private static final String READ_WRITE = "rw";
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private static final byte[] FILL_BUFFER = new byte[1024];
    private Path path;
    private boolean create = true;
    private boolean mkdirs = false;
    private Long length;
    private Long adjust;

    public void setFile(File file) {
        this.add(new FileResource(file));
    }

    public void add(ResourceCollection resourceCollection) {
        this.getPath().add(resourceCollection);
    }

    public void setAdjust(Long l) {
        this.adjust = l;
    }

    public void setLength(Long l) {
        this.length = l;
        if (l != null && l < 0L) {
            throw new BuildException(INVALID_LENGTH + l);
        }
    }

    public void setCreate(boolean bl) {
        this.create = bl;
    }

    public void setMkdirs(boolean bl) {
        this.mkdirs = bl;
    }

    @Override
    public void execute() {
        if (this.length != null && this.adjust != null) {
            throw new BuildException("length and adjust are mutually exclusive options");
        }
        if (this.length == null && this.adjust == null) {
            this.length = ZERO;
        }
        if (this.path == null) {
            throw new BuildException(NO_CHILD);
        }
        Iterator iterator = this.path.iterator();
        while (iterator.hasNext()) {
            File file = ((FileResource)iterator.next()).getFile();
            if (!this.shouldProcess(file)) continue;
            this.process(file);
        }
    }

    private boolean shouldProcess(File file) {
        if (file.isFile()) {
            return true;
        }
        if (!this.create) {
            return false;
        }
        IOException iOException = null;
        try {
            if (FILE_UTILS.createNewFile(file, this.mkdirs)) {
                return true;
            }
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        String string = "Unable to create " + file;
        if (iOException == null) {
            this.log(string, 1);
            return false;
        }
        throw new BuildException(string, iOException);
    }

    private void process(File file) {
        long l;
        long l2 = file.length();
        long l3 = l = this.length == null ? l2 + this.adjust : this.length;
        if (l2 == l) {
            return;
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, READ_WRITE);
        }
        catch (Exception exception) {
            throw new BuildException("Could not open " + file + " for writing", exception);
        }
        try {
            if (l > l2) {
                long l4;
                long l5;
                randomAccessFile.seek(l5);
                for (l5 = l2; l5 < l; l5 += l4) {
                    l4 = Math.min((long)FILL_BUFFER.length, l - l5);
                    randomAccessFile.write(FILL_BUFFER, 0, (int)l4);
                }
            } else {
                randomAccessFile.setLength(l);
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Exception working with " + randomAccessFile, iOException);
        }
        finally {
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                this.log("Caught " + iOException + " closing " + randomAccessFile, 1);
            }
        }
    }

    private synchronized Path getPath() {
        if (this.path == null) {
            this.path = new Path(this.getProject());
        }
        return this.path;
    }
}

