/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Touchable;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;

public class Touch
extends Task {
    private static final DateFormatFactory DEFAULT_DF_FACTORY = new DateFormatFactory(){

        @Override
        public DateFormat getPrimaryFormat() {
            return DateFormat.getDateTimeInstance(3, 3, Locale.US);
        }

        @Override
        public DateFormat getFallbackFormat() {
            return DateFormat.getDateTimeInstance(3, 2, Locale.US);
        }
    };
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private File file;
    private long millis = -1L;
    private String dateTime;
    private Vector filesets = new Vector();
    private Union resources;
    private boolean dateTimeConfigured;
    private boolean mkdirs;
    private boolean verbose = true;
    private FileNameMapper fileNameMapper = null;
    private DateFormatFactory dfFactory = DEFAULT_DF_FACTORY;

    public void setFile(File file) {
        this.file = file;
    }

    public void setMillis(long l) {
        this.millis = l;
    }

    public void setDatetime(String string) {
        if (this.dateTime != null) {
            this.log("Resetting datetime attribute to " + string, 3);
        }
        this.dateTime = string;
        this.dateTimeConfigured = false;
    }

    public void setMkdirs(boolean bl) {
        this.mkdirs = bl;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setPattern(final String string) {
        this.dfFactory = new DateFormatFactory(){

            @Override
            public DateFormat getPrimaryFormat() {
                return new SimpleDateFormat(string);
            }

            @Override
            public DateFormat getFallbackFormat() {
                return null;
            }
        };
    }

    public void addConfiguredMapper(Mapper mapper) {
        this.add(mapper.getImplementation());
    }

    public void add(FileNameMapper fileNameMapper) throws BuildException {
        if (this.fileNameMapper != null) {
            throw new BuildException("Only one mapper may be added to the " + this.getTaskName() + " task.");
        }
        this.fileNameMapper = fileNameMapper;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.add(fileSet);
        this.add(fileSet);
    }

    public void addFilelist(FileList fileList) {
        this.add(fileList);
    }

    public synchronized void add(ResourceCollection resourceCollection) {
        this.resources = this.resources == null ? new Union() : this.resources;
        this.resources.add(resourceCollection);
    }

    protected synchronized void checkConfiguration() throws BuildException {
        if (this.file == null && this.resources == null) {
            throw new BuildException("Specify at least one source--a file or resource collection.");
        }
        if (this.file != null && this.file.exists() && this.file.isDirectory()) {
            throw new BuildException("Use a resource collection to touch directories.");
        }
        if (this.dateTime != null && !this.dateTimeConfigured) {
            long l = this.millis;
            DateFormat dateFormat = this.dfFactory.getPrimaryFormat();
            ParseException parseException = null;
            try {
                l = dateFormat.parse(this.dateTime).getTime();
            }
            catch (ParseException parseException2) {
                dateFormat = this.dfFactory.getFallbackFormat();
                if (dateFormat == null) {
                    parseException = parseException2;
                }
                try {
                    l = dateFormat.parse(this.dateTime).getTime();
                }
                catch (ParseException parseException3) {
                    parseException = parseException3;
                }
            }
            if (parseException != null) {
                throw new BuildException(parseException.getMessage(), parseException, this.getLocation());
            }
            if (l < 0L) {
                throw new BuildException("Date of " + this.dateTime + " results in negative " + "milliseconds value " + "relative to epoch " + "(January 1, 1970, " + "00:00:00 GMT).");
            }
            this.log("Setting millis to " + l + " from datetime attribute", this.millis < 0L ? 4 : 3);
            this.setMillis(l);
            this.dateTimeConfigured = true;
        }
    }

    @Override
    public void execute() throws BuildException {
        this.checkConfiguration();
        this.touch();
    }

    protected void touch() throws BuildException {
        long l = this.getTimestamp();
        if (this.file != null) {
            this.touch(new FileResource(this.file.getParentFile(), this.file.getName()), l);
        }
        if (this.resources == null) {
            return;
        }
        Iterator iterator = this.resources.iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            if (!(resource instanceof Touchable)) {
                throw new BuildException("Can't touch " + resource);
            }
            this.touch(resource, l);
        }
        for (int i = 0; i < this.filesets.size(); ++i) {
            FileSet fileSet = (FileSet)this.filesets.elementAt(i);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            File file = fileSet.getDir(this.getProject());
            String[] stringArray = directoryScanner.getIncludedDirectories();
            for (int j = 0; j < stringArray.length; ++j) {
                this.touch(new FileResource(file, stringArray[j]), l);
            }
        }
    }

    protected void touch(File file) {
        this.touch(file, this.getTimestamp());
    }

    private long getTimestamp() {
        return this.millis < 0L ? System.currentTimeMillis() : this.millis;
    }

    private void touch(Resource resource, long l) {
        if (this.fileNameMapper == null) {
            if (resource instanceof FileResource) {
                this.touch(((FileResource)resource).getFile(), l);
            } else {
                ((Touchable)((Object)resource)).touch(l);
            }
        } else {
            String[] stringArray = this.fileNameMapper.mapFileName(resource.getName());
            if (stringArray != null && stringArray.length > 0) {
                long l2 = resource.isExists() ? resource.getLastModified() : l;
                for (int i = 0; i < stringArray.length; ++i) {
                    this.touch(this.getProject().resolveFile(stringArray[i]), l2);
                }
            }
        }
    }

    private void touch(File file, long l) {
        if (!file.exists()) {
            this.log("Creating " + file, this.verbose ? 2 : 3);
            try {
                FILE_UTILS.createNewFile(file, this.mkdirs);
            }
            catch (IOException iOException) {
                throw new BuildException("Could not create " + file, iOException, this.getLocation());
            }
        }
        if (!file.canWrite()) {
            throw new BuildException("Can not change modification date of read-only file " + file);
        }
        FILE_UTILS.setFileLastModified(file, l);
    }

    private static interface DateFormatFactory {
        public DateFormat getPrimaryFormat();

        public DateFormat getFallbackFormat();
    }
}

