/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.AbstractJarSignerTask;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.taskdefs.condition.IsSigned;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.IdentityMapper;

public class SignJar
extends AbstractJarSignerTask {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    protected String sigfile;
    protected File signedjar;
    protected boolean internalsf;
    protected boolean sectionsonly;
    private boolean preserveLastModified;
    protected boolean lazy;
    protected File destDir;
    private FileNameMapper mapper;
    protected String tsaurl;
    protected String tsacert;
    public static final String ERROR_TODIR_AND_SIGNEDJAR = "'destdir' and 'signedjar' cannot both be set";
    public static final String ERROR_TOO_MANY_MAPPERS = "Too many mappers";
    public static final String ERROR_SIGNEDJAR_AND_PATHS = "You cannot specify the signed JAR when using paths or filesets";
    public static final String ERROR_BAD_MAP = "Cannot map source file to anything sensible: ";
    public static final String ERROR_MAPPER_WITHOUT_DEST = "The destDir attribute is required if a mapper is set";
    public static final String ERROR_NO_ALIAS = "alias attribute must be set";
    public static final String ERROR_NO_STOREPASS = "storepass attribute must be set";

    public void setSigfile(String string) {
        this.sigfile = string;
    }

    public void setSignedjar(File file) {
        this.signedjar = file;
    }

    public void setInternalsf(boolean bl) {
        this.internalsf = bl;
    }

    public void setSectionsonly(boolean bl) {
        this.sectionsonly = bl;
    }

    public void setLazy(boolean bl) {
        this.lazy = bl;
    }

    public void setDestDir(File file) {
        this.destDir = file;
    }

    public void add(FileNameMapper fileNameMapper) {
        if (this.mapper != null) {
            throw new BuildException(ERROR_TOO_MANY_MAPPERS);
        }
        this.mapper = fileNameMapper;
    }

    public FileNameMapper getMapper() {
        return this.mapper;
    }

    public String getTsaurl() {
        return this.tsaurl;
    }

    public void setTsaurl(String string) {
        this.tsaurl = string;
    }

    public String getTsacert() {
        return this.tsacert;
    }

    public void setTsacert(String string) {
        this.tsacert = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        boolean bl;
        boolean bl2 = this.jar != null;
        boolean bl3 = this.signedjar != null;
        boolean bl4 = this.destDir != null;
        boolean bl5 = bl = this.mapper != null;
        if (!bl2 && !this.hasResources()) {
            throw new BuildException("jar must be set through jar attribute or nested filesets");
        }
        if (null == this.alias) {
            throw new BuildException(ERROR_NO_ALIAS);
        }
        if (null == this.storepass) {
            throw new BuildException(ERROR_NO_STOREPASS);
        }
        if (bl4 && bl3) {
            throw new BuildException(ERROR_TODIR_AND_SIGNEDJAR);
        }
        if (this.hasResources() && bl3) {
            throw new BuildException(ERROR_SIGNEDJAR_AND_PATHS);
        }
        if (!bl4 && bl) {
            throw new BuildException(ERROR_MAPPER_WITHOUT_DEST);
        }
        this.beginExecution();
        try {
            if (bl2 && bl3) {
                this.signOneJar(this.jar, this.signedjar);
                return;
            }
            Path path = this.createUnifiedSourcePath();
            FileNameMapper fileNameMapper = bl ? this.mapper : new IdentityMapper();
            Iterator iterator = path.iterator();
            while (iterator.hasNext()) {
                FileResource fileResource = (FileResource)iterator.next();
                File file = bl4 ? this.destDir : fileResource.getBaseDir();
                String[] stringArray = fileNameMapper.mapFileName(fileResource.getName());
                if (stringArray == null || stringArray.length != 1) {
                    throw new BuildException(ERROR_BAD_MAP + fileResource.getFile());
                }
                File file2 = new File(file, stringArray[0]);
                this.signOneJar(fileResource.getFile(), file2);
            }
        }
        finally {
            this.endExecution();
        }
    }

    private void signOneJar(File file, File file2) throws BuildException {
        File file3 = file2;
        if (file3 == null) {
            file3 = file;
        }
        if (this.isUpToDate(file, file3)) {
            return;
        }
        long l = file.lastModified();
        ExecTask execTask = this.createJarSigner();
        this.setCommonOptions(execTask);
        this.bindToKeystore(execTask);
        if (null != this.sigfile) {
            this.addValue(execTask, "-sigfile");
            String string = this.sigfile;
            this.addValue(execTask, string);
        }
        if (!file.equals(file3)) {
            this.addValue(execTask, "-signedjar");
            this.addValue(execTask, file3.getPath());
        }
        if (this.internalsf) {
            this.addValue(execTask, "-internalsf");
        }
        if (this.sectionsonly) {
            this.addValue(execTask, "-sectionsonly");
        }
        this.addTimestampAuthorityCommands(execTask);
        this.addValue(execTask, file.getPath());
        this.addValue(execTask, this.alias);
        this.log("Signing JAR: " + file.getAbsolutePath() + " to " + file3.getAbsolutePath() + " as " + this.alias);
        execTask.execute();
        if (this.preserveLastModified) {
            file3.setLastModified(l);
        }
    }

    private void addTimestampAuthorityCommands(ExecTask execTask) {
        if (this.tsaurl != null) {
            this.addValue(execTask, "-tsa");
            this.addValue(execTask, this.tsaurl);
        }
        if (this.tsacert != null) {
            this.addValue(execTask, "-tsacert");
            this.addValue(execTask, this.tsacert);
        }
    }

    protected boolean isUpToDate(File file, File file2) {
        if (null == file || !file.exists()) {
            return false;
        }
        File file3 = file2;
        if (file3 == null) {
            file3 = file;
        }
        if (file.equals(file3)) {
            if (this.lazy) {
                return this.isSigned(file);
            }
            return false;
        }
        return FILE_UTILS.isUpToDate(file, file3);
    }

    protected boolean isSigned(File file) {
        try {
            return IsSigned.isSigned(file, this.alias);
        }
        catch (IOException iOException) {
            this.log(iOException.toString(), 3);
            return false;
        }
    }

    public void setPreserveLastModified(boolean bl) {
        this.preserveLastModified = bl;
    }
}

