/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.util.StringUtils;

public class Retry
extends Task
implements TaskContainer {
    private Task nestedTask;
    private int retryCount = 1;

    @Override
    public synchronized void addTask(Task task) {
        if (this.nestedTask != null) {
            throw new BuildException("The retry task container accepts a single nested task (which may be a sequential task container)");
        }
        this.nestedTask = task;
    }

    public void setRetryCount(int n) {
        this.retryCount = n;
    }

    @Override
    public void execute() throws BuildException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i <= this.retryCount; ++i) {
            try {
                this.nestedTask.perform();
                break;
            }
            catch (Exception exception) {
                stringBuffer.append(exception.getMessage());
                if (i >= this.retryCount) {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    stringBuffer2.append("Task [").append(this.nestedTask.getTaskName());
                    stringBuffer2.append("] failed after [").append(this.retryCount);
                    stringBuffer2.append("] attempts; giving up.").append(StringUtils.LINE_SEP);
                    stringBuffer2.append("Error messages:").append(StringUtils.LINE_SEP);
                    stringBuffer2.append(stringBuffer);
                    throw new BuildException(stringBuffer2.toString(), this.getLocation());
                }
                this.log("Attempt [" + i + "]: error occurred; retrying...", exception, 2);
                stringBuffer.append(StringUtils.LINE_SEP);
                continue;
            }
        }
    }
}

