/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.SubBuildListener;
import org.apache.tools.ant.util.StringUtils;

public class RecorderEntry
implements BuildLogger,
SubBuildListener {
    private String filename = null;
    private boolean record = true;
    private int loglevel = 2;
    private PrintStream out = null;
    private long targetStartTime = System.currentTimeMillis();
    private boolean emacsMode = false;
    private Project project;

    protected RecorderEntry(String string) {
        this.filename = string;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setRecordState(Boolean bl) {
        if (bl != null) {
            this.flush();
            this.record = bl;
        }
    }

    @Override
    public void buildStarted(BuildEvent buildEvent) {
        this.log("> BUILD STARTED", 4);
    }

    @Override
    public void buildFinished(BuildEvent buildEvent) {
        this.log("< BUILD FINISHED", 4);
        if (this.record && this.out != null) {
            Throwable throwable = buildEvent.getException();
            if (throwable == null) {
                this.out.println(StringUtils.LINE_SEP + "BUILD SUCCESSFUL");
            } else {
                this.out.println(StringUtils.LINE_SEP + "BUILD FAILED" + StringUtils.LINE_SEP);
                throwable.printStackTrace(this.out);
            }
        }
        this.cleanup();
    }

    @Override
    public void subBuildFinished(BuildEvent buildEvent) {
        if (buildEvent.getProject() == this.project) {
            this.cleanup();
        }
    }

    @Override
    public void subBuildStarted(BuildEvent buildEvent) {
    }

    @Override
    public void targetStarted(BuildEvent buildEvent) {
        this.log(">> TARGET STARTED -- " + buildEvent.getTarget(), 4);
        this.log(StringUtils.LINE_SEP + buildEvent.getTarget().getName() + ":", 2);
        this.targetStartTime = System.currentTimeMillis();
    }

    @Override
    public void targetFinished(BuildEvent buildEvent) {
        this.log("<< TARGET FINISHED -- " + buildEvent.getTarget(), 4);
        String string = RecorderEntry.formatTime(System.currentTimeMillis() - this.targetStartTime);
        this.log(buildEvent.getTarget() + ":  duration " + string, 3);
        this.flush();
    }

    @Override
    public void taskStarted(BuildEvent buildEvent) {
        this.log(">>> TASK STARTED -- " + buildEvent.getTask(), 4);
    }

    @Override
    public void taskFinished(BuildEvent buildEvent) {
        this.log("<<< TASK FINISHED -- " + buildEvent.getTask(), 4);
        this.flush();
    }

    @Override
    public void messageLogged(BuildEvent buildEvent) {
        this.log("--- MESSAGE LOGGED", 4);
        StringBuffer stringBuffer = new StringBuffer();
        if (buildEvent.getTask() != null) {
            String string = buildEvent.getTask().getTaskName();
            if (!this.emacsMode) {
                String string2 = "[" + string + "] ";
                int n = 12 - string2.length();
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(string2);
            }
        }
        stringBuffer.append(buildEvent.getMessage());
        this.log(stringBuffer.toString(), buildEvent.getPriority());
    }

    private void log(String string, int n) {
        if (this.record && n <= this.loglevel && this.out != null) {
            this.out.println(string);
        }
    }

    private void flush() {
        if (this.record && this.out != null) {
            this.out.flush();
        }
    }

    @Override
    public void setMessageOutputLevel(int n) {
        if (n >= 0 && n <= 4) {
            this.loglevel = n;
        }
    }

    @Override
    public void setOutputPrintStream(PrintStream printStream) {
        this.closeFile();
        this.out = printStream;
    }

    @Override
    public void setEmacsMode(boolean bl) {
        this.emacsMode = bl;
    }

    @Override
    public void setErrorPrintStream(PrintStream printStream) {
        this.setOutputPrintStream(printStream);
    }

    private static String formatTime(long l) {
        long l2 = l / 1000L;
        long l3 = l2 / 60L;
        if (l3 > 0L) {
            return Long.toString(l3) + " minute" + (l3 == 1L ? " " : "s ") + Long.toString(l2 % 60L) + " second" + (l2 % 60L == 1L ? "" : "s");
        }
        return Long.toString(l2) + " second" + (l2 % 60L == 1L ? "" : "s");
    }

    public void setProject(Project project) {
        this.project = project;
        if (project != null) {
            project.addBuildListener(this);
        }
    }

    public void cleanup() {
        this.closeFile();
        if (this.project != null) {
            this.project.removeBuildListener(this);
        }
        this.project = null;
    }

    void openFile(boolean bl) throws BuildException {
        this.openFileImpl(bl);
    }

    void closeFile() {
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
    }

    void reopenFile() throws BuildException {
        this.openFileImpl(true);
    }

    private void openFileImpl(boolean bl) throws BuildException {
        if (this.out == null) {
            try {
                this.out = new PrintStream(new FileOutputStream(this.filename, bl));
            }
            catch (IOException iOException) {
                throw new BuildException("Problems opening file using a recorder entry", iOException);
            }
        }
    }
}

