/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.StreamPumper;

public class PumpStreamHandler
implements ExecuteStreamHandler {
    private Thread outputThread;
    private Thread errorThread;
    private StreamPumper inputPump;
    private OutputStream out;
    private OutputStream err;
    private InputStream input;

    public PumpStreamHandler(OutputStream outputStream, OutputStream outputStream2, InputStream inputStream) {
        this.out = outputStream;
        this.err = outputStream2;
        this.input = inputStream;
    }

    public PumpStreamHandler(OutputStream outputStream, OutputStream outputStream2) {
        this(outputStream, outputStream2, null);
    }

    public PumpStreamHandler(OutputStream outputStream) {
        this(outputStream, outputStream);
    }

    public PumpStreamHandler() {
        this(System.out, System.err);
    }

    @Override
    public void setProcessOutputStream(InputStream inputStream) {
        this.createProcessOutputPump(inputStream, this.out);
    }

    @Override
    public void setProcessErrorStream(InputStream inputStream) {
        if (this.err != null) {
            this.createProcessErrorPump(inputStream, this.err);
        }
    }

    @Override
    public void setProcessInputStream(OutputStream outputStream) {
        if (this.input != null) {
            this.inputPump = this.createInputPump(this.input, outputStream, true);
        } else {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void start() {
        this.outputThread.start();
        this.errorThread.start();
        if (this.inputPump != null) {
            Thread thread = new Thread(this.inputPump);
            thread.setDaemon(true);
            thread.start();
        }
    }

    @Override
    public void stop() {
        try {
            this.outputThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.errorThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.inputPump != null) {
            this.inputPump.stop();
        }
        try {
            this.err.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected OutputStream getErr() {
        return this.err;
    }

    protected OutputStream getOut() {
        return this.out;
    }

    protected void createProcessOutputPump(InputStream inputStream, OutputStream outputStream) {
        this.outputThread = this.createPump(inputStream, outputStream);
    }

    protected void createProcessErrorPump(InputStream inputStream, OutputStream outputStream) {
        this.errorThread = this.createPump(inputStream, outputStream);
    }

    protected Thread createPump(InputStream inputStream, OutputStream outputStream) {
        return this.createPump(inputStream, outputStream, false);
    }

    protected Thread createPump(InputStream inputStream, OutputStream outputStream, boolean bl) {
        Thread thread = new Thread(new StreamPumper(inputStream, outputStream, bl));
        thread.setDaemon(true);
        return thread;
    }

    StreamPumper createInputPump(InputStream inputStream, OutputStream outputStream, boolean bl) {
        StreamPumper streamPumper = new StreamPumper(inputStream, outputStream, bl);
        streamPumper.setAutoflush(true);
        return streamPumper;
    }
}

