/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;

class ProcessDestroyer
implements Runnable {
    private static final int TWENTY_SECONDS = 20000;
    private Vector processes = new Vector();
    private Method addShutdownHookMethod;
    private Method removeShutdownHookMethod;
    private ProcessDestroyerImpl destroyProcessThread = null;
    private boolean added = false;
    private boolean running = false;

    ProcessDestroyer() {
        try {
            Class[] classArray = new Class[]{Thread.class};
            this.addShutdownHookMethod = Runtime.class.getMethod("addShutdownHook", classArray);
            this.removeShutdownHookMethod = Runtime.class.getMethod("removeShutdownHook", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void addShutdownHook() {
        if (this.addShutdownHookMethod != null && !this.running) {
            this.destroyProcessThread = new ProcessDestroyerImpl();
            Object[] objectArray = new Object[]{this.destroyProcessThread};
            try {
                this.addShutdownHookMethod.invoke((Object)Runtime.getRuntime(), objectArray);
                this.added = true;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable != null && throwable.getClass() == IllegalStateException.class) {
                    this.running = true;
                }
                invocationTargetException.printStackTrace();
            }
        }
    }

    private void removeShutdownHook() {
        if (this.removeShutdownHookMethod != null && this.added && !this.running) {
            Object[] objectArray = new Object[]{this.destroyProcessThread};
            try {
                Boolean bl = (Boolean)this.removeShutdownHookMethod.invoke((Object)Runtime.getRuntime(), objectArray);
                if (!bl.booleanValue()) {
                    System.err.println("Could not remove shutdown hook");
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable != null && throwable.getClass() == IllegalStateException.class) {
                    this.running = true;
                }
                invocationTargetException.printStackTrace();
            }
            this.destroyProcessThread.setShouldDestroy(false);
            if (!this.destroyProcessThread.getThreadGroup().isDestroyed()) {
                this.destroyProcessThread.start();
            }
            try {
                this.destroyProcessThread.join(20000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.destroyProcessThread = null;
            this.added = false;
        }
    }

    public boolean isAddedAsShutdownHook() {
        return this.added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Process process) {
        Vector vector = this.processes;
        synchronized (vector) {
            if (this.processes.size() == 0) {
                this.addShutdownHook();
            }
            this.processes.addElement(process);
            return this.processes.contains(process);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Process process) {
        Vector vector = this.processes;
        synchronized (vector) {
            boolean bl = this.processes.removeElement(process);
            if (bl && this.processes.size() == 0) {
                this.removeShutdownHook();
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Vector vector = this.processes;
        synchronized (vector) {
            this.running = true;
            Enumeration enumeration = this.processes.elements();
            while (enumeration.hasMoreElements()) {
                ((Process)enumeration.nextElement()).destroy();
            }
        }
    }

    private class ProcessDestroyerImpl
    extends Thread {
        private boolean shouldDestroy;

        public ProcessDestroyerImpl() {
            super("ProcessDestroyer Shutdown Hook");
            this.shouldDestroy = true;
        }

        @Override
        public void run() {
            if (this.shouldDestroy) {
                ProcessDestroyer.this.run();
            }
        }

        public void setShouldDestroy(boolean bl) {
            this.shouldDestroy = bl;
        }
    }
}

