/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.util.FileNameMapper;

public class PathConvert
extends Task {
    private static boolean onWindows = Os.isFamily("dos");
    private Union path = null;
    private Reference refid = null;
    private String targetOS = null;
    private boolean targetWindows = false;
    private boolean setonempty = true;
    private String property = null;
    private Vector prefixMap = new Vector();
    private String pathSep = null;
    private String dirSep = null;
    private Mapper mapper = null;

    public Path createPath() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        Path path = new Path(this.getProject());
        this.add(path);
        return path;
    }

    public void add(ResourceCollection resourceCollection) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.getPath().add(resourceCollection);
    }

    private synchronized Union getPath() {
        if (this.path == null) {
            this.path = new Union();
            this.path.setProject(this.getProject());
        }
        return this.path;
    }

    public MapEntry createMap() {
        MapEntry mapEntry = new MapEntry();
        this.prefixMap.addElement(mapEntry);
        return mapEntry;
    }

    public void setTargetos(String string) {
        TargetOs targetOs = new TargetOs();
        targetOs.setValue(string);
        this.setTargetos(targetOs);
    }

    public void setTargetos(TargetOs targetOs) {
        this.targetOS = targetOs.getValue();
        this.targetWindows = !this.targetOS.equals("unix") && !this.targetOS.equals("tandem");
    }

    public void setSetonempty(boolean bl) {
        this.setonempty = bl;
    }

    public void setProperty(String string) {
        this.property = string;
    }

    public void setRefid(Reference reference) {
        if (this.path != null) {
            throw this.noChildrenAllowed();
        }
        this.refid = reference;
    }

    public void setPathSep(String string) {
        this.pathSep = string;
    }

    public void setDirSep(String string) {
        this.dirSep = string;
    }

    public boolean isReference() {
        return this.refid != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        Union union = this.path;
        String string = this.pathSep;
        String string2 = this.dirSep;
        try {
            Object object;
            Object object2;
            Object object3;
            if (this.isReference()) {
                object3 = this.refid.getReferencedObject(this.getProject());
                if (!(object3 instanceof ResourceCollection)) {
                    throw new BuildException("refid '" + this.refid.getRefId() + "' does not refer to a resource collection.");
                }
                this.getPath().add((ResourceCollection)object3);
            }
            this.validateSetup();
            object3 = onWindows ? "\\" : "/";
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray = this.path.list();
            if (this.mapper != null) {
                FileNameMapper fileNameMapper = this.mapper.getImplementation();
                object2 = new ArrayList();
                for (int i = 0; i < stringArray.length; ++i) {
                    object = fileNameMapper.mapFileName(stringArray[i]);
                    for (int j = 0; object != null && j < ((String[])object).length; ++j) {
                        object2.add(object[j]);
                    }
                }
                stringArray = object2.toArray(new String[object2.size()]);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                object2 = this.mapElement(stringArray[i]);
                if (i != 0) {
                    stringBuffer.append(this.pathSep);
                }
                StringTokenizer stringTokenizer = new StringTokenizer((String)object2, (String)object3, true);
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                    stringBuffer.append((String)(((String)object3).equals(object) ? this.dirSep : object));
                }
            }
            if (this.setonempty || stringBuffer.length() > 0) {
                String string3 = stringBuffer.toString();
                if (this.property == null) {
                    this.log(string3);
                } else {
                    this.log("Set property " + this.property + " = " + string3, 3);
                    this.getProject().setNewProperty(this.property, string3);
                }
            }
        }
        finally {
            this.path = union;
            this.dirSep = string2;
            this.pathSep = string;
        }
    }

    private String mapElement(String string) {
        int n = this.prefixMap.size();
        if (n != 0) {
            for (int i = 0; i < n; ++i) {
                MapEntry mapEntry = (MapEntry)this.prefixMap.elementAt(i);
                String string2 = mapEntry.apply(string);
                if (string2 == string) continue;
                string = string2;
                break;
            }
        }
        return string;
    }

    public void addMapper(Mapper mapper) {
        if (this.mapper != null) {
            throw new BuildException("Cannot define more than one mapper");
        }
        this.mapper = mapper;
    }

    public void add(FileNameMapper fileNameMapper) {
        Mapper mapper = new Mapper(this.getProject());
        mapper.add(fileNameMapper);
        this.addMapper(mapper);
    }

    private void validateSetup() throws BuildException {
        if (this.path == null) {
            throw new BuildException("You must specify a path to convert");
        }
        String string = File.separator;
        String string2 = File.pathSeparator;
        if (this.targetOS != null) {
            string2 = this.targetWindows ? ";" : ":";
            String string3 = string = this.targetWindows ? "\\" : "/";
        }
        if (this.pathSep != null) {
            string2 = this.pathSep;
        }
        if (this.dirSep != null) {
            string = this.dirSep;
        }
        this.pathSep = string2;
        this.dirSep = string;
    }

    private BuildException noChildrenAllowed() {
        return new BuildException("You must not specify nested elements when using the refid attribute.");
    }

    public static class TargetOs
    extends EnumeratedAttribute {
        @Override
        public String[] getValues() {
            return new String[]{"windows", "unix", "netware", "os/2", "tandem"};
        }
    }

    public class MapEntry {
        private String from = null;
        private String to = null;

        public void setFrom(String string) {
            this.from = string;
        }

        public void setTo(String string) {
            this.to = string;
        }

        public String apply(String string) {
            if (this.from == null || this.to == null) {
                throw new BuildException("Both 'from' and 'to' must be set in a map entry");
            }
            String string2 = onWindows ? string.toLowerCase().replace('\\', '/') : string;
            String string3 = onWindows ? this.from.toLowerCase().replace('\\', '/') : this.from;
            return string2.startsWith(string3) ? this.to + string.substring(this.from.length()) : string;
        }
    }
}

