/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.util.StringUtils;

public class Parallel
extends Task
implements TaskContainer {
    private Vector nestedTasks = new Vector();
    private final Object semaphore = new Object();
    private int numThreads = 0;
    private int numThreadsPerProcessor = 0;
    private long timeout;
    private volatile boolean stillRunning;
    private boolean timedOut;
    private boolean failOnAny;
    private TaskList daemonTasks;
    private StringBuffer exceptionMessage;
    private int numExceptions = 0;
    private Throwable firstException;
    private Location firstLocation;

    public void addDaemons(TaskList taskList) {
        if (this.daemonTasks != null) {
            throw new BuildException("Only one daemon group is supported");
        }
        this.daemonTasks = taskList;
    }

    public void setPollInterval(int n) {
    }

    public void setFailOnAny(boolean bl) {
        this.failOnAny = bl;
    }

    @Override
    public void addTask(Task task) {
        this.nestedTasks.addElement(task);
    }

    public void setThreadsPerProcessor(int n) {
        this.numThreadsPerProcessor = n;
    }

    public void setThreadCount(int n) {
        this.numThreads = n;
    }

    public void setTimeout(long l) {
        this.timeout = l;
    }

    @Override
    public void execute() throws BuildException {
        this.updateThreadCounts();
        if (this.numThreads == 0) {
            this.numThreads = this.nestedTasks.size();
        }
        this.spinThreads();
    }

    private void updateThreadCounts() {
        int n;
        if (this.numThreadsPerProcessor != 0 && (n = this.getNumProcessors()) != 0) {
            this.numThreads = n * this.numThreadsPerProcessor;
        }
    }

    private void processExceptions(TaskRunnable[] taskRunnableArray) {
        if (taskRunnableArray == null) {
            return;
        }
        for (int i = 0; i < taskRunnableArray.length; ++i) {
            Throwable throwable = taskRunnableArray[i].getException();
            if (throwable == null) continue;
            ++this.numExceptions;
            if (this.firstException == null) {
                this.firstException = throwable;
            }
            if (throwable instanceof BuildException && this.firstLocation == Location.UNKNOWN_LOCATION) {
                this.firstLocation = ((BuildException)throwable).getLocation();
            }
            this.exceptionMessage.append(StringUtils.LINE_SEP);
            this.exceptionMessage.append(throwable.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spinThreads() throws BuildException {
        TaskRunnable[] taskRunnableArray;
        int n = this.nestedTasks.size();
        TaskRunnable[] taskRunnableArray2 = new TaskRunnable[n];
        this.stillRunning = true;
        this.timedOut = false;
        int n2 = 0;
        Enumeration enumeration = this.nestedTasks.elements();
        while (enumeration.hasMoreElements()) {
            taskRunnableArray = (TaskRunnable[])enumeration.nextElement();
            taskRunnableArray2[n2] = new TaskRunnable((Task)taskRunnableArray);
            ++n2;
        }
        int n3 = n < this.numThreads ? n : this.numThreads;
        taskRunnableArray = new TaskRunnable[n3];
        n2 = 0;
        ThreadGroup threadGroup = new ThreadGroup("parallel");
        TaskRunnable[] taskRunnableArray3 = null;
        if (this.daemonTasks != null && this.daemonTasks.tasks.size() != 0) {
            taskRunnableArray3 = new TaskRunnable[this.daemonTasks.tasks.size()];
        }
        Object object = this.semaphore;
        synchronized (object) {
        }
        object = this.semaphore;
        synchronized (object) {
            Thread thread;
            int n4;
            if (taskRunnableArray3 != null) {
                for (n4 = 0; n4 < taskRunnableArray3.length; ++n4) {
                    taskRunnableArray3[n4] = new TaskRunnable((Task)this.daemonTasks.tasks.get(n4));
                    thread = new Thread(threadGroup, taskRunnableArray3[n4]);
                    thread.setDaemon(true);
                    thread.start();
                }
            }
            for (n4 = 0; n4 < n3; ++n4) {
                taskRunnableArray[n4] = taskRunnableArray2[n2++];
                thread = new Thread(threadGroup, taskRunnableArray[n4]);
                thread.start();
            }
            if (this.timeout != 0L) {
                Thread thread2 = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public synchronized void run() {
                        try {
                            this.wait(Parallel.this.timeout);
                            Object object = Parallel.this.semaphore;
                            synchronized (object) {
                                Parallel.this.stillRunning = false;
                                Parallel.this.timedOut = true;
                                Parallel.this.semaphore.notifyAll();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                };
                thread2.start();
            }
            block13: while (n2 < n && this.stillRunning) {
                for (int i = 0; i < n3; ++i) {
                    if (taskRunnableArray[i] != null && !taskRunnableArray[i].isFinished()) continue;
                    taskRunnableArray[i] = taskRunnableArray2[n2++];
                    thread = new Thread(threadGroup, taskRunnableArray[i]);
                    thread.start();
                    continue block13;
                }
                try {
                    this.semaphore.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            block15: while (this.stillRunning) {
                for (int i = 0; i < n3; ++i) {
                    if (taskRunnableArray[i] == null || taskRunnableArray[i].isFinished()) continue;
                    try {
                        this.semaphore.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue block15;
                }
                this.stillRunning = false;
            }
        }
        if (this.timedOut) {
            throw new BuildException("Parallel execution timed out");
        }
        this.exceptionMessage = new StringBuffer();
        this.numExceptions = 0;
        this.firstException = null;
        this.firstLocation = Location.UNKNOWN_LOCATION;
        this.processExceptions(taskRunnableArray3);
        this.processExceptions(taskRunnableArray2);
        if (this.numExceptions == 1) {
            if (this.firstException instanceof BuildException) {
                throw (BuildException)this.firstException;
            }
            throw new BuildException(this.firstException);
        }
        if (this.numExceptions > 1) {
            throw new BuildException(this.exceptionMessage.toString(), this.firstLocation);
        }
    }

    private int getNumProcessors() {
        try {
            Class[] classArray = new Class[]{};
            Method method = Runtime.class.getMethod("availableProcessors", classArray);
            Object[] objectArray = new Object[]{};
            Integer n = (Integer)method.invoke((Object)Runtime.getRuntime(), objectArray);
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private class TaskRunnable
    implements Runnable {
        private Throwable exception;
        private Task task;
        private boolean finished;

        TaskRunnable(Task task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.task.perform();
            }
            catch (Throwable throwable) {
                this.exception = throwable;
                if (Parallel.this.failOnAny) {
                    Parallel.this.stillRunning = false;
                }
            }
            finally {
                Object object = Parallel.this.semaphore;
                synchronized (object) {
                    this.finished = true;
                    Parallel.this.semaphore.notifyAll();
                }
            }
        }

        public Throwable getException() {
            return this.exception;
        }

        boolean isFinished() {
            return this.finished;
        }
    }

    public static class TaskList
    implements TaskContainer {
        private List tasks = new ArrayList();

        @Override
        public void addTask(Task task) {
            this.tasks.add(task);
        }
    }
}

