/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;

public abstract class Pack
extends Task {
    private static final int BUFFER_SIZE = 8192;
    protected File zipFile;
    protected File source;
    private Resource src;

    public void setZipfile(File file) {
        this.zipFile = file;
    }

    public void setDestfile(File file) {
        this.setZipfile(file);
    }

    public void setSrc(File file) {
        this.setSrcResource(new FileResource(file));
    }

    public void setSrcResource(Resource resource) {
        if (resource.isDirectory()) {
            throw new BuildException("the source can't be a directory");
        }
        if (resource instanceof FileResource) {
            this.source = ((FileResource)resource).getFile();
        } else if (!this.supportsNonFileResources()) {
            throw new BuildException("Only FileSystem resources are supported.");
        }
        this.src = resource;
    }

    public void addConfigured(ResourceCollection resourceCollection) {
        if (resourceCollection.size() == 0) {
            throw new BuildException("No resource selected, " + this.getTaskName() + " needs exactly one resource.");
        }
        if (resourceCollection.size() != 1) {
            throw new BuildException(this.getTaskName() + " cannot handle multiple resources at once. (" + resourceCollection.size() + " resources were selected.)");
        }
        this.setSrcResource((Resource)resourceCollection.iterator().next());
    }

    private void validate() throws BuildException {
        if (this.zipFile == null) {
            throw new BuildException("zipfile attribute is required", this.getLocation());
        }
        if (this.zipFile.isDirectory()) {
            throw new BuildException("zipfile attribute must not represent a directory!", this.getLocation());
        }
        if (this.getSrcResource() == null) {
            throw new BuildException("src attribute or nested resource is required", this.getLocation());
        }
    }

    @Override
    public void execute() throws BuildException {
        this.validate();
        Resource resource = this.getSrcResource();
        if (!resource.isExists()) {
            this.log("Nothing to do: " + resource.toString() + " doesn't exist.");
        } else if (this.zipFile.lastModified() < resource.getLastModified()) {
            this.log("Building: " + this.zipFile.getAbsolutePath());
            this.pack();
        } else {
            this.log("Nothing to do: " + this.zipFile.getAbsolutePath() + " is up to date.");
        }
    }

    private void zipFile(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[8192];
        int n = 0;
        do {
            outputStream.write(byArray, 0, n);
        } while ((n = inputStream.read(byArray, 0, byArray.length)) != -1);
    }

    protected void zipFile(File file, OutputStream outputStream) throws IOException {
        this.zipResource(new FileResource(file), outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zipResource(Resource resource, OutputStream outputStream) throws IOException {
        InputStream inputStream = resource.getInputStream();
        try {
            this.zipFile(inputStream, outputStream);
        }
        finally {
            inputStream.close();
        }
    }

    protected abstract void pack();

    public Resource getSrcResource() {
        return this.src;
    }

    protected boolean supportsNonFileResources() {
        return false;
    }
}

