/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Nice
extends Task {
    private Integer newPriority;
    private String currentPriority;

    @Override
    public void execute() throws BuildException {
        Thread thread = Thread.currentThread();
        int n = thread.getPriority();
        if (this.currentPriority != null) {
            String string = Integer.toString(n);
            this.getProject().setNewProperty(this.currentPriority, string);
        }
        if (this.newPriority != null && n != this.newPriority) {
            try {
                thread.setPriority(this.newPriority);
            }
            catch (SecurityException securityException) {
                this.log("Unable to set new priority -a security manager is in the way", 1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new BuildException("Priority out of range", illegalArgumentException);
            }
        }
    }

    public void setCurrentPriority(String string) {
        this.currentPriority = string;
    }

    public void setNewPriority(int n) {
        if (n < 1 || n > 10) {
            throw new BuildException("The thread priority is out of the range 1-10");
        }
        this.newPriority = new Integer(n);
    }
}

