/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;

public class Move
extends Copy {
    public Move() {
        this.setOverwrite(true);
    }

    @Override
    protected void validateAttributes() throws BuildException {
        if (this.file != null && this.file.isDirectory()) {
            if (this.destFile != null && this.destDir != null || this.destFile == null && this.destDir == null) {
                throw new BuildException("One and only one of tofile and todir must be set.");
            }
            this.destFile = this.destFile == null ? new File(this.destDir, this.file.getName()) : this.destFile;
            this.destDir = this.destDir == null ? this.destFile.getParentFile() : this.destDir;
            this.completeDirMap.put(this.file, this.destFile);
            this.file = null;
        } else {
            super.validateAttributes();
        }
    }

    @Override
    protected void doFileOperations() {
        int n;
        Object object;
        Object object2;
        if (this.completeDirMap.size() > 0) {
            for (Object object3 : this.completeDirMap.keySet()) {
                Object object4 = (File)this.completeDirMap.get(object3);
                boolean bl = false;
                try {
                    this.log("Attempting to rename dir: " + object3 + " to " + object4, this.verbosity);
                    bl = this.renameFile((File)object3, (File)object4, this.filtering, this.forceOverwrite);
                }
                catch (IOException iOException) {
                    object2 = "Failed to rename dir " + object3 + " to " + object4 + " due to " + iOException.getMessage();
                    throw new BuildException((String)object2, iOException, this.getLocation());
                }
                if (bl) continue;
                FileSet fileSet = new FileSet();
                fileSet.setProject(this.getProject());
                fileSet.setDir((File)object3);
                this.addFileset(fileSet);
                object2 = fileSet.getDirectoryScanner(this.getProject());
                String[] stringArray = ((DirectoryScanner)object2).getIncludedFiles();
                object = ((DirectoryScanner)object2).getIncludedDirectories();
                this.scan((File)object3, (File)object4, stringArray, (String[])object);
            }
        }
        if ((n = this.fileCopyMap.size()) > 0) {
            this.log("Moving " + n + " file" + (n == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath());
            for (Object object4 : this.fileCopyMap.keySet()) {
                File file = new File((String)object4);
                boolean bl = false;
                if (!file.exists()) continue;
                object2 = (String[])this.fileCopyMap.get(object4);
                for (int i = 0; i < ((String[])object2).length; ++i) {
                    object = object2[i];
                    if (((String)object4).equals(object)) {
                        this.log("Skipping self-move of " + (String)object4, this.verbosity);
                        bl = true;
                        continue;
                    }
                    File file2 = new File((String)object);
                    if (i + 1 == ((Object)object2).length && !bl) {
                        this.moveFile(file, file2, this.filtering, this.forceOverwrite);
                        continue;
                    }
                    this.copyFile(file, file2, this.filtering, this.forceOverwrite);
                }
            }
        }
        if (this.includeEmpty) {
            int n2 = 0;
            for (String string : this.dirCopyMap.keySet()) {
                String[] stringArray = (String[])this.dirCopyMap.get(string);
                boolean bl = false;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (string.equals(stringArray[i])) {
                        this.log("Skipping self-move of " + string, this.verbosity);
                        bl = true;
                        continue;
                    }
                    object = new File(stringArray[i]);
                    if (object.exists()) continue;
                    if (!object.mkdirs()) {
                        this.log("Unable to create directory " + object.getAbsolutePath(), 0);
                        continue;
                    }
                    ++n2;
                }
                File file = new File(string);
                if (bl || !this.okToDelete(file)) continue;
                this.deleteDir(file);
            }
            if (n2 > 0) {
                this.log("Moved " + this.dirCopyMap.size() + " empty director" + (this.dirCopyMap.size() == 1 ? "y" : "ies") + " to " + n2 + " empty director" + (n2 == 1 ? "y" : "ies") + " under " + this.destDir.getAbsolutePath());
            }
        }
    }

    private void moveFile(File file, File file2, boolean bl, boolean bl2) {
        boolean bl3 = false;
        try {
            this.log("Attempting to rename: " + file + " to " + file2, this.verbosity);
            bl3 = this.renameFile(file, file2, bl, this.forceOverwrite);
        }
        catch (IOException iOException) {
            String string = "Failed to rename " + file + " to " + file2 + " due to " + iOException.getMessage();
            throw new BuildException(string, iOException, this.getLocation());
        }
        if (!bl3) {
            this.copyFile(file, file2, bl, bl2);
            if (!file.delete()) {
                throw new BuildException("Unable to delete file " + file.getAbsolutePath());
            }
        }
    }

    private void copyFile(File file, File file2, boolean bl, boolean bl2) {
        try {
            this.log("Copying " + file + " to " + file2, this.verbosity);
            FilterSetCollection filterSetCollection = new FilterSetCollection();
            if (bl) {
                filterSetCollection.addFilterSet(this.getProject().getGlobalFilterSet());
            }
            Iterator iterator = this.getFilterSets().iterator();
            while (iterator.hasNext()) {
                filterSetCollection.addFilterSet((FilterSet)iterator.next());
            }
            this.getFileUtils().copyFile(file, file2, filterSetCollection, this.getFilterChains(), this.forceOverwrite, this.getPreserveLastModified(), this.getEncoding(), this.getOutputEncoding(), this.getProject());
        }
        catch (IOException iOException) {
            String string = "Failed to copy " + file + " to " + file2 + " due to " + iOException.getMessage();
            throw new BuildException(string, iOException, this.getLocation());
        }
    }

    protected boolean okToDelete(File file) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            File file2 = new File(file, string);
            if (file2.isDirectory()) {
                if (this.okToDelete(file2)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    protected void deleteDir(File file) {
        this.deleteDir(file, false);
    }

    protected void deleteDir(File file, boolean bl) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            File file2 = new File(file, string);
            if (!file2.isDirectory()) {
                if (bl && !file2.delete()) {
                    throw new BuildException("Unable to delete file " + file2.getAbsolutePath());
                }
                throw new BuildException("UNEXPECTED ERROR - The file " + file2.getAbsolutePath() + " should not exist!");
            }
            this.deleteDir(file2);
        }
        this.log("Deleting directory " + file.getAbsolutePath(), this.verbosity);
        if (!file.delete()) {
            throw new BuildException("Unable to delete directory " + file.getAbsolutePath());
        }
    }

    protected boolean renameFile(File file, File file2, boolean bl, boolean bl2) throws IOException, BuildException {
        if (file2.isDirectory() || bl || this.getFilterSets().size() > 0 || this.getFilterChains().size() > 0) {
            return false;
        }
        File file3 = file2.getParentFile();
        if (file3 != null && !file3.exists()) {
            file3.mkdirs();
        } else if (file2.isFile()) {
            file = this.getFileUtils().normalize(file.getAbsolutePath()).getCanonicalFile();
            file2 = this.getFileUtils().normalize(file2.getAbsolutePath());
            if (file2.equals(file)) {
                return true;
            }
            if (!file.equals(file2.getCanonicalFile()) && !file2.delete()) {
                throw new BuildException("Unable to remove existing file " + file2);
            }
        }
        return file.renameTo(file2);
    }
}

