/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.UnsupportedEncodingException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.launch.Locator;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;

public class ManifestClassPath
extends Task {
    private String name;
    private File dir;
    private int maxParentLevels = 2;
    private Path path;

    @Override
    public void execute() {
        if (this.name == null) {
            throw new BuildException("Missing 'property' attribute!");
        }
        if (this.dir == null) {
            throw new BuildException("Missing 'jarfile' attribute!");
        }
        if (this.getProject().getProperty(this.name) != null) {
            throw new BuildException("Property '" + this.name + "' already set!");
        }
        if (this.path == null) {
            throw new BuildException("Missing nested <classpath>!");
        }
        FileUtils fileUtils = FileUtils.getFileUtils();
        File file = this.dir = fileUtils.normalize(this.dir.getAbsolutePath());
        String[] stringArray = new String[this.maxParentLevels + 1];
        for (int i = 0; i < this.maxParentLevels + 1; ++i) {
            stringArray[i] = file.getAbsolutePath() + File.separatorChar;
            if ((file = file.getParentFile()) != null) continue;
            this.maxParentLevels = i + 1;
            break;
        }
        String[] stringArray2 = this.path.list();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < stringArray2.length; ++i) {
            File file2 = new File(stringArray2[i]);
            file2 = fileUtils.normalize(file2.getAbsolutePath());
            String string = file2.getAbsolutePath();
            String string2 = null;
            for (int j = 0; j <= this.maxParentLevels; ++j) {
                String string3 = stringArray[j];
                if (!string.startsWith(string3)) continue;
                stringBuffer2.setLength(0);
                for (int k = 0; k < j; ++k) {
                    stringBuffer2.append("..");
                    stringBuffer2.append(File.separatorChar);
                }
                stringBuffer2.append(string.substring(string3.length()));
                string2 = stringBuffer2.toString();
                break;
            }
            if (string2 == null) {
                throw new BuildException("No suitable relative path from " + this.dir + " to " + string);
            }
            if (File.separatorChar != '/') {
                string2 = string2.replace(File.separatorChar, '/');
            }
            if (file2.isDirectory()) {
                string2 = string2 + '/';
            }
            try {
                string2 = Locator.encodeURI((String)string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new BuildException(unsupportedEncodingException);
            }
            stringBuffer.append(string2);
            stringBuffer.append(' ');
        }
        this.getProject().setNewProperty(this.name, stringBuffer.toString().trim());
    }

    public void setProperty(String string) {
        this.name = string;
    }

    public void setJarFile(File file) {
        File file2 = file.getParentFile();
        if (!file2.isDirectory()) {
            throw new BuildException("Jar's directory not found: " + file2);
        }
        this.dir = file2;
    }

    public void setMaxParentLevels(int n) {
        this.maxParentLevels = n;
    }

    public void addClassPath(Path path) {
        this.path = path;
    }
}

