/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tools.ant.AntTypeDefinition;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.taskdefs.AntlibDefinition;
import org.apache.tools.ant.taskdefs.MacroInstance;

public class MacroDef
extends AntlibDefinition {
    private NestedSequential nestedSequential;
    private String name;
    private boolean backTrace = true;
    private List attributes = new ArrayList();
    private Map elements = new HashMap();
    private String textName = null;
    private Text text = null;
    private boolean hasImplicitElement = false;

    public void setName(String string) {
        this.name = string;
    }

    public void addConfiguredText(Text text) {
        if (this.text != null) {
            throw new BuildException("Only one nested text element allowed");
        }
        if (text.getName() == null) {
            throw new BuildException("the text nested element needed a \"name\" attribute");
        }
        for (Attribute attribute : this.attributes) {
            if (!text.getName().equals(attribute.getName())) continue;
            throw new BuildException("the name \"" + text.getName() + "\" is already used as an attribute");
        }
        this.text = text;
        this.textName = text.getName();
    }

    public Text getText() {
        return this.text;
    }

    public void setBackTrace(boolean bl) {
        this.backTrace = bl;
    }

    public boolean getBackTrace() {
        return this.backTrace;
    }

    public NestedSequential createSequential() {
        if (this.nestedSequential != null) {
            throw new BuildException("Only one sequential allowed");
        }
        this.nestedSequential = new NestedSequential();
        return this.nestedSequential;
    }

    public UnknownElement getNestedTask() {
        UnknownElement unknownElement = new UnknownElement("sequential");
        unknownElement.setTaskName("sequential");
        unknownElement.setNamespace("");
        unknownElement.setQName("sequential");
        new RuntimeConfigurable(unknownElement, "sequential");
        for (int i = 0; i < this.nestedSequential.getNested().size(); ++i) {
            UnknownElement unknownElement2 = (UnknownElement)this.nestedSequential.getNested().get(i);
            unknownElement.addChild(unknownElement2);
            unknownElement.getWrapper().addChild(unknownElement2.getWrapper());
        }
        return unknownElement;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public Map getElements() {
        return this.elements;
    }

    public static boolean isValidNameCharacter(char c) {
        return Character.isLetterOrDigit(c) || c == '.' || c == '-';
    }

    private static boolean isValidName(String string) {
        if (string.length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (MacroDef.isValidNameCharacter(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void addConfiguredAttribute(Attribute attribute) {
        if (attribute.getName() == null) {
            throw new BuildException("the attribute nested element needed a \"name\" attribute");
        }
        if (attribute.getName().equals(this.textName)) {
            throw new BuildException("the name \"" + attribute.getName() + "\" has already been used by the text element");
        }
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute attribute2 = (Attribute)this.attributes.get(i);
            if (!attribute2.getName().equals(attribute.getName())) continue;
            throw new BuildException("the name \"" + attribute.getName() + "\" has already been used in " + "another attribute element");
        }
        this.attributes.add(attribute);
    }

    public void addConfiguredElement(TemplateElement templateElement) {
        if (templateElement.getName() == null) {
            throw new BuildException("the element nested element needed a \"name\" attribute");
        }
        if (this.elements.get(templateElement.getName()) != null) {
            throw new BuildException("the element " + templateElement.getName() + " has already been specified");
        }
        if (this.hasImplicitElement || templateElement.isImplicit() && this.elements.size() != 0) {
            throw new BuildException("Only one element allowed when using implicit elements");
        }
        this.hasImplicitElement = templateElement.isImplicit();
        this.elements.put(templateElement.getName(), templateElement);
    }

    @Override
    public void execute() {
        if (this.nestedSequential == null) {
            throw new BuildException("Missing sequential element");
        }
        if (this.name == null) {
            throw new BuildException("Name not specified");
        }
        this.name = ProjectHelper.genComponentName(this.getURI(), this.name);
        MyAntTypeDefinition myAntTypeDefinition = new MyAntTypeDefinition(this);
        myAntTypeDefinition.setName(this.name);
        myAntTypeDefinition.setClass(MacroInstance.class);
        ComponentHelper componentHelper = ComponentHelper.getComponentHelper(this.getProject());
        componentHelper.addDataTypeDefinition(myAntTypeDefinition);
        this.log("creating macro  " + this.name, 3);
    }

    private static boolean safeCompare(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private boolean sameOrSimilar(Object object, boolean bl) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        MacroDef macroDef = (MacroDef)object;
        if (this.name == null) {
            return macroDef.name == null;
        }
        if (!this.name.equals(macroDef.name)) {
            return false;
        }
        if (macroDef.getLocation() != null && macroDef.getLocation().equals(this.getLocation()) && !bl) {
            return true;
        }
        if (this.text == null ? macroDef.text != null : !this.text.equals(macroDef.text)) {
            return false;
        }
        if (this.getURI() == null || this.getURI().equals("") || this.getURI().equals("antlib:org.apache.tools.ant") ? macroDef.getURI() != null && !macroDef.getURI().equals("") && !macroDef.getURI().equals("antlib:org.apache.tools.ant") : !this.getURI().equals(macroDef.getURI())) {
            return false;
        }
        if (!this.nestedSequential.similar(macroDef.nestedSequential)) {
            return false;
        }
        if (!((Object)this.attributes).equals(macroDef.attributes)) {
            return false;
        }
        return ((Object)this.elements).equals(macroDef.elements);
    }

    public boolean similar(Object object) {
        return this.sameOrSimilar(object, false);
    }

    public boolean sameDefinition(Object object) {
        return this.sameOrSimilar(object, true);
    }

    private static int objectHashCode(Object object) {
        if (object == null) {
            return 0;
        }
        return object.hashCode();
    }

    private static class MyAntTypeDefinition
    extends AntTypeDefinition {
        private MacroDef macroDef;

        public MyAntTypeDefinition(MacroDef macroDef) {
            this.macroDef = macroDef;
        }

        @Override
        public Object create(Project project) {
            Object object = super.create(project);
            if (object == null) {
                return null;
            }
            ((MacroInstance)object).setMacroDef(this.macroDef);
            return object;
        }

        @Override
        public boolean sameDefinition(AntTypeDefinition antTypeDefinition, Project project) {
            if (!super.sameDefinition(antTypeDefinition, project)) {
                return false;
            }
            MyAntTypeDefinition myAntTypeDefinition = (MyAntTypeDefinition)antTypeDefinition;
            return this.macroDef.sameDefinition(myAntTypeDefinition.macroDef);
        }

        @Override
        public boolean similarDefinition(AntTypeDefinition antTypeDefinition, Project project) {
            if (!super.similarDefinition(antTypeDefinition, project)) {
                return false;
            }
            MyAntTypeDefinition myAntTypeDefinition = (MyAntTypeDefinition)antTypeDefinition;
            return this.macroDef.similar(myAntTypeDefinition.macroDef);
        }
    }

    public static class TemplateElement {
        private String name;
        private String description;
        private boolean optional = false;
        private boolean implicit = false;

        public void setName(String string) {
            if (!MacroDef.isValidName(string)) {
                throw new BuildException("Illegal name [" + string + "] for macro element");
            }
            this.name = string.toLowerCase(Locale.US);
        }

        public String getName() {
            return this.name;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public String getDescription() {
            return this.description;
        }

        public void setOptional(boolean bl) {
            this.optional = bl;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public void setImplicit(boolean bl) {
            this.implicit = bl;
        }

        public boolean isImplicit() {
            return this.implicit;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || !object.getClass().equals(this.getClass())) {
                return false;
            }
            TemplateElement templateElement = (TemplateElement)object;
            return (this.name == null ? templateElement.name == null : this.name.equals(templateElement.name)) && this.optional == templateElement.optional && this.implicit == templateElement.implicit;
        }

        public int hashCode() {
            return MacroDef.objectHashCode(this.name) + (this.optional ? 1 : 0) + (this.implicit ? 1 : 0);
        }
    }

    public static class Text {
        private String name;
        private boolean optional;
        private boolean trim;
        private String description;
        private String defaultString;

        public void setName(String string) {
            if (!MacroDef.isValidName(string)) {
                throw new BuildException("Illegal name [" + string + "] for attribute");
            }
            this.name = string.toLowerCase(Locale.US);
        }

        public String getName() {
            return this.name;
        }

        public void setOptional(boolean bl) {
            this.optional = bl;
        }

        public boolean getOptional() {
            return this.optional;
        }

        public void setTrim(boolean bl) {
            this.trim = bl;
        }

        public boolean getTrim() {
            return this.trim;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDefault(String string) {
            this.defaultString = string;
        }

        public String getDefault() {
            return this.defaultString;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            Text text = (Text)object;
            return MacroDef.safeCompare(this.name, text.name) && this.optional == text.optional && this.trim == text.trim && MacroDef.safeCompare(this.defaultString, text.defaultString);
        }

        public int hashCode() {
            return MacroDef.objectHashCode(this.name);
        }
    }

    public static class Attribute {
        private String name;
        private String defaultValue;
        private String description;

        public void setName(String string) {
            if (!MacroDef.isValidName(string)) {
                throw new BuildException("Illegal name [" + string + "] for attribute");
            }
            this.name = string.toLowerCase(Locale.US);
        }

        public String getName() {
            return this.name;
        }

        public void setDefault(String string) {
            this.defaultValue = string;
        }

        public String getDefault() {
            return this.defaultValue;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            Attribute attribute = (Attribute)object;
            if (this.name == null ? attribute.name != null : !this.name.equals(attribute.name)) {
                return false;
            }
            return !(this.defaultValue == null ? attribute.defaultValue != null : !this.defaultValue.equals(attribute.defaultValue));
        }

        public int hashCode() {
            return MacroDef.objectHashCode(this.defaultValue) + MacroDef.objectHashCode(this.name);
        }
    }

    public static class NestedSequential
    implements TaskContainer {
        private List nested = new ArrayList();

        @Override
        public void addTask(Task task) {
            this.nested.add(task);
        }

        public List getNested() {
            return this.nested;
        }

        public boolean similar(NestedSequential nestedSequential) {
            if (this.nested.size() != nestedSequential.nested.size()) {
                return false;
            }
            for (int i = 0; i < this.nested.size(); ++i) {
                UnknownElement unknownElement;
                UnknownElement unknownElement2 = (UnknownElement)this.nested.get(i);
                if (unknownElement2.similar(unknownElement = (UnknownElement)nestedSequential.nested.get(i))) continue;
                return false;
            }
            return true;
        }
    }
}

