/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.JavaResource;
import org.apache.tools.ant.util.FileUtils;

public class LoadProperties
extends Task {
    private Resource src = null;
    private final Vector filterChains = new Vector();
    private String encoding = null;

    public final void setSrcFile(File file) {
        this.addConfigured(new FileResource(file));
    }

    public void setResource(String string) {
        this.assertSrcIsJavaResource();
        ((JavaResource)this.src).setName(string);
    }

    public final void setEncoding(String string) {
        this.encoding = string;
    }

    public void setClasspath(Path path) {
        this.assertSrcIsJavaResource();
        ((JavaResource)this.src).setClasspath(path);
    }

    public Path createClasspath() {
        this.assertSrcIsJavaResource();
        return ((JavaResource)this.src).createClasspath();
    }

    public void setClasspathRef(Reference reference) {
        this.assertSrcIsJavaResource();
        ((JavaResource)this.src).setClasspathRef(reference);
    }

    public Path getClasspath() {
        this.assertSrcIsJavaResource();
        return ((JavaResource)this.src).getClasspath();
    }

    @Override
    public final void execute() throws BuildException {
        if (this.src == null) {
            throw new BuildException("A source resource is required.");
        }
        if (!this.src.isExists()) {
            if (this.src instanceof JavaResource) {
                this.log("Unable to find resource " + this.src, 1);
                return;
            }
            throw new BuildException("Source resource does not exist: " + this.src);
        }
        BufferedInputStream bufferedInputStream = null;
        Reader reader = null;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(this.src.getInputStream());
            reader = this.encoding == null ? new InputStreamReader(bufferedInputStream) : new InputStreamReader((InputStream)bufferedInputStream, this.encoding);
            ChainReaderHelper chainReaderHelper = new ChainReaderHelper();
            chainReaderHelper.setPrimaryReader(reader);
            chainReaderHelper.setFilterChains(this.filterChains);
            chainReaderHelper.setProject(this.getProject());
            reader = chainReaderHelper.getAssembledReader();
            String string = chainReaderHelper.readFully(reader);
            if (string != null && string.length() != 0) {
                if (!string.endsWith("\n")) {
                    string = string + "\n";
                }
                byteArrayInputStream = this.encoding == null ? new ByteArrayInputStream(string.getBytes()) : new ByteArrayInputStream(string.getBytes(this.encoding));
                Properties properties = new Properties();
                properties.load(byteArrayInputStream);
                Property property = new Property();
                property.bindToOwner(this);
                property.addProperties(properties);
            }
        }
        catch (IOException iOException) {
            try {
                String string = "Unable to load file: " + iOException.toString();
                throw new BuildException(string, iOException, this.getLocation());
            }
            catch (Throwable throwable) {
                FileUtils.close(bufferedInputStream);
                FileUtils.close(byteArrayInputStream);
                throw throwable;
            }
        }
        FileUtils.close(bufferedInputStream);
        FileUtils.close(byteArrayInputStream);
    }

    public final void addFilterChain(FilterChain filterChain) {
        this.filterChains.addElement(filterChain);
    }

    public void addConfigured(ResourceCollection resourceCollection) {
        if (this.src != null) {
            throw new BuildException("only a single source is supported");
        }
        if (resourceCollection.size() != 1) {
            throw new BuildException("only single argument resource collections are supported");
        }
        this.src = (Resource)resourceCollection.iterator().next();
    }

    private void assertSrcIsJavaResource() {
        if (this.src == null) {
            this.src = new JavaResource();
            this.src.setProject(this.getProject());
        } else if (!(this.src instanceof JavaResource)) {
            throw new BuildException("expected a java resource as source");
        }
    }
}

