/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapter;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapterFactory;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.SourceFileScanner;
import org.apache.tools.ant.util.facade.FacadeTaskHelper;

public class Javac
extends MatchingTask {
    private static final String FAIL_MSG = "Compile failed; see the compiler error output for details.";
    private static final String JAVAC16 = "javac1.6";
    private static final String JAVAC15 = "javac1.5";
    private static final String JAVAC14 = "javac1.4";
    private static final String JAVAC13 = "javac1.3";
    private static final String JAVAC12 = "javac1.2";
    private static final String JAVAC11 = "javac1.1";
    private static final String MODERN = "modern";
    private static final String CLASSIC = "classic";
    private static final String EXTJAVAC = "extJavac";
    private static final String PACKAGE_INFO_JAVA = "package-info.java";
    private static final String PACKAGE_INFO_CLASS = "package-info.class";
    private Path src;
    private File destDir;
    private Path compileClasspath;
    private Path compileSourcepath;
    private String encoding;
    private boolean debug = false;
    private boolean optimize = false;
    private boolean deprecation = false;
    private boolean depend = false;
    private boolean verbose = false;
    private String targetAttribute;
    private Path bootclasspath;
    private Path extdirs;
    private boolean includeAntRuntime = true;
    private boolean includeJavaRuntime = false;
    private boolean fork = false;
    private String forkedExecutable = null;
    private boolean nowarn = false;
    private String memoryInitialSize;
    private String memoryMaximumSize;
    private FacadeTaskHelper facade = null;
    protected boolean failOnError = true;
    protected boolean listFiles = false;
    protected File[] compileList = new File[0];
    private String source;
    private String debugLevel;
    private File tmpDir;
    private String updatedProperty;
    private String errorProperty;
    private boolean taskSuccess = true;
    private boolean includeDestClasses = true;
    private List updateDirList = new ArrayList();

    public Javac() {
        this.facade = new FacadeTaskHelper(this.assumedJavaVersion());
    }

    private String assumedJavaVersion() {
        if (JavaEnvUtils.isJavaVersion("1.2")) {
            return JAVAC12;
        }
        if (JavaEnvUtils.isJavaVersion("1.3")) {
            return JAVAC13;
        }
        if (JavaEnvUtils.isJavaVersion("1.4")) {
            return JAVAC14;
        }
        if (JavaEnvUtils.isJavaVersion("1.5")) {
            return JAVAC15;
        }
        if (JavaEnvUtils.isJavaVersion("1.6")) {
            return JAVAC16;
        }
        return CLASSIC;
    }

    public String getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(String string) {
        this.debugLevel = string;
    }

    public String getSource() {
        return this.source != null ? this.source : this.getProject().getProperty("ant.build.javac.source");
    }

    public void setSource(String string) {
        this.source = string;
    }

    public Path createSrc() {
        if (this.src == null) {
            this.src = new Path(this.getProject());
        }
        return this.src.createPath();
    }

    protected Path recreateSrc() {
        this.src = null;
        return this.createSrc();
    }

    public void setSrcdir(Path path) {
        if (this.src == null) {
            this.src = path;
        } else {
            this.src.append(path);
        }
    }

    public Path getSrcdir() {
        return this.src;
    }

    public void setDestdir(File file) {
        this.destDir = file;
    }

    public File getDestdir() {
        return this.destDir;
    }

    public void setSourcepath(Path path) {
        if (this.compileSourcepath == null) {
            this.compileSourcepath = path;
        } else {
            this.compileSourcepath.append(path);
        }
    }

    public Path getSourcepath() {
        return this.compileSourcepath;
    }

    public Path createSourcepath() {
        if (this.compileSourcepath == null) {
            this.compileSourcepath = new Path(this.getProject());
        }
        return this.compileSourcepath.createPath();
    }

    public void setSourcepathRef(Reference reference) {
        this.createSourcepath().setRefid(reference);
    }

    public void setClasspath(Path path) {
        if (this.compileClasspath == null) {
            this.compileClasspath = path;
        } else {
            this.compileClasspath.append(path);
        }
    }

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.getProject());
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setBootclasspath(Path path) {
        if (this.bootclasspath == null) {
            this.bootclasspath = path;
        } else {
            this.bootclasspath.append(path);
        }
    }

    public Path getBootclasspath() {
        return this.bootclasspath;
    }

    public Path createBootclasspath() {
        if (this.bootclasspath == null) {
            this.bootclasspath = new Path(this.getProject());
        }
        return this.bootclasspath.createPath();
    }

    public void setBootClasspathRef(Reference reference) {
        this.createBootclasspath().setRefid(reference);
    }

    public void setExtdirs(Path path) {
        if (this.extdirs == null) {
            this.extdirs = path;
        } else {
            this.extdirs.append(path);
        }
    }

    public Path getExtdirs() {
        return this.extdirs;
    }

    public Path createExtdirs() {
        if (this.extdirs == null) {
            this.extdirs = new Path(this.getProject());
        }
        return this.extdirs.createPath();
    }

    public void setListfiles(boolean bl) {
        this.listFiles = bl;
    }

    public boolean getListfiles() {
        return this.listFiles;
    }

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
    }

    public void setProceed(boolean bl) {
        this.failOnError = !bl;
    }

    public boolean getFailonerror() {
        return this.failOnError;
    }

    public void setDeprecation(boolean bl) {
        this.deprecation = bl;
    }

    public boolean getDeprecation() {
        return this.deprecation;
    }

    public void setMemoryInitialSize(String string) {
        this.memoryInitialSize = string;
    }

    public String getMemoryInitialSize() {
        return this.memoryInitialSize;
    }

    public void setMemoryMaximumSize(String string) {
        this.memoryMaximumSize = string;
    }

    public String getMemoryMaximumSize() {
        return this.memoryMaximumSize;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setOptimize(boolean bl) {
        this.optimize = bl;
    }

    public boolean getOptimize() {
        return this.optimize;
    }

    public void setDepend(boolean bl) {
        this.depend = bl;
    }

    public boolean getDepend() {
        return this.depend;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setTarget(String string) {
        this.targetAttribute = string;
    }

    public String getTarget() {
        return this.targetAttribute != null ? this.targetAttribute : this.getProject().getProperty("ant.build.javac.target");
    }

    public void setIncludeantruntime(boolean bl) {
        this.includeAntRuntime = bl;
    }

    public boolean getIncludeantruntime() {
        return this.includeAntRuntime;
    }

    public void setIncludejavaruntime(boolean bl) {
        this.includeJavaRuntime = bl;
    }

    public boolean getIncludejavaruntime() {
        return this.includeJavaRuntime;
    }

    public void setFork(boolean bl) {
        this.fork = bl;
    }

    public void setExecutable(String string) {
        this.forkedExecutable = string;
    }

    public String getExecutable() {
        return this.forkedExecutable;
    }

    public boolean isForkedJavac() {
        return this.fork || EXTJAVAC.equals(this.getCompiler());
    }

    public String getJavacExecutable() {
        if (this.forkedExecutable == null && this.isForkedJavac()) {
            this.forkedExecutable = this.getSystemJavac();
        } else if (this.forkedExecutable != null && !this.isForkedJavac()) {
            this.forkedExecutable = null;
        }
        return this.forkedExecutable;
    }

    public void setNowarn(boolean bl) {
        this.nowarn = bl;
    }

    public boolean getNowarn() {
        return this.nowarn;
    }

    public ImplementationSpecificArgument createCompilerArg() {
        ImplementationSpecificArgument implementationSpecificArgument = new ImplementationSpecificArgument();
        this.facade.addImplementationArgument(implementationSpecificArgument);
        return implementationSpecificArgument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCurrentCompilerArgs() {
        String string = this.facade.getExplicitChoice();
        try {
            String string2 = this.getCompiler();
            this.facade.setImplementation(string2);
            String[] stringArray = this.facade.getArgs();
            String string3 = this.getAltCompilerName(this.facade.getImplementation());
            if (stringArray.length == 0 && string3 != null) {
                this.facade.setImplementation(string3);
                stringArray = this.facade.getArgs();
            }
            String[] stringArray2 = stringArray;
            return stringArray2;
        }
        finally {
            this.facade.setImplementation(string);
        }
    }

    private String getAltCompilerName(String string) {
        String string2;
        if (JAVAC16.equalsIgnoreCase(string) || JAVAC15.equalsIgnoreCase(string) || JAVAC14.equalsIgnoreCase(string) || JAVAC13.equalsIgnoreCase(string)) {
            return MODERN;
        }
        if (JAVAC12.equalsIgnoreCase(string) || JAVAC11.equalsIgnoreCase(string)) {
            return CLASSIC;
        }
        if (MODERN.equalsIgnoreCase(string) && (JAVAC16.equalsIgnoreCase(string2 = this.assumedJavaVersion()) || JAVAC15.equalsIgnoreCase(string2) || JAVAC14.equalsIgnoreCase(string2) || JAVAC13.equalsIgnoreCase(string2))) {
            return string2;
        }
        if (CLASSIC.equals(string)) {
            return this.assumedJavaVersion();
        }
        if (EXTJAVAC.equalsIgnoreCase(string)) {
            return this.assumedJavaVersion();
        }
        return null;
    }

    public void setTempdir(File file) {
        this.tmpDir = file;
    }

    public File getTempdir() {
        return this.tmpDir;
    }

    public void setUpdatedProperty(String string) {
        this.updatedProperty = string;
    }

    public void setErrorProperty(String string) {
        this.errorProperty = string;
    }

    public void setIncludeDestClasses(boolean bl) {
        this.includeDestClasses = bl;
    }

    public boolean isIncludeDestClasses() {
        return this.includeDestClasses;
    }

    public boolean getTaskSuccess() {
        return this.taskSuccess;
    }

    @Override
    public void execute() throws BuildException {
        this.checkParameters();
        this.resetFileLists();
        String[] stringArray = this.src.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file = this.getProject().resolveFile(stringArray[i]);
            if (!file.exists()) {
                throw new BuildException("srcdir \"" + file.getPath() + "\" does not exist!", this.getLocation());
            }
            DirectoryScanner directoryScanner = this.getDirectoryScanner(file);
            String[] stringArray2 = directoryScanner.getIncludedFiles();
            this.scanDir(file, this.destDir != null ? this.destDir : file, stringArray2);
        }
        this.compile();
        if (this.updatedProperty != null && this.taskSuccess && this.compileList.length != 0) {
            this.getProject().setNewProperty(this.updatedProperty, "true");
        }
    }

    protected void resetFileLists() {
        this.compileList = new File[0];
    }

    protected void scanDir(File file, File file2, String[] stringArray) {
        GlobPatternMapper globPatternMapper = new GlobPatternMapper();
        globPatternMapper.setFrom("*.java");
        globPatternMapper.setTo("*.class");
        SourceFileScanner sourceFileScanner = new SourceFileScanner(this);
        File[] fileArray = sourceFileScanner.restrictAsFiles(stringArray, file, file2, globPatternMapper);
        fileArray = this.removePackageInfoFiles(fileArray, file, file2);
        if (fileArray.length > 0) {
            File[] fileArray2 = new File[this.compileList.length + fileArray.length];
            System.arraycopy(this.compileList, 0, fileArray2, 0, this.compileList.length);
            System.arraycopy(fileArray, 0, fileArray2, this.compileList.length, fileArray.length);
            this.compileList = fileArray2;
        }
    }

    public File[] getFileList() {
        return this.compileList;
    }

    protected boolean isJdkCompiler(String string) {
        return MODERN.equals(string) || CLASSIC.equals(string) || JAVAC16.equals(string) || JAVAC15.equals(string) || JAVAC14.equals(string) || JAVAC13.equals(string) || JAVAC12.equals(string) || JAVAC11.equals(string);
    }

    protected String getSystemJavac() {
        return JavaEnvUtils.getJdkExecutable("javac");
    }

    public void setCompiler(String string) {
        this.facade.setImplementation(string);
    }

    public String getCompiler() {
        String string = this.getCompilerVersion();
        if (this.fork) {
            if (this.isJdkCompiler(string)) {
                string = EXTJAVAC;
            } else {
                this.log("Since compiler setting isn't classic or modern,ignoring fork setting.", 1);
            }
        }
        return string;
    }

    public String getCompilerVersion() {
        this.facade.setMagicValue(this.getProject().getProperty("build.compiler"));
        return this.facade.getImplementation();
    }

    protected void checkParameters() throws BuildException {
        if (this.src == null) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.src.size() == 0) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.destDir != null && !this.destDir.isDirectory()) {
            throw new BuildException("destination directory \"" + this.destDir + "\" does not exist " + "or is not a directory", this.getLocation());
        }
    }

    protected void compile() {
        String string = this.getCompiler();
        if (this.compileList.length > 0) {
            this.log("Compiling " + this.compileList.length + " source file" + (this.compileList.length == 1 ? "" : "s") + (this.destDir != null ? " to " + this.destDir : ""));
            if (this.listFiles) {
                for (int i = 0; i < this.compileList.length; ++i) {
                    String string2 = this.compileList[i].getAbsolutePath();
                    this.log(string2);
                }
            }
            CompilerAdapter compilerAdapter = CompilerAdapterFactory.getCompiler(string, this);
            compilerAdapter.setJavac(this);
            if (compilerAdapter.execute()) {
                for (File file : this.updateDirList) {
                    file.setLastModified(System.currentTimeMillis());
                }
            } else {
                this.taskSuccess = false;
                if (this.errorProperty != null) {
                    this.getProject().setNewProperty(this.errorProperty, "true");
                }
                if (this.failOnError) {
                    throw new BuildException(FAIL_MSG, this.getLocation());
                }
                this.log(FAIL_MSG, 0);
            }
        }
    }

    private File[] removePackageInfoFiles(File[] fileArray, File file, File file2) {
        if (!this.hasPackageInfo(fileArray)) {
            return fileArray;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!this.needsCompilePackageFile(fileArray[i], file, file2)) continue;
            arrayList.add(fileArray[i]);
        }
        return arrayList.toArray(new File[0]);
    }

    private boolean hasPackageInfo(File[] fileArray) {
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].getName().equals(PACKAGE_INFO_JAVA)) continue;
            return true;
        }
        return false;
    }

    private boolean needsCompilePackageFile(File file, File file2, File file3) {
        if (!file.getName().equals(PACKAGE_INFO_JAVA)) {
            return true;
        }
        String string = this.relativePath(file2, file);
        File file4 = new File(file3, string);
        File file5 = file4.getParentFile();
        file4 = new File(file5, PACKAGE_INFO_CLASS);
        File file6 = new File(file2, string);
        if (file4.exists()) {
            return true;
        }
        if (file6.lastModified() > file4.getParentFile().lastModified()) {
            this.updateDirList.add(file4.getParentFile());
            return true;
        }
        return false;
    }

    private String relativePath(File file, File file2) {
        return file2.getAbsolutePath().substring(file.getAbsolutePath().length() + 1);
    }

    public class ImplementationSpecificArgument
    extends org.apache.tools.ant.util.facade.ImplementationSpecificArgument {
        public void setCompiler(String string) {
            super.setImplementation(string);
        }
    }
}

