/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public abstract class JDBCTask
extends Task {
    private static final int HASH_TABLE_SIZE = 3;
    private static Hashtable loaderMap = new Hashtable(3);
    private boolean caching = true;
    private Path classpath;
    private AntClassLoader loader;
    private boolean autocommit = false;
    private String driver = null;
    private String url = null;
    private String userId = null;
    private String password = null;
    private String rdbms = null;
    private String version = null;

    public void setClasspath(Path path) {
        this.classpath = path;
    }

    public void setCaching(boolean bl) {
        this.caching = bl;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setDriver(String string) {
        this.driver = string.trim();
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setAutocommit(boolean bl) {
        this.autocommit = bl;
    }

    public void setRdbms(String string) {
        this.rdbms = string;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    protected boolean isValidRdbms(Connection connection) {
        if (this.rdbms == null && this.version == null) {
            return true;
        }
        try {
            String string;
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (this.rdbms != null) {
                string = databaseMetaData.getDatabaseProductName().toLowerCase();
                this.log("RDBMS = " + string, 3);
                if (string == null || string.indexOf(this.rdbms) < 0) {
                    this.log("Not the required RDBMS: " + this.rdbms, 3);
                    return false;
                }
            }
            if (this.version != null) {
                string = databaseMetaData.getDatabaseProductVersion().toLowerCase(Locale.ENGLISH);
                this.log("Version = " + string, 3);
                if (string == null || !string.startsWith(this.version) && string.indexOf(" " + this.version) < 0) {
                    this.log("Not the required version: \"" + this.version + "\"", 3);
                    return false;
                }
            }
        }
        catch (SQLException sQLException) {
            this.log("Failed to obtain required RDBMS information", 0);
            return false;
        }
        return true;
    }

    protected static Hashtable getLoaderMap() {
        return loaderMap;
    }

    protected AntClassLoader getLoader() {
        return this.loader;
    }

    protected Connection getConnection() throws BuildException {
        if (this.userId == null) {
            throw new BuildException("UserId attribute must be set!", this.getLocation());
        }
        if (this.password == null) {
            throw new BuildException("Password attribute must be set!", this.getLocation());
        }
        if (this.url == null) {
            throw new BuildException("Url attribute must be set!", this.getLocation());
        }
        try {
            this.log("connecting to " + this.getUrl(), 3);
            Properties properties = new Properties();
            properties.put("user", this.getUserId());
            properties.put("password", this.getPassword());
            Connection connection = this.getDriver().connect(this.getUrl(), properties);
            if (connection == null) {
                throw new SQLException("No suitable Driver for " + this.url);
            }
            connection.setAutoCommit(this.autocommit);
            return connection;
        }
        catch (SQLException sQLException) {
            throw new BuildException(sQLException, this.getLocation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Driver getDriver() throws BuildException {
        if (this.driver == null) {
            throw new BuildException("Driver attribute must be set!", this.getLocation());
        }
        Driver driver = null;
        try {
            Class<?> clazz;
            if (this.classpath != null) {
                Hashtable hashtable = loaderMap;
                synchronized (hashtable) {
                    if (this.caching) {
                        this.loader = (AntClassLoader)loaderMap.get(this.driver);
                    }
                    if (this.loader == null) {
                        this.log("Loading " + this.driver + " using AntClassLoader with classpath " + this.classpath, 3);
                        this.loader = this.getProject().createClassLoader(this.classpath);
                        if (this.caching) {
                            loaderMap.put(this.driver, this.loader);
                        }
                    } else {
                        this.log("Loading " + this.driver + " using a cached AntClassLoader.", 3);
                    }
                }
                clazz = this.loader.loadClass(this.driver);
            } else {
                this.log("Loading " + this.driver + " using system loader.", 3);
                clazz = Class.forName(this.driver);
            }
            driver = (Driver)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BuildException("Class Not Found: JDBC driver " + this.driver + " could not be loaded", classNotFoundException, this.getLocation());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BuildException("Illegal Access: JDBC driver " + this.driver + " could not be loaded", illegalAccessException, this.getLocation());
        }
        catch (InstantiationException instantiationException) {
            throw new BuildException("Instantiation Exception: JDBC driver " + this.driver + " could not be loaded", instantiationException, this.getLocation());
        }
        return driver;
    }

    public void isCaching(boolean bl) {
        this.caching = bl;
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public boolean isAutocommit() {
        return this.autocommit;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserid(String string) {
        this.userId = string;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRdbms() {
        return this.rdbms;
    }

    public String getVersion() {
        return this.version;
    }
}

