/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.GreedyInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.input.InputRequest;
import org.apache.tools.ant.input.MultipleChoiceInputRequest;
import org.apache.tools.ant.input.PropertyFileInputHandler;
import org.apache.tools.ant.taskdefs.DefBase;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.util.ClasspathUtils;
import org.apache.tools.ant.util.StringUtils;

public class Input
extends Task {
    private String validargs = null;
    private String message = "";
    private String addproperty = null;
    private String defaultvalue = null;
    private Handler handler = null;
    private boolean messageAttribute;

    public void setValidargs(String string) {
        this.validargs = string;
    }

    public void setAddproperty(String string) {
        this.addproperty = string;
    }

    public void setMessage(String string) {
        this.message = string;
        this.messageAttribute = true;
    }

    public void setDefaultvalue(String string) {
        this.defaultvalue = string;
    }

    public void addText(String string) {
        if (this.messageAttribute && "".equals(string.trim())) {
            return;
        }
        this.message = this.message + this.getProject().replaceProperties(string);
    }

    @Override
    public void execute() throws BuildException {
        Object object;
        if (this.addproperty != null && this.getProject().getProperty(this.addproperty) != null) {
            this.log("skipping " + this.getTaskName() + " as property " + this.addproperty + " has already been set.");
            return;
        }
        InputRequest inputRequest = null;
        if (this.validargs != null) {
            object = StringUtils.split(this.validargs, 44);
            inputRequest = new MultipleChoiceInputRequest(this.message, (Vector)object);
        } else {
            inputRequest = new InputRequest(this.message);
        }
        inputRequest.setDefaultValue(this.defaultvalue);
        object = this.handler == null ? this.getProject().getInputHandler() : this.handler.getInputHandler();
        object.handleInput(inputRequest);
        String string = inputRequest.getInput();
        if ((string == null || string.trim().length() == 0) && this.defaultvalue != null) {
            string = this.defaultvalue;
        }
        if (this.addproperty != null && string != null) {
            this.getProject().setNewProperty(this.addproperty, string);
        }
    }

    public Handler createHandler() {
        if (this.handler != null) {
            throw new BuildException("Cannot define > 1 nested input handler");
        }
        this.handler = new Handler();
        return this.handler;
    }

    public static class HandlerType
    extends EnumeratedAttribute {
        private static final String[] VALUES = new String[]{"default", "propertyfile", "greedy"};
        private static final InputHandler[] HANDLERS = new InputHandler[]{new DefaultInputHandler(), new PropertyFileInputHandler(), new GreedyInputHandler()};

        @Override
        public String[] getValues() {
            return VALUES;
        }

        private InputHandler getInputHandler() {
            return HANDLERS[this.getIndex()];
        }
    }

    public class Handler
    extends DefBase {
        private String refid = null;
        private HandlerType type = null;
        private String classname = null;

        public void setRefid(String string) {
            this.refid = string;
        }

        public String getRefid() {
            return this.refid;
        }

        public void setClassname(String string) {
            this.classname = string;
        }

        public String getClassname() {
            return this.classname;
        }

        public void setType(HandlerType handlerType) {
            this.type = handlerType;
        }

        public HandlerType getType() {
            return this.type;
        }

        private InputHandler getInputHandler() {
            if (this.type != null) {
                return this.type.getInputHandler();
            }
            if (this.refid != null) {
                try {
                    return (InputHandler)this.getProject().getReference(this.refid);
                }
                catch (ClassCastException classCastException) {
                    throw new BuildException(this.refid + " does not denote an InputHandler", classCastException);
                }
            }
            if (this.classname != null) {
                return (InputHandler)ClasspathUtils.newInstance(this.classname, this.createLoader(), InputHandler.class);
            }
            throw new BuildException("Must specify refid, classname or type");
        }
    }
}

