/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileUtils;

public class Get
extends Task {
    private static final int NUMBER_RETRIES = 3;
    private static final int DOTS_PER_LINE = 50;
    private static final int BIG_BUFFER_SIZE = 102400;
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private URL source;
    private File dest;
    private boolean verbose = false;
    private boolean useTimestamp = false;
    private boolean ignoreErrors = false;
    private String uname = null;
    private String pword = null;

    @Override
    public void execute() throws BuildException {
        block3: {
            int n = 2;
            VerboseProgress verboseProgress = null;
            if (this.verbose) {
                verboseProgress = new VerboseProgress(System.out);
            }
            try {
                this.doGet(n, verboseProgress);
            }
            catch (IOException iOException) {
                this.log("Error getting " + this.source + " to " + this.dest);
                if (this.ignoreErrors) break block3;
                throw new BuildException(iOException, this.getLocation());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doGet(int n, DownloadProgress downloadProgress) throws IOException {
        Object object;
        Object object2;
        this.checkAttributes();
        if (downloadProgress == null) {
            downloadProgress = new NullProgress();
        }
        this.log("Getting: " + this.source, n);
        this.log("To: " + this.dest.getAbsolutePath(), n);
        long l = 0L;
        boolean bl = false;
        if (this.useTimestamp && this.dest.exists()) {
            l = this.dest.lastModified();
            if (this.verbose) {
                object2 = new Date(l);
                this.log("local file date : " + ((Date)object2).toString(), n);
            }
            bl = true;
        }
        object2 = this.source.openConnection();
        if (bl) {
            ((URLConnection)object2).setIfModifiedSince(l);
        }
        if (this.uname != null || this.pword != null) {
            object = this.uname + ":" + this.pword;
            Base64Converter base64Converter = new Base64Converter();
            String string = base64Converter.encode(((String)object).getBytes());
            ((URLConnection)object2).setRequestProperty("Authorization", "Basic " + string);
        }
        ((URLConnection)object2).connect();
        if (object2 instanceof HttpURLConnection) {
            object = (HttpURLConnection)object2;
            long l2 = ((URLConnection)object).getLastModified();
            if (((HttpURLConnection)object).getResponseCode() == 304 || l2 != 0L && bl && l >= l2) {
                this.log("Not modified - so not downloaded", n);
                return false;
            }
            if (((HttpURLConnection)object).getResponseCode() == 401) {
                String string = "HTTP Authorization failure";
                if (this.ignoreErrors) {
                    this.log(string, n);
                    return false;
                }
                throw new BuildException(string);
            }
        }
        object = null;
        for (int i = 0; i < 3; ++i) {
            try {
                object = ((URLConnection)object2).getInputStream();
                break;
            }
            catch (IOException iOException) {
                this.log("Error opening connection " + iOException, n);
                continue;
            }
        }
        if (object == null) {
            this.log("Can't get " + this.source + " to " + this.dest, n);
            if (this.ignoreErrors) {
                return false;
            }
            throw new BuildException("Can't get " + this.source + " to " + this.dest, this.getLocation());
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this.dest);
        downloadProgress.beginDownload();
        boolean bl2 = false;
        try {
            int n2;
            byte[] byArray = new byte[102400];
            while ((n2 = ((InputStream)object).read(byArray)) >= 0) {
                fileOutputStream.write(byArray, 0, n2);
                downloadProgress.onTick();
            }
            bl2 = true;
        }
        finally {
            FileUtils.close(fileOutputStream);
            FileUtils.close((InputStream)object);
            if (!bl2) {
                this.dest.delete();
            }
        }
        downloadProgress.endDownload();
        if (this.useTimestamp) {
            long l3 = ((URLConnection)object2).getLastModified();
            if (this.verbose) {
                Date date = new Date(l3);
                this.log("last modified = " + date.toString() + (l3 == 0L ? " - using current time instead" : ""), n);
            }
            if (l3 != 0L) {
                FILE_UTILS.setFileLastModified(this.dest, l3);
            }
        }
        return true;
    }

    private void checkAttributes() {
        if (this.source == null) {
            throw new BuildException("src attribute is required", this.getLocation());
        }
        if (this.dest == null) {
            throw new BuildException("dest attribute is required", this.getLocation());
        }
        if (this.dest.exists() && this.dest.isDirectory()) {
            throw new BuildException("The specified destination is a directory", this.getLocation());
        }
        if (this.dest.exists() && !this.dest.canWrite()) {
            throw new BuildException("Can't write to " + this.dest.getAbsolutePath(), this.getLocation());
        }
    }

    public void setSrc(URL uRL) {
        this.source = uRL;
    }

    public void setDest(File file) {
        this.dest = file;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setIgnoreErrors(boolean bl) {
        this.ignoreErrors = bl;
    }

    public void setUseTimestamp(boolean bl) {
        this.useTimestamp = bl;
    }

    public void setUsername(String string) {
        this.uname = string;
    }

    public void setPassword(String string) {
        this.pword = string;
    }

    public static class VerboseProgress
    implements DownloadProgress {
        private int dots = 0;
        PrintStream out;

        public VerboseProgress(PrintStream printStream) {
            this.out = printStream;
        }

        @Override
        public void beginDownload() {
            this.dots = 0;
        }

        @Override
        public void onTick() {
            this.out.print(".");
            if (this.dots++ > 50) {
                this.out.flush();
                this.dots = 0;
            }
        }

        @Override
        public void endDownload() {
            this.out.println();
            this.out.flush();
        }
    }

    public static class NullProgress
    implements DownloadProgress {
        @Override
        public void beginDownload() {
        }

        @Override
        public void onTick() {
        }

        @Override
        public void endDownload() {
        }
    }

    public static interface DownloadProgress {
        public void beginDownload();

        public void onTick();

        public void endDownload();
    }

    protected static class Base64Converter
    extends org.apache.tools.ant.util.Base64Converter {
        protected Base64Converter() {
        }
    }
}

