/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.filters.FixCrLfFilter;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.util.FileUtils;

public class FixCRLF
extends MatchingTask
implements ChainableReader {
    public static final String ERROR_FILE_AND_SRCDIR = "srcdir and file are mutually exclusive";
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private boolean preserveLastModified = false;
    private File srcDir;
    private File destDir = null;
    private File file;
    private FixCrLfFilter filter = new FixCrLfFilter();
    private Vector fcv = null;
    private String encoding = null;
    private String outputEncoding = null;

    @Override
    public final Reader chain(Reader reader) {
        return this.filter.chain(reader);
    }

    public void setSrcdir(File file) {
        this.srcDir = file;
    }

    public void setDestdir(File file) {
        this.destDir = file;
    }

    public void setJavafiles(boolean bl) {
        this.filter.setJavafiles(bl);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setEol(CrLf crLf) {
        this.filter.setEol(FixCrLfFilter.CrLf.newInstance(crLf.getValue()));
    }

    public void setCr(AddAsisRemove addAsisRemove) {
        this.log("DEPRECATED: The cr attribute has been deprecated,", 1);
        this.log("Please use the eol attribute instead", 1);
        String string = addAsisRemove.getValue();
        CrLf crLf = new CrLf();
        if (string.equals("remove")) {
            crLf.setValue("lf");
        } else if (string.equals("asis")) {
            crLf.setValue("asis");
        } else {
            crLf.setValue("crlf");
        }
        this.setEol(crLf);
    }

    public void setTab(AddAsisRemove addAsisRemove) {
        this.filter.setTab(FixCrLfFilter.AddAsisRemove.newInstance(addAsisRemove.getValue()));
    }

    public void setTablength(int n) throws BuildException {
        try {
            this.filter.setTablength(n);
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    public void setEof(AddAsisRemove addAsisRemove) {
        this.filter.setEof(FixCrLfFilter.AddAsisRemove.newInstance(addAsisRemove.getValue()));
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setOutputEncoding(String string) {
        this.outputEncoding = string;
    }

    public void setFixlast(boolean bl) {
        this.filter.setFixlast(bl);
    }

    public void setPreserveLastModified(boolean bl) {
        this.preserveLastModified = bl;
    }

    @Override
    public void execute() throws BuildException {
        this.validate();
        String string = this.encoding == null ? "default" : this.encoding;
        this.log("options: eol=" + this.filter.getEol().getValue() + " tab=" + this.filter.getTab().getValue() + " eof=" + this.filter.getEof().getValue() + " tablength=" + this.filter.getTablength() + " encoding=" + string + " outputencoding=" + (this.outputEncoding == null ? string : this.outputEncoding), 3);
        DirectoryScanner directoryScanner = super.getDirectoryScanner(this.srcDir);
        String[] stringArray = directoryScanner.getIncludedFiles();
        for (int i = 0; i < stringArray.length; ++i) {
            this.processFile(stringArray[i]);
        }
    }

    private void validate() throws BuildException {
        if (this.file != null) {
            if (this.srcDir != null) {
                throw new BuildException(ERROR_FILE_AND_SRCDIR);
            }
            this.fileset.setFile(this.file);
            this.srcDir = this.file.getParentFile();
        }
        if (this.srcDir == null) {
            throw new BuildException("srcdir attribute must be set!");
        }
        if (!this.srcDir.exists()) {
            throw new BuildException("srcdir does not exist!");
        }
        if (!this.srcDir.isDirectory()) {
            throw new BuildException("srcdir is not a directory!");
        }
        if (this.destDir != null) {
            if (!this.destDir.exists()) {
                throw new BuildException("destdir does not exist!");
            }
            if (!this.destDir.isDirectory()) {
                throw new BuildException("destdir is not a directory!");
            }
        }
    }

    private void processFile(String string) throws BuildException {
        Object object;
        File file;
        File file2 = new File(this.srcDir, string);
        long l = file2.lastModified();
        File file3 = file = this.destDir == null ? this.srcDir : this.destDir;
        if (this.fcv == null) {
            object = new FilterChain();
            ((FilterChain)object).add(this.filter);
            this.fcv = new Vector(1);
            this.fcv.add(object);
        }
        object = FILE_UTILS.createTempFile("fixcrlf", "", null, true, false);
        try {
            FILE_UTILS.copyFile(file2, (File)object, null, this.fcv, false, false, this.encoding, this.outputEncoding == null ? this.encoding : this.outputEncoding, this.getProject());
            File file4 = new File(file, string);
            boolean bl = true;
            if (file4.exists()) {
                this.log("destFile exists", 4);
                bl = !FILE_UTILS.contentEquals(file4, (File)object);
                this.log(file4 + (bl ? " is being written" : " is not written, as the contents are identical"), 4);
            }
            if (bl) {
                FILE_UTILS.rename((File)object, file4);
                if (this.preserveLastModified) {
                    this.log("preserved lastModified", 4);
                    FILE_UTILS.setFileLastModified(file4, l);
                }
                object = null;
            }
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    public static class CrLf
    extends EnumeratedAttribute {
        @Override
        public String[] getValues() {
            return new String[]{"asis", "cr", "lf", "crlf", "mac", "unix", "dos"};
        }
    }

    public static class AddAsisRemove
    extends EnumeratedAttribute {
        @Override
        public String[] getValues() {
            return new String[]{"add", "asis", "remove"};
        }
    }

    protected class OneLiner
    implements Enumeration {
        private static final int UNDEF = -1;
        private static final int NOTJAVA = 0;
        private static final int LOOKING = 1;
        private static final int INBUFLEN = 8192;
        private static final int LINEBUFLEN = 200;
        private static final char CTRLZ = '\u001a';
        private int state;
        private StringBuffer eolStr;
        private StringBuffer eofStr;
        private BufferedReader reader;
        private StringBuffer line;
        private boolean reachedEof;
        private File srcFile;

        public OneLiner(File file) throws BuildException {
            this.state = FixCRLF.this.filter.getJavafiles() ? 1 : 0;
            this.eolStr = new StringBuffer(200);
            this.eofStr = new StringBuffer();
            this.line = new StringBuffer();
            this.reachedEof = false;
            this.srcFile = file;
            try {
                this.reader = new BufferedReader(FixCRLF.this.encoding == null ? new FileReader(file) : new InputStreamReader((InputStream)new FileInputStream(file), FixCRLF.this.encoding), 8192);
                this.nextLine();
            }
            catch (IOException iOException) {
                throw new BuildException(file + ": " + iOException.getMessage(), iOException, FixCRLF.this.getLocation());
            }
        }

        protected void nextLine() throws BuildException {
            int n = -1;
            int n2 = 0;
            this.eolStr = new StringBuffer();
            this.line = new StringBuffer();
            try {
                n = this.reader.read();
                while (n != -1 && n != 13 && n != 10) {
                    this.line.append((char)n);
                    n = this.reader.read();
                }
                if (n == -1 && this.line.length() == 0) {
                    this.reachedEof = true;
                    return;
                }
                block1 : switch ((char)n) {
                    case '\r': {
                        ++n2;
                        this.eolStr.append('\r');
                        this.reader.mark(2);
                        n = this.reader.read();
                        switch (n) {
                            case 13: {
                                n = this.reader.read();
                                if ((char)n == '\n') {
                                    n2 += 2;
                                    this.eolStr.append("\r\n");
                                    break block1;
                                }
                                this.reader.reset();
                                break block1;
                            }
                            case 10: {
                                ++n2;
                                this.eolStr.append('\n');
                                break block1;
                            }
                            case -1: {
                                break block1;
                            }
                        }
                        this.reader.reset();
                        break;
                    }
                    case '\n': {
                        ++n2;
                        this.eolStr.append('\n');
                        break;
                    }
                }
                if (n2 == 0) {
                    int n3 = this.line.length();
                    while (--n3 >= 0 && this.line.charAt(n3) == '\u001a') {
                    }
                    if (n3 < this.line.length() - 1) {
                        this.eofStr.append(this.line.toString().substring(n3 + 1));
                        if (n3 < 0) {
                            this.line.setLength(0);
                            this.reachedEof = true;
                        } else {
                            this.line.setLength(n3 + 1);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                throw new BuildException(this.srcFile + ": " + iOException.getMessage(), iOException, FixCRLF.this.getLocation());
            }
        }

        public String getEofStr() {
            return this.eofStr.substring(0);
        }

        public int getState() {
            return this.state;
        }

        public void setState(int n) {
            this.state = n;
        }

        @Override
        public boolean hasMoreElements() {
            return !this.reachedEof;
        }

        public Object nextElement() throws NoSuchElementException {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("OneLiner");
            }
            BufferLine bufferLine = new BufferLine(this.line.toString(), this.eolStr.substring(0));
            this.nextLine();
            return bufferLine;
        }

        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
            }
        }

        class BufferLine {
            private int next = 0;
            private int column = 0;
            private int lookahead = -1;
            private String line;
            private String eolStr;

            public BufferLine(String string, String string2) throws BuildException {
                this.line = string;
                this.eolStr = string2;
            }

            public int getNext() {
                return this.next;
            }

            public void setNext(int n) {
                this.next = n;
            }

            public int getLookahead() {
                return this.lookahead;
            }

            public void setLookahead(int n) {
                this.lookahead = n;
            }

            public char getChar(int n) {
                return this.line.charAt(n);
            }

            public char getNextChar() {
                return this.getChar(this.next);
            }

            public char getNextCharInc() {
                return this.getChar(this.next++);
            }

            public int getColumn() {
                return this.column;
            }

            public void setColumn(int n) {
                this.column = n;
            }

            public int incColumn() {
                return this.column++;
            }

            public int length() {
                return this.line.length();
            }

            public int getEolLength() {
                return this.eolStr.length();
            }

            public String getLineString() {
                return this.line;
            }

            public String getEol() {
                return this.eolStr;
            }

            public String substring(int n) {
                return this.line.substring(n);
            }

            public String substring(int n, int n2) {
                return this.line.substring(n, n2);
            }

            public void setState(int n) {
                OneLiner.this.setState(n);
            }

            public int getState() {
                return OneLiner.this.getState();
            }
        }
    }
}

