/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.IdentityMapper;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class Expand
extends Task {
    private static final int BUFFER_SIZE = 1024;
    private File dest;
    private File source;
    private boolean overwrite = true;
    private Mapper mapperElement = null;
    private Vector patternsets = new Vector();
    private Union resources = new Union();
    private boolean resourcesSpecified = false;
    private static final String NATIVE_ENCODING = "native-encoding";
    private String encoding = "UTF8";
    public static final String ERROR_MULTIPLE_MAPPERS = "Cannot define more than one mapper";
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();

    @Override
    public void execute() throws BuildException {
        if ("expand".equals(this.getTaskType())) {
            this.log("!! expand is deprecated. Use unzip instead. !!");
        }
        if (this.source == null && !this.resourcesSpecified) {
            throw new BuildException("src attribute and/or resources must be specified");
        }
        if (this.dest == null) {
            throw new BuildException("Dest attribute must be specified");
        }
        if (this.dest.exists() && !this.dest.isDirectory()) {
            throw new BuildException("Dest must be a directory.", this.getLocation());
        }
        if (this.source != null) {
            if (this.source.isDirectory()) {
                throw new BuildException("Src must not be a directory. Use nested filesets instead.", this.getLocation());
            }
            this.expandFile(FILE_UTILS, this.source, this.dest);
        }
        Iterator iterator = this.resources.iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            if (!resource.isExists()) continue;
            if (resource instanceof FileResource) {
                this.expandFile(FILE_UTILS, ((FileResource)resource).getFile(), this.dest);
                continue;
            }
            this.expandResource(resource, this.dest);
        }
    }

    protected void expandFile(FileUtils fileUtils, File file, File file2) {
        this.log("Expanding: " + file + " into " + file2, 2);
        ZipFile zipFile = null;
        FileNameMapper fileNameMapper = this.getMapper();
        try {
            zipFile = new ZipFile(file, this.encoding);
            Enumeration enumeration = zipFile.getEntries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                this.extractFile(fileUtils, file, file2, zipFile.getInputStream(zipEntry), zipEntry.getName(), new Date(zipEntry.getTime()), zipEntry.isDirectory(), fileNameMapper);
            }
            this.log("expand complete", 3);
        }
        catch (IOException iOException) {
            try {
                throw new BuildException("Error while expanding " + file.getPath() + "\n" + iOException.toString(), iOException);
            }
            catch (Throwable throwable) {
                ZipFile.closeQuietly(zipFile);
                throw throwable;
            }
        }
        ZipFile.closeQuietly(zipFile);
    }

    protected void expandResource(Resource resource, File file) {
        throw new BuildException("only filesystem based resources are supported by this task.");
    }

    protected FileNameMapper getMapper() {
        FileNameMapper fileNameMapper = null;
        fileNameMapper = this.mapperElement != null ? this.mapperElement.getImplementation() : new IdentityMapper();
        return fileNameMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void extractFile(FileUtils fileUtils, File file, File file2, InputStream inputStream, String string, Date date, boolean bl, FileNameMapper fileNameMapper) throws IOException {
        Object object;
        Serializable serializable;
        Object object2;
        if (this.patternsets != null && this.patternsets.size() > 0) {
            object2 = string.replace('/', File.separatorChar).replace('\\', File.separatorChar);
            boolean bl2 = false;
            serializable = new HashSet();
            object = new HashSet();
            int n = this.patternsets.size();
            for (int i = 0; i < n; ++i) {
                PatternSet patternSet = (PatternSet)this.patternsets.elementAt(i);
                String[] stringArray = patternSet.getIncludePatterns(this.getProject());
                if (stringArray == null || stringArray.length == 0) {
                    stringArray = new String[]{"**"};
                }
                for (int j = 0; j < stringArray.length; ++j) {
                    String string2 = stringArray[j].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                    if (string2.endsWith(File.separator)) {
                        string2 = string2 + "**";
                    }
                    serializable.add(string2);
                }
                String[] stringArray2 = patternSet.getExcludePatterns(this.getProject());
                if (stringArray2 == null) continue;
                for (int j = 0; j < stringArray2.length; ++j) {
                    String string3 = stringArray2[j].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                    if (string3.endsWith(File.separator)) {
                        string3 = string3 + "**";
                    }
                    object.add(string3);
                }
            }
            Iterator iterator = serializable.iterator();
            while (!bl2 && iterator.hasNext()) {
                String string4 = (String)iterator.next();
                bl2 = SelectorUtils.matchPath(string4, (String)object2);
            }
            iterator = object.iterator();
            while (bl2 && iterator.hasNext()) {
                String string5 = (String)iterator.next();
                if (SelectorUtils.matchPath(string5, (String)object2)) return;
                boolean bl3 = true;
                bl2 = bl3;
            }
            if (!bl2) {
                return;
            }
        }
        if ((object2 = fileNameMapper.mapFileName(string)) == null || ((String[])object2).length == 0) {
            object2 = new String[]{string};
        }
        File file3 = fileUtils.resolveFile(file2, object2[0]);
        try {
            if (!this.overwrite && file3.exists() && file3.lastModified() >= date.getTime()) {
                this.log("Skipping " + file3 + " as it is up-to-date", 4);
                return;
            }
            this.log("expanding " + string + " to " + file3, 3);
            serializable = file3.getParentFile();
            if (serializable != null) {
                ((File)serializable).mkdirs();
            }
            if (bl) {
                file3.mkdirs();
            } else {
                object = new byte[1024];
                int n = 0;
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file3);
                    while ((n = inputStream.read((byte[])object)) >= 0) {
                        fileOutputStream.write((byte[])object, 0, n);
                    }
                    fileOutputStream.close();
                    fileOutputStream = null;
                }
                catch (Throwable throwable) {
                    FileUtils.close(fileOutputStream);
                    throw throwable;
                }
                FileUtils.close(fileOutputStream);
            }
            fileUtils.setFileLastModified(file3, date.getTime());
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.log("Unable to expand to file " + file3.getPath(), 1);
        }
    }

    public void setDest(File file) {
        this.dest = file;
    }

    public void setSrc(File file) {
        this.source = file;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    public void addPatternset(PatternSet patternSet) {
        this.patternsets.addElement(patternSet);
    }

    public void addFileset(FileSet fileSet) {
        this.add(fileSet);
    }

    public void add(ResourceCollection resourceCollection) {
        this.resourcesSpecified = true;
        this.resources.add(resourceCollection);
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException(ERROR_MULTIPLE_MAPPERS, this.getLocation());
        }
        this.mapperElement = new Mapper(this.getProject());
        return this.mapperElement;
    }

    public void add(FileNameMapper fileNameMapper) {
        this.createMapper().add(fileNameMapper);
    }

    public void setEncoding(String string) {
        if (NATIVE_ENCODING.equals(string)) {
            string = null;
        }
        this.encoding = string;
    }
}

