/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class ExecuteOn
extends ExecTask {
    protected Vector filesets = new Vector();
    private Union resources = null;
    private boolean relative = false;
    private boolean parallel = false;
    private boolean forwardSlash = false;
    protected String type = "file";
    protected Commandline.Marker srcFilePos = null;
    private boolean skipEmpty = false;
    protected Commandline.Marker targetFilePos = null;
    protected Mapper mapperElement = null;
    protected FileNameMapper mapper = null;
    protected File destDir = null;
    private int maxParallel = -1;
    private boolean addSourceFile = true;
    private boolean verbose = false;
    private boolean ignoreMissing = true;
    private boolean force = false;
    protected boolean srcIsFirst = true;

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void addDirset(DirSet dirSet) {
        this.filesets.addElement(dirSet);
    }

    public void addFilelist(FileList fileList) {
        this.add(fileList);
    }

    public void add(ResourceCollection resourceCollection) {
        if (this.resources == null) {
            this.resources = new Union();
        }
        this.resources.add(resourceCollection);
    }

    public void setRelative(boolean bl) {
        this.relative = bl;
    }

    public void setParallel(boolean bl) {
        this.parallel = bl;
    }

    public void setType(FileDirBoth fileDirBoth) {
        this.type = fileDirBoth.getValue();
    }

    public void setSkipEmptyFilesets(boolean bl) {
        this.skipEmpty = bl;
    }

    public void setDest(File file) {
        this.destDir = file;
    }

    public void setForwardslash(boolean bl) {
        this.forwardSlash = bl;
    }

    public void setMaxParallel(int n) {
        this.maxParallel = n;
    }

    public void setAddsourcefile(boolean bl) {
        this.addSourceFile = bl;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setIgnoremissing(boolean bl) {
        this.ignoreMissing = bl;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public Commandline.Marker createSrcfile() {
        if (this.srcFilePos != null) {
            throw new BuildException(this.getTaskType() + " doesn't support multiple " + "srcfile elements.", this.getLocation());
        }
        this.srcFilePos = this.cmdl.createMarker();
        return this.srcFilePos;
    }

    public Commandline.Marker createTargetfile() {
        if (this.targetFilePos != null) {
            throw new BuildException(this.getTaskType() + " doesn't support multiple " + "targetfile elements.", this.getLocation());
        }
        this.targetFilePos = this.cmdl.createMarker();
        this.srcIsFirst = this.srcFilePos != null;
        return this.targetFilePos;
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.getLocation());
        }
        this.mapperElement = new Mapper(this.getProject());
        return this.mapperElement;
    }

    public void add(FileNameMapper fileNameMapper) {
        this.createMapper().add(fileNameMapper);
    }

    @Override
    protected void checkConfiguration() {
        if ("execon".equals(this.getTaskName())) {
            this.log("!! execon is deprecated. Use apply instead. !!");
        }
        super.checkConfiguration();
        if (this.filesets.size() == 0 && this.resources == null) {
            throw new BuildException("no resources specified", this.getLocation());
        }
        if (this.targetFilePos != null && this.mapperElement == null) {
            throw new BuildException("targetfile specified without mapper", this.getLocation());
        }
        if (this.destDir != null && this.mapperElement == null) {
            throw new BuildException("dest specified without mapper", this.getLocation());
        }
        if (this.mapperElement != null) {
            this.mapper = this.mapperElement.getImplementation();
        }
    }

    @Override
    protected ExecuteStreamHandler createHandler() throws BuildException {
        return this.redirectorElement == null ? super.createHandler() : new PumpStreamHandler();
    }

    @Override
    protected void setupRedirector() {
        super.setupRedirector();
        this.redirector.setAppendProperties(true);
    }

    @Override
    protected void runExec(Execute execute) throws BuildException {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        try {
            String[] stringArray;
            Object object;
            Object object2;
            Object object3;
            Vector<Object> vector = new Vector<Object>();
            Vector<Object> vector2 = new Vector<Object>();
            for (int i = 0; i < this.filesets.size(); ++i) {
                int n3;
                Object[] objectArray;
                object3 = this.type;
                object2 = (AbstractFileSet)this.filesets.elementAt(i);
                if (object2 instanceof DirSet && !"dir".equals(this.type)) {
                    this.log("Found a nested dirset but type is " + this.type + ". " + "Temporarily switching to type=\"dir\" on the" + " assumption that you really did mean" + " <dirset> not <fileset>.", 4);
                    object3 = "dir";
                }
                object = ((AbstractFileSet)object2).getDir(this.getProject());
                stringArray = ((AbstractFileSet)object2).getDirectoryScanner(this.getProject());
                if (!"dir".equals(object3)) {
                    objectArray = this.getFiles((File)object, (DirectoryScanner)stringArray);
                    for (n3 = 0; n3 < objectArray.length; ++n3) {
                        ++n;
                        vector.addElement(objectArray[n3]);
                        vector2.addElement(object);
                    }
                }
                if (!"file".equals(object3)) {
                    objectArray = this.getDirs((File)object, (DirectoryScanner)stringArray);
                    for (n3 = 0; n3 < objectArray.length; ++n3) {
                        ++n2;
                        vector.addElement(objectArray[n3]);
                        vector2.addElement(object);
                    }
                }
                if (vector.size() == 0 && this.skipEmpty) {
                    this.logSkippingFileset((String)object3, (DirectoryScanner)stringArray, (File)object);
                    continue;
                }
                if (this.parallel) continue;
                objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    String[] stringArray2 = this.getCommandline((String)objectArray[n3], (File)object);
                    this.log(Commandline.describeCommand(stringArray2), 3);
                    execute.setCommandline(stringArray2);
                    if (this.redirectorElement != null) {
                        this.setupRedirector();
                        this.redirectorElement.configure(this.redirector, (String)objectArray[n3]);
                    }
                    if (this.redirectorElement != null || bl) {
                        execute.setStreamHandler(this.redirector.createHandler());
                    }
                    this.runExecute(execute);
                    bl = true;
                }
                vector.removeAllElements();
                vector2.removeAllElements();
            }
            if (this.resources != null) {
                Iterator iterator = this.resources.iterator();
                while (iterator.hasNext()) {
                    object3 = (Resource)iterator.next();
                    if (!((Resource)object3).isExists() && this.ignoreMissing) continue;
                    object2 = null;
                    object = ((Resource)object3).getName();
                    if (object3 instanceof FileResource && (object2 = (stringArray = (FileResource)object3).getBaseDir()) == null) {
                        object = stringArray.getFile().getAbsolutePath();
                    }
                    if (this.restrict(new String[]{object}, (File)object2).length == 0) continue;
                    if (!(((Resource)object3).isDirectory() && ((Resource)object3).isExists() || "dir".equals(this.type))) {
                        ++n;
                    } else {
                        if (!((Resource)object3).isDirectory() || "file".equals(this.type)) continue;
                        ++n2;
                    }
                    vector2.add(object2);
                    vector.add(object);
                    if (this.parallel) continue;
                    stringArray = this.getCommandline((String)object, (File)object2);
                    this.log(Commandline.describeCommand(stringArray), 3);
                    execute.setCommandline(stringArray);
                    if (this.redirectorElement != null) {
                        this.setupRedirector();
                        this.redirectorElement.configure(this.redirector, (String)object);
                    }
                    if (this.redirectorElement != null || bl) {
                        execute.setStreamHandler(this.redirector.createHandler());
                    }
                    this.runExecute(execute);
                    bl = true;
                    vector.removeAllElements();
                    vector2.removeAllElements();
                }
            }
            if (this.parallel && (vector.size() > 0 || !this.skipEmpty)) {
                this.runParallel(execute, vector, vector2);
                bl = true;
            }
            if (bl) {
                this.log("Applied " + this.cmdl.getExecutable() + " to " + n + " file" + (n != 1 ? "s" : "") + " and " + n2 + " director" + (n2 != 1 ? "ies" : "y") + ".", this.verbose ? 2 : 3);
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Execute failed: " + iOException, iOException, this.getLocation());
        }
        finally {
            this.logFlush();
            this.redirector.setAppendProperties(false);
            this.redirector.setProperties();
        }
    }

    private void logSkippingFileset(String string, DirectoryScanner directoryScanner, File file) {
        int n = (!"dir".equals(string) ? directoryScanner.getIncludedFilesCount() : 0) + (!"file".equals(string) ? directoryScanner.getIncludedDirsCount() : 0);
        this.log("Skipping fileset for directory " + file + ". It is " + (n > 0 ? "up to date." : "empty."), this.verbose ? 2 : 3);
    }

    protected String[] getCommandline(String[] stringArray, File[] fileArray) {
        int n;
        String[] stringArray2;
        Object[] objectArray;
        char c = File.separatorChar;
        Vector<String> vector = new Vector<String>();
        if (this.targetFilePos != null) {
            objectArray = new Hashtable();
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2 = this.mapper.mapFileName(stringArray[i]);
                if (stringArray2 == null) continue;
                for (n = 0; n < stringArray2.length; ++n) {
                    String string = null;
                    string = !this.relative ? new File(this.destDir, stringArray2[n]).getAbsolutePath() : stringArray2[n];
                    if (this.forwardSlash && c != '/') {
                        string = string.replace(c, '/');
                    }
                    if (objectArray.contains(string)) continue;
                    vector.addElement(string);
                    objectArray.put(string, string);
                }
            }
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        if (!this.addSourceFile) {
            stringArray = new String[]{};
        }
        String[] stringArray3 = this.cmdl.getCommandline();
        stringArray2 = new String[stringArray3.length + stringArray.length + objectArray.length];
        n = stringArray3.length;
        if (this.srcFilePos != null) {
            n = this.srcFilePos.getPosition();
        }
        if (this.targetFilePos != null) {
            int n2 = this.targetFilePos.getPosition();
            if (n < n2 || n == n2 && this.srcIsFirst) {
                System.arraycopy(stringArray3, 0, stringArray2, 0, n);
                System.arraycopy(stringArray3, n, stringArray2, n + stringArray.length, n2 - n);
                System.arraycopy(objectArray, 0, stringArray2, n2 + stringArray.length, objectArray.length);
                System.arraycopy(stringArray3, n2, stringArray2, n2 + stringArray.length + objectArray.length, stringArray3.length - n2);
            } else {
                System.arraycopy(stringArray3, 0, stringArray2, 0, n2);
                System.arraycopy(objectArray, 0, stringArray2, n2, objectArray.length);
                System.arraycopy(stringArray3, n2, stringArray2, n2 + objectArray.length, n - n2);
                System.arraycopy(stringArray3, n, stringArray2, n + stringArray.length + objectArray.length, stringArray3.length - n);
                n += objectArray.length;
            }
        } else {
            System.arraycopy(stringArray3, 0, stringArray2, 0, n);
            System.arraycopy(stringArray3, n, stringArray2, n + stringArray.length, stringArray3.length - n);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[n + i] = !this.relative ? new File(fileArray[i], stringArray[i]).getAbsolutePath() : stringArray[i];
            if (!this.forwardSlash || c == '/') continue;
            stringArray2[n + i] = stringArray2[n + i].replace(c, '/');
        }
        return stringArray2;
    }

    protected String[] getCommandline(String string, File file) {
        return this.getCommandline(new String[]{string}, new File[]{file});
    }

    protected String[] getFiles(File file, DirectoryScanner directoryScanner) {
        return this.restrict(directoryScanner.getIncludedFiles(), file);
    }

    protected String[] getDirs(File file, DirectoryScanner directoryScanner) {
        return this.restrict(directoryScanner.getIncludedDirectories(), file);
    }

    protected String[] getFilesAndDirs(FileList fileList) {
        return this.restrict(fileList.getFiles(this.getProject()), fileList.getDir(this.getProject()));
    }

    private String[] restrict(String[] stringArray, File file) {
        return this.mapper == null || this.force ? stringArray : new SourceFileScanner(this).restrict(stringArray, file, this.destDir, this.mapper);
    }

    protected void runParallel(Execute execute, Vector vector, Vector vector2) throws IOException, BuildException {
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        Object[] objectArray2 = new File[vector2.size()];
        vector2.copyInto(objectArray2);
        if (this.maxParallel <= 0 || objectArray.length == 0) {
            String[] stringArray = this.getCommandline((String[])objectArray, (File[])objectArray2);
            this.log(Commandline.describeCommand(stringArray), 3);
            execute.setCommandline(stringArray);
            this.runExecute(execute);
        } else {
            int n = vector.size();
            int n2 = 0;
            while (n > 0) {
                int n3 = Math.min(n, this.maxParallel);
                String[] stringArray = new String[n3];
                System.arraycopy(objectArray, n2, stringArray, 0, n3);
                File[] fileArray = new File[n3];
                System.arraycopy(objectArray2, n2, fileArray, 0, n3);
                String[] stringArray2 = this.getCommandline(stringArray, fileArray);
                this.log(Commandline.describeCommand(stringArray2), 3);
                execute.setCommandline(stringArray2);
                if (this.redirectorElement != null) {
                    this.setupRedirector();
                    this.redirectorElement.configure(this.redirector, null);
                }
                if (this.redirectorElement != null || n2 > 0) {
                    execute.setStreamHandler(this.redirector.createHandler());
                }
                this.runExecute(execute);
                n -= n3;
                n2 += n3;
            }
        }
    }

    public static class FileDirBoth
    extends EnumeratedAttribute {
        public static final String FILE = "file";
        public static final String DIR = "dir";

        @Override
        public String[] getValues() {
            return new String[]{FILE, DIR, "both"};
        }
    }
}

