/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.Redirector;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Permissions;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.TimeoutObserver;
import org.apache.tools.ant.util.Watchdog;

public class ExecuteJava
implements Runnable,
TimeoutObserver {
    private Commandline javaCommand = null;
    private Path classpath = null;
    private CommandlineJava.SysProperties sysProperties = null;
    private Permissions perm = null;
    private Method main = null;
    private Long timeout = null;
    private volatile Throwable caught = null;
    private volatile boolean timedOut = false;
    private Thread thread = null;

    public void setJavaCommand(Commandline commandline) {
        this.javaCommand = commandline;
    }

    public void setClasspath(Path path) {
        this.classpath = path;
    }

    public void setSystemProperties(CommandlineJava.SysProperties sysProperties) {
        this.sysProperties = sysProperties;
    }

    public void setPermissions(Permissions permissions) {
        this.perm = permissions;
    }

    public void setOutput(PrintStream printStream) {
    }

    public void setTimeout(Long l) {
        this.timeout = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Project project) throws BuildException {
        String string = this.javaCommand.getExecutable();
        AntClassLoader antClassLoader = null;
        try {
            if (this.sysProperties != null) {
                this.sysProperties.setSystem();
            }
            Class<?> clazz = null;
            try {
                if (this.classpath == null) {
                    clazz = Class.forName(string);
                } else {
                    antClassLoader = project.createClassLoader(this.classpath);
                    antClassLoader.setParent(project.getCoreLoader());
                    antClassLoader.setParentFirst(false);
                    antClassLoader.addJavaLibraries();
                    antClassLoader.setIsolated(true);
                    antClassLoader.setThreadContextLoader();
                    antClassLoader.forceLoadClass(string);
                    clazz = Class.forName(string, true, antClassLoader);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new BuildException("Could not find " + string + "." + " Make sure you have it in your" + " classpath");
            }
            this.main = clazz.getMethod("main", String[].class);
            if (this.main == null) {
                throw new BuildException("Could not find main() method in " + string);
            }
            if ((this.main.getModifiers() & 8) == 0) {
                throw new BuildException("main() method in " + string + " is not declared static");
            }
            if (this.timeout == null) {
                this.run();
            } else {
                this.thread = new Thread((Runnable)this, "ExecuteJava");
                Task task = project.getThreadTask(Thread.currentThread());
                project.registerThreadTask(this.thread, task);
                this.thread.setDaemon(true);
                Watchdog watchdog = new Watchdog(this.timeout);
                watchdog.addTimeoutObserver(this);
                ExecuteJava executeJava = this;
                synchronized (executeJava) {
                    this.thread.start();
                    watchdog.start();
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.timedOut) {
                        project.log("Timeout: sub-process interrupted", 1);
                    } else {
                        this.thread = null;
                        watchdog.stop();
                    }
                }
            }
            if (this.caught != null) {
                throw this.caught;
            }
        }
        catch (BuildException buildException) {
            throw buildException;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new BuildException(throwable);
        }
        finally {
            if (antClassLoader != null) {
                antClassLoader.resetThreadContextLoader();
                antClassLoader.cleanup();
                antClassLoader = null;
            }
            if (this.sysProperties != null) {
                this.sysProperties.restoreSystem();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object[] objectArray = new Object[]{this.javaCommand.getArguments()};
        try {
            if (this.perm != null) {
                this.perm.setSecurityManager();
            }
            this.main.invoke(null, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (!(throwable instanceof InterruptedException)) {
                this.caught = throwable;
            }
        }
        catch (Throwable throwable) {
            this.caught = throwable;
        }
        finally {
            if (this.perm != null) {
                this.perm.restoreSecurityManager();
            }
            ExecuteJava executeJava = this;
            synchronized (executeJava) {
                this.notifyAll();
            }
        }
    }

    @Override
    public synchronized void timeoutOccured(Watchdog watchdog) {
        if (this.thread != null) {
            this.timedOut = true;
            this.thread.interrupt();
        }
        this.notifyAll();
    }

    public synchronized boolean killedProcess() {
        return this.timedOut;
    }

    public int fork(ProjectComponent projectComponent) throws BuildException {
        CommandlineJava commandlineJava = new CommandlineJava();
        commandlineJava.setClassname(this.javaCommand.getExecutable());
        String[] stringArray = this.javaCommand.getArguments();
        for (int i = 0; i < stringArray.length; ++i) {
            commandlineJava.createArgument().setValue(stringArray[i]);
        }
        if (this.classpath != null) {
            commandlineJava.createClasspath(projectComponent.getProject()).append(this.classpath);
        }
        if (this.sysProperties != null) {
            commandlineJava.addSysproperties(this.sysProperties);
        }
        Redirector redirector = new Redirector(projectComponent);
        Execute execute = new Execute(redirector.createHandler(), this.timeout == null ? null : new ExecuteWatchdog(this.timeout));
        execute.setAntRun(projectComponent.getProject());
        if (Os.isFamily("openvms")) {
            ExecuteJava.setupCommandLineForVMS(execute, commandlineJava.getCommandline());
        } else {
            execute.setCommandline(commandlineJava.getCommandline());
        }
        try {
            int n = execute.execute();
            redirector.complete();
            int n2 = n;
            return n2;
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
        finally {
            this.timedOut = execute.killedProcess();
        }
    }

    public static void setupCommandLineForVMS(Execute execute, String[] stringArray) {
        execute.setVMLauncher(true);
        File file = null;
        try {
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
            file = JavaEnvUtils.createVmsJavaOptionFile(stringArray2);
            file.deleteOnExit();
            String[] stringArray3 = new String[]{stringArray[0], "-V", file.getPath()};
            execute.setCommandline(stringArray3);
        }
        catch (IOException iOException) {
            throw new BuildException("Failed to create a temporary file for \"-V\" switch");
        }
    }
}

