/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.ProcessDestroyer;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;

public class Execute {
    private static final int ONE_SECOND = 1000;
    public static final int INVALID = Integer.MAX_VALUE;
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private String[] cmdl = null;
    private String[] env = null;
    private int exitValue = Integer.MAX_VALUE;
    private ExecuteStreamHandler streamHandler;
    private ExecuteWatchdog watchdog;
    private File workingDirectory = null;
    private Project project = null;
    private boolean newEnvironment = false;
    private boolean spawn = false;
    private boolean useVMLauncher = true;
    private static String antWorkingDirectory = System.getProperty("user.dir");
    private static CommandLauncher vmLauncher = null;
    private static CommandLauncher shellLauncher = null;
    private static Vector procEnvironment = null;
    private static ProcessDestroyer processDestroyer = new ProcessDestroyer();
    private static boolean environmentCaseInSensitive = false;

    public void setSpawn(boolean bl) {
        this.spawn = bl;
    }

    public static synchronized Vector getProcEnvironment() {
        if (procEnvironment != null) {
            return procEnvironment;
        }
        procEnvironment = new Vector();
        try {
            String string;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Execute execute = new Execute(new PumpStreamHandler(byteArrayOutputStream));
            execute.setCommandline(Execute.getProcEnvCommand());
            execute.setNewenvironment(true);
            int n = execute.execute();
            if (n != 0) {
                // empty if block
            }
            BufferedReader bufferedReader = new BufferedReader(new StringReader(Execute.toString(byteArrayOutputStream)));
            if (Os.isFamily("openvms")) {
                procEnvironment = Execute.addVMSLogicals(procEnvironment, bufferedReader);
                return procEnvironment;
            }
            String string2 = null;
            String string3 = StringUtils.LINE_SEP;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.indexOf(61) == -1) {
                    if (string2 == null) {
                        string2 = string3 + string;
                        continue;
                    }
                    string2 = string2 + string3 + string;
                    continue;
                }
                if (string2 != null) {
                    procEnvironment.addElement(string2);
                }
                string2 = string;
            }
            if (string2 != null) {
                procEnvironment.addElement(string2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return procEnvironment;
    }

    private static String[] getProcEnvCommand() {
        if (Os.isFamily("os/2")) {
            return new String[]{"cmd", "/c", "set"};
        }
        if (Os.isFamily("windows")) {
            if (Os.isFamily("win9x")) {
                return new String[]{"command.com", "/c", "set"};
            }
            return new String[]{"cmd", "/c", "set"};
        }
        if (Os.isFamily("z/os") || Os.isFamily("unix")) {
            String[] stringArray = new String[]{new File("/bin/env").canRead() ? "/bin/env" : (new File("/usr/bin/env").canRead() ? "/usr/bin/env" : "env")};
            return stringArray;
        }
        if (Os.isFamily("netware") || Os.isFamily("os/400")) {
            return new String[]{"env"};
        }
        if (Os.isFamily("openvms")) {
            return new String[]{"show", "logical"};
        }
        return null;
    }

    public static String toString(ByteArrayOutputStream byteArrayOutputStream) {
        if (Os.isFamily("z/os")) {
            try {
                return byteArrayOutputStream.toString("Cp1047");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
        } else if (Os.isFamily("os/400")) {
            try {
                return byteArrayOutputStream.toString("Cp500");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return byteArrayOutputStream.toString();
    }

    public Execute() {
        this(new PumpStreamHandler(), null);
    }

    public Execute(ExecuteStreamHandler executeStreamHandler) {
        this(executeStreamHandler, null);
    }

    public Execute(ExecuteStreamHandler executeStreamHandler, ExecuteWatchdog executeWatchdog) {
        this.setStreamHandler(executeStreamHandler);
        this.watchdog = executeWatchdog;
        if (Os.isFamily("openvms")) {
            this.useVMLauncher = false;
        }
    }

    public void setStreamHandler(ExecuteStreamHandler executeStreamHandler) {
        this.streamHandler = executeStreamHandler;
    }

    public String[] getCommandline() {
        return this.cmdl;
    }

    public void setCommandline(String[] stringArray) {
        this.cmdl = stringArray;
    }

    public void setNewenvironment(boolean bl) {
        this.newEnvironment = bl;
    }

    public String[] getEnvironment() {
        return this.env == null || this.newEnvironment ? this.env : this.patchEnvironment();
    }

    public void setEnvironment(String[] stringArray) {
        this.env = stringArray;
    }

    public void setWorkingDirectory(File file) {
        this.workingDirectory = file == null || file.getAbsolutePath().equals(antWorkingDirectory) ? null : file;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory == null ? new File(antWorkingDirectory) : this.workingDirectory;
    }

    public void setAntRun(Project project) throws BuildException {
        this.project = project;
    }

    public void setVMLauncher(boolean bl) {
        this.useVMLauncher = bl;
    }

    public static Process launch(Project project, String[] stringArray, String[] stringArray2, File file, boolean bl) throws IOException {
        if (file != null && !file.exists()) {
            throw new BuildException(file + " doesn't exist.");
        }
        CommandLauncher commandLauncher = bl && vmLauncher != null ? vmLauncher : shellLauncher;
        return commandLauncher.exec(project, stringArray, stringArray2, file);
    }

    public int execute() throws IOException {
        if (this.workingDirectory != null && !this.workingDirectory.exists()) {
            throw new BuildException(this.workingDirectory + " doesn't exist.");
        }
        Process process = Execute.launch(this.project, this.getCommandline(), this.getEnvironment(), this.workingDirectory, this.useVMLauncher);
        try {
            this.streamHandler.setProcessInputStream(process.getOutputStream());
            this.streamHandler.setProcessOutputStream(process.getInputStream());
            this.streamHandler.setProcessErrorStream(process.getErrorStream());
        }
        catch (IOException iOException) {
            process.destroy();
            throw iOException;
        }
        this.streamHandler.start();
        try {
            processDestroyer.add(process);
            if (this.watchdog != null) {
                this.watchdog.start(process);
            }
            this.waitFor(process);
            if (this.watchdog != null) {
                this.watchdog.stop();
            }
            this.streamHandler.stop();
            Execute.closeStreams(process);
            if (this.watchdog != null) {
                this.watchdog.checkException();
            }
            int n = this.getExitValue();
            return n;
        }
        catch (ThreadDeath threadDeath) {
            process.destroy();
            throw threadDeath;
        }
        finally {
            processDestroyer.remove(process);
        }
    }

    public void spawn() throws IOException {
        if (this.workingDirectory != null && !this.workingDirectory.exists()) {
            throw new BuildException(this.workingDirectory + " doesn't exist.");
        }
        Process process = Execute.launch(this.project, this.getCommandline(), this.getEnvironment(), this.workingDirectory, this.useVMLauncher);
        if (Os.isFamily("windows")) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                this.project.log("interruption in the sleep after having spawned a process", 3);
            }
        }
        OutputStream outputStream = new OutputStream(){

            @Override
            public void write(int n) throws IOException {
            }
        };
        PumpStreamHandler pumpStreamHandler = new PumpStreamHandler(outputStream);
        pumpStreamHandler.setProcessErrorStream(process.getErrorStream());
        pumpStreamHandler.setProcessOutputStream(process.getInputStream());
        pumpStreamHandler.start();
        process.getOutputStream().close();
        this.project.log("spawned process " + process.toString(), 3);
    }

    protected void waitFor(Process process) {
        try {
            process.waitFor();
            this.setExitValue(process.exitValue());
        }
        catch (InterruptedException interruptedException) {
            process.destroy();
        }
    }

    protected void setExitValue(int n) {
        this.exitValue = n;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public static boolean isFailure(int n) {
        return Os.isFamily("openvms") ? n % 2 == 0 : n != 0;
    }

    public boolean isFailure() {
        return Execute.isFailure(this.getExitValue());
    }

    public boolean killedProcess() {
        return this.watchdog != null && this.watchdog.killedProcess();
    }

    private String[] patchEnvironment() {
        if (Os.isFamily("openvms")) {
            return this.env;
        }
        Vector vector = (Vector)Execute.getProcEnvironment().clone();
        for (int i = 0; i < this.env.length; ++i) {
            String string = this.env[i];
            String string2 = string.substring(0, string.indexOf(61) + 1);
            if (environmentCaseInSensitive) {
                string2 = string2.toLowerCase();
            }
            int n = vector.size();
            for (int j = 0; j < n; ++j) {
                String string3;
                String string4 = (String)vector.elementAt(j);
                String string5 = string3 = environmentCaseInSensitive ? string4.toLowerCase() : string4;
                if (!string3.startsWith(string2)) continue;
                vector.removeElementAt(j);
                if (!environmentCaseInSensitive) break;
                string = string4.substring(0, string2.length()) + string.substring(string2.length());
                break;
            }
            vector.addElement(string);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public static void runCommand(Task task, String[] stringArray) throws BuildException {
        try {
            task.log(Commandline.describeCommand(stringArray), 3);
            Execute execute = new Execute(new LogStreamHandler(task, 2, 0));
            execute.setAntRun(task.getProject());
            execute.setCommandline(stringArray);
            int n = execute.execute();
            if (Execute.isFailure(n)) {
                throw new BuildException(stringArray[0] + " failed with return code " + n, task.getLocation());
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Could not launch " + stringArray[0] + ": " + iOException, task.getLocation());
        }
    }

    public static void closeStreams(Process process) {
        FileUtils.close(process.getInputStream());
        FileUtils.close(process.getOutputStream());
        FileUtils.close(process.getErrorStream());
    }

    private static Vector addVMSLogicals(Vector vector, BufferedReader bufferedReader) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = null;
        String string2 = null;
        String string3 = null;
        while ((string3 = bufferedReader.readLine()) != null) {
            int n;
            String string4;
            if (string3.startsWith("\t=")) {
                if (string == null) continue;
                string2 = string2 + "," + string3.substring(4, string3.length() - 1);
                continue;
            }
            if (!string3.startsWith("  \"")) continue;
            if (string != null) {
                hashMap.put(string, string2);
            }
            if (hashMap.containsKey(string4 = string3.substring(3, (n = string3.indexOf(61)) - 2))) {
                string = null;
                continue;
            }
            string = string4;
            string2 = string3.substring(n + 3, string3.length() - 1);
        }
        if (string != null) {
            hashMap.put(string, string2);
        }
        for (String string5 : hashMap.keySet()) {
            vector.add(string5 + "=" + hashMap.get(string5));
        }
        return vector;
    }

    static {
        try {
            if (!Os.isFamily("os/2")) {
                vmLauncher = new Java13CommandLauncher();
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (Os.isFamily("mac") && !Os.isFamily("unix")) {
            shellLauncher = new MacCommandLauncher(new CommandLauncher());
        } else if (Os.isFamily("os/2")) {
            shellLauncher = new OS2CommandLauncher(new CommandLauncher());
        } else if (Os.isFamily("windows")) {
            environmentCaseInSensitive = true;
            CommandLauncher commandLauncher = new CommandLauncher();
            shellLauncher = !Os.isFamily("win9x") ? new WinNTCommandLauncher(commandLauncher) : new ScriptCommandLauncher("bin/antRun.bat", commandLauncher);
        } else if (Os.isFamily("netware")) {
            CommandLauncher commandLauncher = new CommandLauncher();
            shellLauncher = new PerlScriptCommandLauncher("bin/antRun.pl", commandLauncher);
        } else if (Os.isFamily("openvms")) {
            try {
                shellLauncher = new VmsCommandLauncher();
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        } else {
            shellLauncher = new ScriptCommandLauncher("bin/antRun", new CommandLauncher());
        }
    }

    private static class VmsCommandLauncher
    extends Java13CommandLauncher {
        @Override
        public Process exec(Project project, String[] stringArray, String[] stringArray2) throws IOException {
            File file = this.createCommandFile(stringArray, stringArray2);
            Process process = super.exec(project, new String[]{file.getPath()}, stringArray2);
            this.deleteAfter(file, process);
            return process;
        }

        @Override
        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            File file2 = this.createCommandFile(stringArray, stringArray2);
            Process process = super.exec(project, new String[]{file2.getPath()}, stringArray2, file);
            this.deleteAfter(file2, process);
            return process;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File createCommandFile(String[] stringArray, String[] stringArray2) throws IOException {
            File file = FILE_UTILS.createTempFile("ANT", ".COM", null, true, true);
            PrintWriter printWriter = null;
            try {
                int n;
                printWriter = new PrintWriter(new FileWriter(file));
                if (stringArray2 != null) {
                    for (int i = 0; i < stringArray2.length; ++i) {
                        n = stringArray2[i].indexOf(61);
                        if (n == -1) continue;
                        printWriter.print("$ DEFINE/NOLOG ");
                        printWriter.print(stringArray2[i].substring(0, n));
                        printWriter.print(" \"");
                        printWriter.print(stringArray2[i].substring(n + 1));
                        printWriter.println('\"');
                    }
                }
                printWriter.print("$ " + stringArray[0]);
                for (n = 1; n < stringArray.length; ++n) {
                    printWriter.println(" -");
                    printWriter.print(stringArray[n]);
                }
            }
            finally {
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            return file;
        }

        private void deleteAfter(final File file, final Process process) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    FileUtils.delete(file);
                }
            }.start();
        }
    }

    private static class PerlScriptCommandLauncher
    extends CommandLauncherProxy {
        private String myScript;

        PerlScriptCommandLauncher(String string, CommandLauncher commandLauncher) {
            super(commandLauncher);
            this.myScript = string;
        }

        @Override
        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            if (project == null) {
                if (file == null) {
                    return this.exec(project, stringArray, stringArray2);
                }
                throw new IOException("Cannot locate antRun script: No project provided");
            }
            String string = project.getProperty("ant.home");
            if (string == null) {
                throw new IOException("Cannot locate antRun script: Property 'ant.home' not found");
            }
            String string2 = FILE_UTILS.resolveFile(project.getBaseDir(), string + File.separator + this.myScript).toString();
            File file2 = file;
            if (file == null) {
                file2 = project.getBaseDir();
            }
            String[] stringArray3 = new String[stringArray.length + 3];
            stringArray3[0] = "perl";
            stringArray3[1] = string2;
            stringArray3[2] = file2.getAbsolutePath();
            System.arraycopy(stringArray, 0, stringArray3, 3, stringArray.length);
            return this.exec(project, stringArray3, stringArray2);
        }
    }

    private static class ScriptCommandLauncher
    extends CommandLauncherProxy {
        private String myScript;

        ScriptCommandLauncher(String string, CommandLauncher commandLauncher) {
            super(commandLauncher);
            this.myScript = string;
        }

        @Override
        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            if (project == null) {
                if (file == null) {
                    return this.exec(project, stringArray, stringArray2);
                }
                throw new IOException("Cannot locate antRun script: No project provided");
            }
            String string = project.getProperty("ant.home");
            if (string == null) {
                throw new IOException("Cannot locate antRun script: Property 'ant.home' not found");
            }
            String string2 = FILE_UTILS.resolveFile(project.getBaseDir(), string + File.separator + this.myScript).toString();
            File file2 = file;
            if (file == null) {
                file2 = project.getBaseDir();
            }
            String[] stringArray3 = new String[stringArray.length + 2];
            stringArray3[0] = string2;
            stringArray3[1] = file2.getAbsolutePath();
            System.arraycopy(stringArray, 0, stringArray3, 2, stringArray.length);
            return this.exec(project, stringArray3, stringArray2);
        }
    }

    private static class MacCommandLauncher
    extends CommandLauncherProxy {
        MacCommandLauncher(CommandLauncher commandLauncher) {
            super(commandLauncher);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            if (file == null) {
                return this.exec(project, stringArray, stringArray2);
            }
            System.getProperties().put("user.dir", file.getAbsolutePath());
            try {
                Process process = this.exec(project, stringArray, stringArray2);
                return process;
            }
            finally {
                System.getProperties().put("user.dir", antWorkingDirectory);
            }
        }
    }

    private static class WinNTCommandLauncher
    extends CommandLauncherProxy {
        WinNTCommandLauncher(CommandLauncher commandLauncher) {
            super(commandLauncher);
        }

        @Override
        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            File file2 = file;
            if (file == null) {
                if (project != null) {
                    file2 = project.getBaseDir();
                } else {
                    return this.exec(project, stringArray, stringArray2);
                }
            }
            String[] stringArray3 = new String[stringArray.length + 6];
            stringArray3[0] = "cmd";
            stringArray3[1] = "/c";
            stringArray3[2] = "cd";
            stringArray3[3] = "/d";
            stringArray3[4] = file2.getAbsolutePath();
            stringArray3[5] = "&&";
            System.arraycopy(stringArray, 0, stringArray3, 6, stringArray.length);
            return this.exec(project, stringArray3, stringArray2);
        }
    }

    private static class OS2CommandLauncher
    extends CommandLauncherProxy {
        OS2CommandLauncher(CommandLauncher commandLauncher) {
            super(commandLauncher);
        }

        @Override
        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            File file2 = file;
            if (file == null) {
                if (project != null) {
                    file2 = project.getBaseDir();
                } else {
                    return this.exec(project, stringArray, stringArray2);
                }
            }
            String string = file2.getAbsolutePath();
            String[] stringArray3 = new String[stringArray.length + 7];
            stringArray3[0] = "cmd";
            stringArray3[1] = "/c";
            stringArray3[2] = string.substring(0, 2);
            stringArray3[3] = "&&";
            stringArray3[4] = "cd";
            stringArray3[5] = string.substring(2);
            stringArray3[6] = "&&";
            System.arraycopy(stringArray, 0, stringArray3, 7, stringArray.length);
            return this.exec(project, stringArray3, stringArray2);
        }
    }

    private static class CommandLauncherProxy
    extends CommandLauncher {
        private CommandLauncher myLauncher;

        CommandLauncherProxy(CommandLauncher commandLauncher) {
            this.myLauncher = commandLauncher;
        }

        @Override
        public Process exec(Project project, String[] stringArray, String[] stringArray2) throws IOException {
            return this.myLauncher.exec(project, stringArray, stringArray2);
        }
    }

    private static class Java13CommandLauncher
    extends CommandLauncher {
        private Method myExecWithCWD = Runtime.class.getMethod("exec", String[].class, String[].class, File.class);

        @Override
        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            try {
                if (project != null) {
                    project.log("Execute:Java13CommandLauncher: " + Commandline.describeCommand(stringArray), 4);
                }
                return (Process)this.myExecWithCWD.invoke((Object)Runtime.getRuntime(), stringArray, stringArray2, file);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw new BuildException("Unable to execute command", throwable);
            }
            catch (Exception exception) {
                throw new BuildException("Unable to execute command", exception);
            }
        }
    }

    private static class CommandLauncher {
        private CommandLauncher() {
        }

        public Process exec(Project project, String[] stringArray, String[] stringArray2) throws IOException {
            if (project != null) {
                project.log("Execute:CommandLauncher: " + Commandline.describeCommand(stringArray), 4);
            }
            return Runtime.getRuntime().exec(stringArray, stringArray2);
        }

        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            if (file == null) {
                return this.exec(project, stringArray, stringArray2);
            }
            throw new IOException("Cannot execute a process in different directory under this JVM");
        }
    }
}

