/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.Redirector;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.RedirectorElement;
import org.apache.tools.ant.util.FileUtils;

public class ExecTask
extends Task {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private String os;
    private String osFamily;
    private File dir;
    protected boolean failOnError = false;
    protected boolean newEnvironment = false;
    private Long timeout = null;
    private Environment env = new Environment();
    protected Commandline cmdl = new Commandline();
    private String resultProperty;
    private boolean failIfExecFails = true;
    private String executable;
    private boolean resolveExecutable = false;
    private boolean searchPath = false;
    private boolean spawn = false;
    private boolean incompatibleWithSpawn = false;
    private String inputString;
    private File input;
    private File output;
    private File error;
    protected Redirector redirector = new Redirector(this);
    protected RedirectorElement redirectorElement;
    private boolean vmLauncher = true;

    public ExecTask() {
    }

    public ExecTask(Task task) {
        this.bindToOwner(task);
    }

    public void setSpawn(boolean bl) {
        this.spawn = bl;
    }

    public void setTimeout(Long l) {
        this.timeout = l;
        this.incompatibleWithSpawn = true;
    }

    public void setTimeout(Integer n) {
        this.setTimeout(n == null ? null : new Long(n.intValue()));
    }

    public void setExecutable(String string) {
        this.executable = string;
        this.cmdl.setExecutable(string);
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void setOs(String string) {
        this.os = string;
    }

    public void setCommand(Commandline commandline) {
        this.log("The command attribute is deprecated.\nPlease use the executable attribute and nested arg elements.", 1);
        this.cmdl = commandline;
    }

    public void setOutput(File file) {
        this.output = file;
        this.incompatibleWithSpawn = true;
    }

    public void setInput(File file) {
        if (this.inputString != null) {
            throw new BuildException("The \"input\" and \"inputstring\" attributes cannot both be specified");
        }
        this.input = file;
        this.incompatibleWithSpawn = true;
    }

    public void setInputString(String string) {
        if (this.input != null) {
            throw new BuildException("The \"input\" and \"inputstring\" attributes cannot both be specified");
        }
        this.inputString = string;
        this.incompatibleWithSpawn = true;
    }

    public void setLogError(boolean bl) {
        this.redirector.setLogError(bl);
        this.incompatibleWithSpawn |= bl;
    }

    public void setError(File file) {
        this.error = file;
        this.incompatibleWithSpawn = true;
    }

    public void setOutputproperty(String string) {
        this.redirector.setOutputProperty(string);
        this.incompatibleWithSpawn = true;
    }

    public void setErrorProperty(String string) {
        this.redirector.setErrorProperty(string);
        this.incompatibleWithSpawn = true;
    }

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
        this.incompatibleWithSpawn |= bl;
    }

    public void setNewenvironment(boolean bl) {
        this.newEnvironment = bl;
    }

    public void setResolveExecutable(boolean bl) {
        this.resolveExecutable = bl;
    }

    public void setSearchPath(boolean bl) {
        this.searchPath = bl;
    }

    public boolean getResolveExecutable() {
        return this.resolveExecutable;
    }

    public void addEnv(Environment.Variable variable) {
        this.env.addVariable(variable);
    }

    public Commandline.Argument createArg() {
        return this.cmdl.createArgument();
    }

    public void setResultProperty(String string) {
        this.resultProperty = string;
        this.incompatibleWithSpawn = true;
    }

    protected void maybeSetResultPropertyValue(int n) {
        if (this.resultProperty != null) {
            String string = Integer.toString(n);
            this.getProject().setNewProperty(this.resultProperty, string);
        }
    }

    public void setFailIfExecutionFails(boolean bl) {
        this.failIfExecFails = bl;
        this.incompatibleWithSpawn = true;
    }

    public void setAppend(boolean bl) {
        this.redirector.setAppend(bl);
        this.incompatibleWithSpawn = true;
    }

    public void addConfiguredRedirector(RedirectorElement redirectorElement) {
        if (this.redirectorElement != null) {
            throw new BuildException("cannot have > 1 nested <redirector>s");
        }
        this.redirectorElement = redirectorElement;
        this.incompatibleWithSpawn = true;
    }

    public void setOsFamily(String string) {
        this.osFamily = string.toLowerCase(Locale.US);
    }

    protected String resolveExecutable(String string, boolean bl) {
        if (!this.resolveExecutable) {
            return string;
        }
        File file = this.getProject().resolveFile(string);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        if (this.dir != null && (file = FILE_UTILS.resolveFile(this.dir, string)).exists()) {
            return file.getAbsolutePath();
        }
        if (bl) {
            Path path = null;
            String[] stringArray = this.env.getVariables();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!this.isPath(stringArray[i])) continue;
                    path = new Path(this.getProject(), this.getPath(stringArray[i]));
                    break;
                }
            }
            if (path == null) {
                Vector vector = Execute.getProcEnvironment();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    if (!this.isPath(string2)) continue;
                    path = new Path(this.getProject(), this.getPath(string2));
                    break;
                }
            }
            if (path != null) {
                String[] stringArray2 = path.list();
                for (int i = 0; i < stringArray2.length; ++i) {
                    file = FILE_UTILS.resolveFile(new File(stringArray2[i]), string);
                    if (!file.exists()) continue;
                    return file.getAbsolutePath();
                }
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        if (!this.isValidOs()) {
            return;
        }
        File file = this.dir;
        this.cmdl.setExecutable(this.resolveExecutable(this.executable, this.searchPath));
        this.checkConfiguration();
        try {
            this.runExec(this.prepareExec());
        }
        finally {
            this.dir = file;
        }
    }

    protected void checkConfiguration() throws BuildException {
        if (this.cmdl.getExecutable() == null) {
            throw new BuildException("no executable specified", this.getLocation());
        }
        if (this.dir != null && !this.dir.exists()) {
            throw new BuildException("The directory " + this.dir + " does not exist");
        }
        if (this.dir != null && !this.dir.isDirectory()) {
            throw new BuildException(this.dir + " is not a directory");
        }
        if (this.spawn && this.incompatibleWithSpawn) {
            this.getProject().log("spawn does not allow attributes related to input, output, error, result", 0);
            this.getProject().log("spawn also does not allow timeout", 0);
            this.getProject().log("finally, spawn is not compatible with a nested I/O <redirector>", 0);
            throw new BuildException("You have used an attribute or nested element which is not compatible with spawn");
        }
        this.setupRedirector();
    }

    protected void setupRedirector() {
        this.redirector.setInput(this.input);
        this.redirector.setInputString(this.inputString);
        this.redirector.setOutput(this.output);
        this.redirector.setError(this.error);
    }

    protected boolean isValidOs() {
        if (this.osFamily != null && !Os.isOs(this.osFamily, null, null, null)) {
            return false;
        }
        String string = System.getProperty("os.name");
        this.log("Current OS is " + string, 3);
        if (this.os != null && this.os.indexOf(string) < 0) {
            this.log("This OS, " + string + " was not found in the specified list of valid OSes: " + this.os, 3);
            return false;
        }
        return true;
    }

    public void setVMLauncher(boolean bl) {
        this.vmLauncher = bl;
    }

    protected Execute prepareExec() throws BuildException {
        if (this.dir == null) {
            this.dir = this.getProject().getBaseDir();
        }
        if (this.redirectorElement != null) {
            this.redirectorElement.configure(this.redirector);
        }
        Execute execute = new Execute(this.createHandler(), this.createWatchdog());
        execute.setAntRun(this.getProject());
        execute.setWorkingDirectory(this.dir);
        execute.setVMLauncher(this.vmLauncher);
        execute.setSpawn(this.spawn);
        String[] stringArray = this.env.getVariables();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.log("Setting environment variable: " + stringArray[i], 3);
            }
        }
        execute.setNewenvironment(this.newEnvironment);
        execute.setEnvironment(stringArray);
        return execute;
    }

    protected final void runExecute(Execute execute) throws IOException {
        int n = -1;
        if (!this.spawn) {
            n = execute.execute();
            if (execute.killedProcess()) {
                String string = "Timeout: killed the sub-process";
                if (this.failOnError) {
                    throw new BuildException(string);
                }
                this.log(string, 1);
            }
            this.maybeSetResultPropertyValue(n);
            this.redirector.complete();
            if (Execute.isFailure(n)) {
                if (this.failOnError) {
                    throw new BuildException(this.getTaskType() + " returned: " + n, this.getLocation());
                }
                this.log("Result: " + n, 0);
            }
        } else {
            execute.spawn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runExec(Execute execute) throws BuildException {
        this.log(this.cmdl.describeCommand(), 3);
        execute.setCommandline(this.cmdl.getCommandline());
        try {
            this.runExecute(execute);
        }
        catch (IOException iOException) {
            if (this.failIfExecFails) {
                throw new BuildException("Execute failed: " + iOException.toString(), iOException, this.getLocation());
            }
            this.log("Execute failed: " + iOException.toString(), 0);
        }
        finally {
            this.logFlush();
        }
    }

    protected ExecuteStreamHandler createHandler() throws BuildException {
        return this.redirector.createHandler();
    }

    protected ExecuteWatchdog createWatchdog() throws BuildException {
        return this.timeout == null ? null : new ExecuteWatchdog(this.timeout);
    }

    protected void logFlush() {
    }

    private boolean isPath(String string) {
        return string.startsWith("PATH=") || string.startsWith("Path=");
    }

    private String getPath(String string) {
        return string.substring("PATH=".length());
    }
}

