/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.LogLevel;
import org.apache.tools.ant.util.FileUtils;

public class Echo
extends Task {
    protected String message = "";
    protected File file = null;
    protected boolean append = false;
    private String encoding = "";
    protected int logLevel = 1;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute() throws BuildException {
        if (this.file == null) {
            this.log(this.message, this.logLevel);
            return;
        }
        Writer writer = null;
        try {
            String string = this.file.getAbsolutePath();
            writer = this.encoding == null || this.encoding.length() == 0 ? new FileWriter(string, this.append) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string, this.append), this.encoding));
            ((Writer)writer).write(this.message, 0, this.message.length());
        }
        catch (IOException iOException) {
            try {
                throw new BuildException(iOException, this.getLocation());
            }
            catch (Throwable throwable) {
                FileUtils.close(writer);
                throw throwable;
            }
        }
        FileUtils.close(writer);
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setAppend(boolean bl) {
        this.append = bl;
    }

    public void addText(String string) {
        this.message = this.message + this.getProject().replaceProperties(string);
    }

    public void setLevel(EchoLevel echoLevel) {
        this.logLevel = echoLevel.getLevel();
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public static class EchoLevel
    extends LogLevel {
    }
}

