/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.zip.ZipOutputStream;

public class Ear
extends Jar {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private File deploymentDescriptor;
    private boolean descriptorAdded;
    private static final String XML_DESCRIPTOR_PATH = "META-INF/application.xml";

    public Ear() {
        this.archiveType = "ear";
        this.emptyBehavior = "create";
    }

    public void setEarfile(File file) {
        this.setDestFile(file);
    }

    public void setAppxml(File file) {
        this.deploymentDescriptor = file;
        if (!this.deploymentDescriptor.exists()) {
            throw new BuildException("Deployment descriptor: " + this.deploymentDescriptor + " does not exist.");
        }
        ZipFileSet zipFileSet = new ZipFileSet();
        zipFileSet.setFile(this.deploymentDescriptor);
        zipFileSet.setFullpath(XML_DESCRIPTOR_PATH);
        super.addFileset(zipFileSet);
    }

    public void addArchives(ZipFileSet zipFileSet) {
        zipFileSet.setPrefix("/");
        super.addFileset(zipFileSet);
    }

    @Override
    protected void initZipOutputStream(ZipOutputStream zipOutputStream) throws IOException, BuildException {
        if (this.deploymentDescriptor == null && !this.isInUpdateMode()) {
            throw new BuildException("appxml attribute is required", this.getLocation());
        }
        super.initZipOutputStream(zipOutputStream);
    }

    @Override
    protected void zipFile(File file, ZipOutputStream zipOutputStream, String string, int n) throws IOException {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        if (XML_DESCRIPTOR_PATH.equals(string2)) {
            if (this.deploymentDescriptor != null || !FILE_UTILS.fileNameEquals(this.deploymentDescriptor, file) || this.descriptorAdded) {
                this.log("Warning: selected " + this.archiveType + " files include a " + XML_DESCRIPTOR_PATH + " which will" + " be ignored (please use appxml attribute to " + this.archiveType + " task)", 1);
            } else {
                super.zipFile(file, zipOutputStream, string, n);
                this.descriptorAdded = true;
            }
        } else {
            super.zipFile(file, zipOutputStream, string, n);
        }
    }

    @Override
    protected void cleanUp() {
        this.descriptorAdded = false;
        super.cleanUp();
    }
}

