/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.tools.ant.AntTypeDefinition;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.taskdefs.Antlib;
import org.apache.tools.ant.taskdefs.DefBase;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.util.FileUtils;

public abstract class Definer
extends DefBase {
    private static final String ANTLIB_XML = "/antlib.xml";
    private static ResourceStack resourceStack = new ResourceStack();
    private String name;
    private String classname;
    private File file;
    private String resource;
    private int format = 0;
    private boolean definerSet = false;
    private int onError = 0;
    private String adapter;
    private String adaptTo;
    private Class adapterClass;
    private Class adaptToClass;

    public void setOnError(OnError onError) {
        this.onError = onError.getIndex();
    }

    public void setFormat(Format format) {
        this.format = format.getIndex();
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public String getResource() {
        return this.resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        Object object;
        ClassLoader classLoader = this.createLoader();
        if (!this.definerSet) {
            if (this.getURI() == null) {
                throw new BuildException("name, file or resource attribute of " + this.getTaskName() + " is undefined", this.getLocation());
            }
            if (this.getURI().startsWith("antlib:")) {
                object = this.getURI();
                this.setResource(Definer.makeResourceFromURI((String)object));
            } else {
                throw new BuildException("Only antlib URIs can be located from the URI alone,not the URI " + this.getURI());
            }
        }
        if (this.name != null) {
            if (this.classname == null) {
                throw new BuildException("classname attribute of " + this.getTaskName() + " element " + "is undefined", this.getLocation());
            }
            this.addDefinition(classLoader, this.name, this.classname);
        } else {
            URL uRL;
            if (this.classname != null) {
                object = "You must not specify classname together with file or resource.";
                throw new BuildException((String)object, this.getLocation());
            }
            object = null;
            if (this.file != null) {
                uRL = this.fileToURL();
                if (uRL == null) {
                    return;
                }
                object = new Enumeration(){
                    private boolean more = true;

                    @Override
                    public boolean hasMoreElements() {
                        return this.more;
                    }

                    public Object nextElement() throws NoSuchElementException {
                        if (this.more) {
                            this.more = false;
                            return uRL;
                        }
                        throw new NoSuchElementException();
                    }
                };
            } else {
                object = this.resourceToURLs(classLoader);
            }
            while (object.hasMoreElements()) {
                uRL = (URL)object.nextElement();
                int n = this.format;
                if (uRL.toString().toLowerCase(Locale.US).endsWith(".xml")) {
                    n = 1;
                }
                if (n == 0) {
                    this.loadProperties(classLoader, uRL);
                    break;
                }
                if (resourceStack.getStack().get(uRL) != null) {
                    this.log("Warning: Recursive loading of " + uRL + " ignored" + " at " + this.getLocation() + " originally loaded at " + resourceStack.getStack().get(uRL), 1);
                    continue;
                }
                try {
                    resourceStack.getStack().put(uRL, this.getLocation());
                    this.loadAntlib(classLoader, uRL);
                }
                finally {
                    resourceStack.getStack().remove(uRL);
                }
            }
        }
    }

    public static String makeResourceFromURI(String string) {
        String string2;
        String string3 = string.substring("antlib:".length());
        if (string3.startsWith("//")) {
            string2 = string3.substring("//".length());
            if (!string2.endsWith(".xml")) {
                string2 = string2 + ANTLIB_XML;
            }
        } else {
            string2 = string3.replace('.', '/') + ANTLIB_XML;
        }
        return string2;
    }

    private URL fileToURL() {
        String string = null;
        if (!this.file.exists()) {
            string = "File " + this.file + " does not exist";
        }
        if (string == null && !this.file.isFile()) {
            string = "File " + this.file + " is not a file";
        }
        try {
            if (string == null) {
                return this.file.toURL();
            }
        }
        catch (Exception exception) {
            string = "File " + this.file + " cannot use as URL: " + exception.toString();
        }
        switch (this.onError) {
            case 3: {
                throw new BuildException(string);
            }
            case 0: 
            case 1: {
                this.log(string, 1);
                break;
            }
            case 2: {
                this.log(string, 3);
                break;
            }
        }
        return null;
    }

    private Enumeration resourceToURLs(ClassLoader classLoader) {
        Enumeration<URL> enumeration;
        try {
            enumeration = classLoader.getResources(this.resource);
        }
        catch (IOException iOException) {
            throw new BuildException("Could not fetch resources named " + this.resource, iOException, this.getLocation());
        }
        if (!enumeration.hasMoreElements()) {
            String string = "Could not load definitions from resource " + this.resource + ". It could not be found.";
            switch (this.onError) {
                case 3: {
                    throw new BuildException(string);
                }
                case 0: 
                case 1: {
                    this.log(string, 1);
                    break;
                }
                case 2: {
                    this.log(string, 3);
                    break;
                }
            }
        }
        return enumeration;
    }

    protected void loadProperties(ClassLoader classLoader, URL uRL) {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            if (inputStream == null) {
                this.log("Could not load definitions from " + uRL, 1);
                return;
            }
            Properties properties = new Properties();
            properties.load(inputStream);
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                this.name = (String)enumeration.nextElement();
                this.classname = properties.getProperty(this.name);
                this.addDefinition(classLoader, this.name, this.classname);
            }
        }
        catch (IOException iOException) {
            throw new BuildException(iOException, this.getLocation());
        }
        finally {
            FileUtils.close(inputStream);
        }
    }

    private void loadAntlib(ClassLoader classLoader, URL uRL) {
        try {
            Antlib antlib = Antlib.createAntlib(this.getProject(), uRL, this.getURI());
            antlib.setClassLoader(classLoader);
            antlib.setURI(this.getURI());
            antlib.execute();
        }
        catch (BuildException buildException) {
            throw ProjectHelper.addLocationToBuildException(buildException, this.getLocation());
        }
    }

    public void setFile(File file) {
        if (this.definerSet) {
            this.tooManyDefinitions();
        }
        this.definerSet = true;
        this.file = file;
    }

    public void setResource(String string) {
        if (this.definerSet) {
            this.tooManyDefinitions();
        }
        this.definerSet = true;
        this.resource = string;
    }

    public void setAntlib(String string) {
        if (this.definerSet) {
            this.tooManyDefinitions();
        }
        if (!string.startsWith("antlib:")) {
            throw new BuildException("Invalid antlib attribute - it must start with antlib:");
        }
        this.setURI(string);
        this.resource = string.substring("antlib:".length()).replace('.', '/') + ANTLIB_XML;
        this.definerSet = true;
    }

    public void setName(String string) {
        if (this.definerSet) {
            this.tooManyDefinitions();
        }
        this.definerSet = true;
        this.name = string;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String string) {
        this.classname = string;
    }

    public void setAdapter(String string) {
        this.adapter = string;
    }

    protected void setAdapterClass(Class clazz) {
        this.adapterClass = clazz;
    }

    public void setAdaptTo(String string) {
        this.adaptTo = string;
    }

    protected void setAdaptToClass(Class clazz) {
        this.adaptToClass = clazz;
    }

    protected void addDefinition(ClassLoader classLoader, String string, String string2) throws BuildException {
        Class<?> clazz = null;
        try {
            try {
                string = ProjectHelper.genComponentName(this.getURI(), string);
                if (this.onError != 2) {
                    clazz = Class.forName(string2, true, classLoader);
                }
                if (this.adapter != null) {
                    this.adapterClass = Class.forName(this.adapter, true, classLoader);
                }
                if (this.adaptTo != null) {
                    this.adaptToClass = Class.forName(this.adaptTo, true, classLoader);
                }
                AntTypeDefinition antTypeDefinition = new AntTypeDefinition();
                antTypeDefinition.setName(string);
                antTypeDefinition.setClassName(string2);
                antTypeDefinition.setClass(clazz);
                antTypeDefinition.setAdapterClass(this.adapterClass);
                antTypeDefinition.setAdaptToClass(this.adaptToClass);
                antTypeDefinition.setClassLoader(classLoader);
                if (clazz != null) {
                    antTypeDefinition.checkClass(this.getProject());
                }
                ComponentHelper.getComponentHelper(this.getProject()).addDataTypeDefinition(antTypeDefinition);
            }
            catch (ClassNotFoundException classNotFoundException) {
                String string3 = this.getTaskName() + " class " + string2 + " cannot be found";
                throw new BuildException(string3, classNotFoundException, this.getLocation());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                String string4 = this.getTaskName() + " A class needed by class " + string2 + " cannot be found: " + noClassDefFoundError.getMessage();
                throw new BuildException(string4, noClassDefFoundError, this.getLocation());
            }
        }
        catch (BuildException buildException) {
            switch (this.onError) {
                case 0: 
                case 3: {
                    throw buildException;
                }
                case 1: {
                    this.log(buildException.getLocation() + "Warning: " + buildException.getMessage(), 1);
                    break;
                }
                default: {
                    this.log(buildException.getLocation() + buildException.getMessage(), 4);
                }
            }
        }
    }

    private void tooManyDefinitions() {
        throw new BuildException("Only one of the attributes name, file and resource can be set", this.getLocation());
    }

    public static class Format
    extends EnumeratedAttribute {
        public static final int PROPERTIES = 0;
        public static final int XML = 1;

        @Override
        public String[] getValues() {
            return new String[]{"properties", "xml"};
        }
    }

    public static class OnError
    extends EnumeratedAttribute {
        public static final int FAIL = 0;
        public static final int REPORT = 1;
        public static final int IGNORE = 2;
        public static final int FAIL_ALL = 3;
        public static final String POLICY_FAIL = "fail";
        public static final String POLICY_REPORT = "report";
        public static final String POLICY_IGNORE = "ignore";
        public static final String POLICY_FAILALL = "failall";

        public OnError() {
        }

        public OnError(String string) {
            this.setValue(string);
        }

        @Override
        public String[] getValues() {
            return new String[]{POLICY_FAIL, POLICY_REPORT, POLICY_IGNORE, POLICY_FAILALL};
        }
    }

    private static class ResourceStack
    extends ThreadLocal {
        private ResourceStack() {
        }

        public Object initialValue() {
            return new HashMap();
        }

        Map getStack() {
            return (Map)this.get();
        }
    }
}

