/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;

public class CopyPath
extends Task {
    public static final String ERROR_NO_DESTDIR = "No destDir specified";
    public static final String ERROR_NO_PATH = "No path specified";
    public static final String ERROR_NO_MAPPER = "No mapper specified";
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private FileNameMapper mapper;
    private Path path;
    private File destDir;
    private long granularity = FILE_UTILS.getFileTimestampGranularity();
    private boolean preserveLastModified = false;

    public void setDestDir(File file) {
        this.destDir = file;
    }

    public void add(FileNameMapper fileNameMapper) {
        if (this.mapper != null) {
            throw new BuildException("Only one mapper allowed");
        }
        this.mapper = fileNameMapper;
    }

    public void setPath(Path path) {
        this.createPath().append(path);
    }

    public void setPathRef(Reference reference) {
        this.createPath().setRefid(reference);
    }

    public Path createPath() {
        if (this.path == null) {
            this.path = new Path(this.getProject());
        }
        return this.path;
    }

    public void setGranularity(long l) {
        this.granularity = l;
    }

    public void setPreserveLastModified(boolean bl) {
        this.preserveLastModified = bl;
    }

    protected void validateAttributes() throws BuildException {
        if (this.destDir == null) {
            throw new BuildException(ERROR_NO_DESTDIR);
        }
        if (this.mapper == null) {
            throw new BuildException(ERROR_NO_MAPPER);
        }
        if (this.path == null) {
            throw new BuildException(ERROR_NO_PATH);
        }
    }

    @Override
    public void execute() throws BuildException {
        this.validateAttributes();
        String[] stringArray = this.path.list();
        if (stringArray.length == 0) {
            this.log("Path is empty", 3);
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            File file = new File(string);
            String[] stringArray2 = this.mapper.mapFileName(string);
            for (int j = 0; j < stringArray2.length; ++j) {
                String string2 = stringArray2[j];
                File file2 = new File(this.destDir, string2);
                if (file.equals(file2)) {
                    this.log("Skipping self-copy of " + string, 3);
                    continue;
                }
                if (file.isDirectory()) {
                    this.log("Skipping directory " + string);
                    continue;
                }
                try {
                    this.log("Copying " + file + " to " + file2, 3);
                    FILE_UTILS.copyFile(file, file2, null, null, false, this.preserveLastModified, null, null, this.getProject());
                    continue;
                }
                catch (IOException iOException) {
                    String string3 = "Failed to copy " + file + " to " + file2 + " due to " + iOException.getMessage();
                    if (file2.exists() && !file2.delete()) {
                        string3 = string3 + " and I couldn't delete the corrupt " + file2;
                    }
                    throw new BuildException(string3, iOException, this.getLocation());
                }
            }
        }
    }
}

