/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.taskdefs.FixCRLF;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.StreamPumper;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Resources;
import org.apache.tools.ant.types.resources.Restrict;
import org.apache.tools.ant.types.resources.StringResource;
import org.apache.tools.ant.types.resources.selectors.Exists;
import org.apache.tools.ant.types.resources.selectors.Not;
import org.apache.tools.ant.types.resources.selectors.ResourceSelector;
import org.apache.tools.ant.util.ConcatResourceInputStream;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.ReaderInputStream;
import org.apache.tools.ant.util.StringUtils;

public class Concat
extends Task
implements ResourceCollection {
    private static final int BUFFER_SIZE = 8192;
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private static final ResourceSelector EXISTS = new Exists();
    private static final ResourceSelector NOT_EXISTS = new Not(EXISTS);
    private File destinationFile;
    private boolean append;
    private String encoding;
    private String outputEncoding;
    private boolean binary;
    private StringBuffer textBuffer;
    private ResourceCollection rc;
    private Vector filterChains;
    private boolean forceOverwrite = true;
    private TextElement footer;
    private TextElement header;
    private boolean fixLastLine = false;
    private String eolString;
    private Writer outputWriter = null;
    private ReaderFactory resourceReaderFactory = new ReaderFactory(){

        @Override
        public Reader getReader(Object object) throws IOException {
            InputStream inputStream = ((Resource)object).getInputStream();
            return new BufferedReader(Concat.this.encoding == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, Concat.this.encoding));
        }
    };
    private ReaderFactory identityReaderFactory = new ReaderFactory(){

        @Override
        public Reader getReader(Object object) {
            return (Reader)object;
        }
    };

    public Concat() {
        this.reset();
    }

    public void reset() {
        this.append = false;
        this.forceOverwrite = true;
        this.destinationFile = null;
        this.encoding = null;
        this.outputEncoding = null;
        this.fixLastLine = false;
        this.filterChains = null;
        this.footer = null;
        this.header = null;
        this.binary = false;
        this.outputWriter = null;
        this.textBuffer = null;
        this.eolString = StringUtils.LINE_SEP;
        this.rc = null;
    }

    public void setDestfile(File file) {
        this.destinationFile = file;
    }

    public void setAppend(boolean bl) {
        this.append = bl;
    }

    public void setEncoding(String string) {
        this.encoding = string;
        if (this.outputEncoding == null) {
            this.outputEncoding = string;
        }
    }

    public void setOutputEncoding(String string) {
        this.outputEncoding = string;
    }

    public void setForce(boolean bl) {
        this.forceOverwrite = bl;
    }

    public Path createPath() {
        Path path = new Path(this.getProject());
        this.add(path);
        return path;
    }

    public void addFileset(FileSet fileSet) {
        this.add(fileSet);
    }

    public void addFilelist(FileList fileList) {
        this.add(fileList);
    }

    public synchronized void add(ResourceCollection resourceCollection) {
        if (this.rc == null) {
            this.rc = resourceCollection;
            return;
        }
        if (!(this.rc instanceof Resources)) {
            Resources resources = new Resources();
            resources.setProject(this.getProject());
            resources.add(this.rc);
            this.rc = resources;
        }
        ((Resources)this.rc).add(resourceCollection);
    }

    public void addFilterChain(FilterChain filterChain) {
        if (this.filterChains == null) {
            this.filterChains = new Vector();
        }
        this.filterChains.addElement(filterChain);
    }

    public void addText(String string) {
        if (this.textBuffer == null) {
            this.textBuffer = new StringBuffer(string.length());
        }
        this.textBuffer.append(string);
    }

    public void addHeader(TextElement textElement) {
        this.header = textElement;
    }

    public void addFooter(TextElement textElement) {
        this.footer = textElement;
    }

    public void setFixLastLine(boolean bl) {
        this.fixLastLine = bl;
    }

    public void setEol(FixCRLF.CrLf crLf) {
        String string = crLf.getValue();
        if (string.equals("cr") || string.equals("mac")) {
            this.eolString = "\r";
        } else if (string.equals("lf") || string.equals("unix")) {
            this.eolString = "\n";
        } else if (string.equals("crlf") || string.equals("dos")) {
            this.eolString = "\r\n";
        }
    }

    public void setWriter(Writer writer) {
        this.outputWriter = writer;
    }

    public void setBinary(boolean bl) {
        this.binary = bl;
    }

    @Override
    public void execute() {
        Object object;
        OutputStream outputStream;
        this.validate();
        if (this.binary && this.destinationFile == null) {
            throw new BuildException("destfile attribute is required for binary concatenation");
        }
        ResourceCollection resourceCollection = this.getResources();
        if (this.isUpToDate(resourceCollection)) {
            this.log(this.destinationFile + " is up-to-date.", 3);
            return;
        }
        if (resourceCollection.size() == 0) {
            return;
        }
        if (this.destinationFile == null) {
            outputStream = new LogOutputStream(this, 1);
        } else {
            try {
                object = this.destinationFile.getParentFile();
                if (!((File)object).exists()) {
                    ((File)object).mkdirs();
                }
                outputStream = new FileOutputStream(this.destinationFile.getPath(), this.append);
            }
            catch (Throwable throwable) {
                throw new BuildException("Unable to open " + this.destinationFile + " for writing", throwable);
            }
        }
        try {
            object = new ConcatResource(resourceCollection).getInputStream();
        }
        catch (IOException iOException) {
            throw new BuildException("error getting concatenated resource content", iOException);
        }
        this.pump((InputStream)object, outputStream);
    }

    @Override
    public Iterator iterator() {
        this.validate();
        return Collections.singletonList(new ConcatResource(this.getResources())).iterator();
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isFilesystemOnly() {
        return false;
    }

    private void validate() {
        this.sanitizeText();
        if (this.binary) {
            if (this.textBuffer != null) {
                throw new BuildException("Nested text is incompatible with binary concatenation");
            }
            if (this.encoding != null || this.outputEncoding != null) {
                throw new BuildException("Setting input or output encoding is incompatible with binary concatenation");
            }
            if (this.filterChains != null) {
                throw new BuildException("Setting filters is incompatible with binary concatenation");
            }
            if (this.fixLastLine) {
                throw new BuildException("Setting fixlastline is incompatible with binary concatenation");
            }
            if (this.header != null || this.footer != null) {
                throw new BuildException("Nested header or footer is incompatible with binary concatenation");
            }
        }
        if (this.destinationFile != null && this.outputWriter != null) {
            throw new BuildException("Cannot specify both a destination file and an output writer");
        }
        if (this.rc == null && this.textBuffer == null) {
            throw new BuildException("At least one resource must be provided, or some text.");
        }
        if (this.rc != null && this.textBuffer != null) {
            throw new BuildException("Cannot include inline text when using resources.");
        }
    }

    private ResourceCollection getResources() {
        if (this.rc == null) {
            return new StringResource(this.getProject(), this.textBuffer.toString());
        }
        Restrict restrict = new Restrict();
        restrict.add(NOT_EXISTS);
        restrict.add(this.rc);
        Object object = restrict.iterator();
        while (object.hasNext()) {
            this.log(object.next() + " does not exist.", 0);
        }
        if (this.destinationFile != null) {
            object = this.rc.iterator();
            while (object.hasNext()) {
                File file;
                Object e = object.next();
                if (!(e instanceof FileResource) || !FILE_UTILS.fileNameEquals(file = ((FileResource)e).getFile(), this.destinationFile)) continue;
                throw new BuildException("Input file \"" + file + "\" is the same as the output file.");
            }
        }
        object = new Restrict();
        ((Restrict)object).add(EXISTS);
        ((Restrict)object).add(this.rc);
        return object;
    }

    private boolean isUpToDate(ResourceCollection resourceCollection) {
        if (this.destinationFile == null || this.forceOverwrite) {
            return false;
        }
        Iterator iterator = resourceCollection.iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            if (resource.getLastModified() != 0L && resource.getLastModified() <= this.destinationFile.lastModified()) continue;
            return false;
        }
        return true;
    }

    private void sanitizeText() {
        if (this.textBuffer != null && "".equals(this.textBuffer.toString().trim())) {
            this.textBuffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pump(InputStream inputStream, OutputStream outputStream) {
        Thread thread = new Thread(new StreamPumper(inputStream, outputStream));
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException2) {
                // empty catch block
            }
        }
        finally {
            FileUtils.close(inputStream);
            FileUtils.close(outputStream);
        }
    }

    private Reader getFilteredReader(Reader reader) {
        if (this.filterChains == null) {
            return reader;
        }
        ChainReaderHelper chainReaderHelper = new ChainReaderHelper();
        chainReaderHelper.setBufferSize(8192);
        chainReaderHelper.setPrimaryReader(reader);
        chainReaderHelper.setFilterChains(this.filterChains);
        chainReaderHelper.setProject(this.getProject());
        return chainReaderHelper.getAssembledReader();
    }

    private final class ConcatResource
    extends Resource {
        private ResourceCollection c;

        private ConcatResource(ResourceCollection resourceCollection) {
            this.c = resourceCollection;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            Reader reader;
            if (Concat.this.binary) {
                ConcatResourceInputStream concatResourceInputStream = new ConcatResourceInputStream(this.c);
                concatResourceInputStream.setManagingComponent(this);
                return concatResourceInputStream;
            }
            Reader reader2 = Concat.this.getFilteredReader(new MultiReader(this.c.iterator(), Concat.this.resourceReaderFactory));
            if (Concat.this.header == null && Concat.this.footer == null) {
                reader = reader2;
            } else {
                int n = 1;
                if (Concat.this.header != null) {
                    ++n;
                }
                if (Concat.this.footer != null) {
                    ++n;
                }
                Reader[] readerArray = new Reader[n];
                int n2 = 0;
                if (Concat.this.header != null) {
                    readerArray[n2] = new StringReader(Concat.this.header.getValue());
                    if (Concat.this.header.getFiltering()) {
                        readerArray[n2] = Concat.this.getFilteredReader(readerArray[n2]);
                    }
                }
                int n3 = ++n2;
                ++n2;
                readerArray[n3] = reader2;
                if (Concat.this.footer != null) {
                    readerArray[n2] = new StringReader(Concat.this.footer.getValue());
                    if (Concat.this.footer.getFiltering()) {
                        readerArray[n2] = Concat.this.getFilteredReader(readerArray[n2]);
                    }
                }
                reader = new MultiReader(Arrays.asList(readerArray).iterator(), Concat.this.identityReaderFactory);
            }
            return Concat.this.outputEncoding == null ? new ReaderInputStream(reader) : new ReaderInputStream(reader, Concat.this.outputEncoding);
        }

        @Override
        public String getName() {
            return "concat (" + String.valueOf(this.c) + ")";
        }
    }

    private final class MultiReader
    extends Reader {
        private Reader reader = null;
        private int lastPos = 0;
        private char[] lastChars = new char[Concat.access$000(Concat.this).length()];
        private boolean needAddSeparator = false;
        private Iterator readerSources;
        private ReaderFactory factory;

        private MultiReader(Iterator iterator, ReaderFactory readerFactory) {
            this.readerSources = iterator;
            this.factory = readerFactory;
        }

        private Reader getReader() throws IOException {
            if (this.reader == null && this.readerSources.hasNext()) {
                this.reader = this.factory.getReader(this.readerSources.next());
                Arrays.fill(this.lastChars, '\u0000');
            }
            return this.reader;
        }

        private void nextReader() throws IOException {
            this.close();
            this.reader = null;
        }

        @Override
        public int read() throws IOException {
            if (this.needAddSeparator) {
                char c = Concat.this.eolString.charAt(this.lastPos++);
                if (this.lastPos >= Concat.this.eolString.length()) {
                    this.lastPos = 0;
                    this.needAddSeparator = false;
                }
                return c;
            }
            while (this.getReader() != null) {
                int n = this.getReader().read();
                if (n == -1) {
                    this.nextReader();
                    if (!this.isFixLastLine() || !this.isMissingEndOfLine()) continue;
                    this.needAddSeparator = true;
                    this.lastPos = 0;
                    continue;
                }
                this.addLastChar((char)n);
                return n;
            }
            return -1;
        }

        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (this.getReader() != null || this.needAddSeparator) {
                if (this.needAddSeparator) {
                    cArray[n] = Concat.this.eolString.charAt(this.lastPos++);
                    if (this.lastPos >= Concat.this.eolString.length()) {
                        this.lastPos = 0;
                        this.needAddSeparator = false;
                    }
                    ++n;
                    ++n3;
                    if (--n2 != 0) continue;
                    return n3;
                }
                int n4 = this.getReader().read(cArray, n, n2);
                if (n4 == -1 || n4 == 0) {
                    this.nextReader();
                    if (!this.isFixLastLine() || !this.isMissingEndOfLine()) continue;
                    this.needAddSeparator = true;
                    this.lastPos = 0;
                    continue;
                }
                if (this.isFixLastLine()) {
                    for (int i = n4; i > n4 - this.lastChars.length && i > 0; --i) {
                        this.addLastChar(cArray[n + i - 1]);
                    }
                }
                n += n4;
                n3 += n4;
                if ((n2 -= n4) != 0) continue;
                return n3;
            }
            if (n3 == 0) {
                return -1;
            }
            return n3;
        }

        @Override
        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
            }
        }

        private void addLastChar(char c) {
            for (int i = this.lastChars.length - 2; i >= 0; --i) {
                this.lastChars[i] = this.lastChars[i + 1];
            }
            this.lastChars[this.lastChars.length - 1] = c;
        }

        private boolean isMissingEndOfLine() {
            for (int i = 0; i < this.lastChars.length; ++i) {
                if (this.lastChars[i] == Concat.this.eolString.charAt(i)) continue;
                return true;
            }
            return false;
        }

        private boolean isFixLastLine() {
            return Concat.this.fixLastLine && Concat.this.textBuffer == null;
        }
    }

    private static interface ReaderFactory {
        public Reader getReader(Object var1) throws IOException;
    }

    public static class TextElement
    extends ProjectComponent {
        private String value = "";
        private boolean trimLeading = false;
        private boolean trim = false;
        private boolean filtering = true;
        private String encoding = null;

        public void setFiltering(boolean bl) {
            this.filtering = bl;
        }

        private boolean getFiltering() {
            return this.filtering;
        }

        public void setEncoding(String string) {
            this.encoding = string;
        }

        public void setFile(File file) throws BuildException {
            if (!file.exists()) {
                throw new BuildException("File " + file + " does not exist.");
            }
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = this.encoding == null ? new BufferedReader(new FileReader(file)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.encoding));
                this.value = FileUtils.safeReadFully(bufferedReader);
            }
            catch (IOException iOException) {
                try {
                    throw new BuildException(iOException);
                }
                catch (Throwable throwable) {
                    FileUtils.close(bufferedReader);
                    throw throwable;
                }
            }
            FileUtils.close(bufferedReader);
        }

        public void addText(String string) {
            this.value = this.value + this.getProject().replaceProperties(string);
        }

        public void setTrimLeading(boolean bl) {
            this.trimLeading = bl;
        }

        public void setTrim(boolean bl) {
            this.trim = bl;
        }

        public String getValue() {
            if (this.value == null) {
                this.value = "";
            }
            if (this.value.trim().length() == 0) {
                this.value = "";
            }
            if (this.trimLeading) {
                char[] cArray = this.value.toCharArray();
                StringBuffer stringBuffer = new StringBuffer(cArray.length);
                boolean bl = true;
                int n = 0;
                while (n < cArray.length) {
                    char c = cArray[n++];
                    if (bl) {
                        if (c == ' ' || c == '\t') continue;
                        bl = false;
                    }
                    stringBuffer.append(c);
                    if (c != '\n' && c != '\r') continue;
                    bl = true;
                }
                this.value = stringBuffer.toString();
            }
            if (this.trim) {
                this.value = this.value.trim();
            }
            return this.value;
        }
    }
}

