/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Classloader
extends Task {
    public static final String SYSTEM_LOADER_REF = "ant.coreLoader";
    private String name = null;
    private Path classpath;
    private boolean reset = false;
    private boolean parentFirst = true;
    private String parentName = null;

    public void setName(String string) {
        this.name = string;
    }

    public void setReset(boolean bl) {
        this.reset = bl;
    }

    public void setReverse(boolean bl) {
        this.parentFirst = !bl;
    }

    public void setParentFirst(boolean bl) {
        this.parentFirst = bl;
    }

    public void setParentName(String string) {
        this.parentName = string;
    }

    public void setClasspathRef(Reference reference) throws BuildException {
        this.classpath = (Path)reference.getReferencedObject(this.getProject());
    }

    public void setClasspath(Path path) {
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(null);
        }
        return this.classpath.createPath();
    }

    @Override
    public void execute() {
        try {
            Object object;
            if ("only".equals(this.getProject().getProperty("build.sysclasspath")) && (this.name == null || SYSTEM_LOADER_REF.equals(this.name))) {
                this.log("Changing the system loader is disabled by build.sysclasspath=only", 1);
                return;
            }
            String string = this.name == null ? SYSTEM_LOADER_REF : this.name;
            Object object2 = this.getProject().getReference(string);
            if (this.reset) {
                object2 = null;
            }
            if (object2 != null && !(object2 instanceof AntClassLoader)) {
                this.log("Referenced object is not an AntClassLoader", 0);
                return;
            }
            AntClassLoader antClassLoader = (AntClassLoader)object2;
            if (antClassLoader == null) {
                object = null;
                if (this.parentName != null && !((object = this.getProject().getReference(this.parentName)) instanceof ClassLoader)) {
                    object = null;
                }
                if (object == null) {
                    object = this.getClass().getClassLoader();
                }
                if (this.name == null) {
                    // empty if block
                }
                this.getProject().log("Setting parent loader " + this.name + " " + object + " " + this.parentFirst, 4);
                antClassLoader = new AntClassLoader((ClassLoader)object, this.getProject(), this.classpath, this.parentFirst);
                this.getProject().addReference(string, antClassLoader);
                if (this.name == null) {
                    antClassLoader.addLoaderPackageRoot("org.apache.tools.ant.taskdefs.optional");
                    this.getProject().setCoreLoader(antClassLoader);
                }
            }
            if (this.classpath != null) {
                object = this.classpath.list();
                for (int i = 0; i < ((String[])object).length; ++i) {
                    File file = new File(object[i]);
                    if (!file.exists()) continue;
                    antClassLoader.addPathElement(file.getAbsolutePath());
                    this.log("Adding to class loader " + antClassLoader + " " + file.getAbsolutePath(), 4);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

