/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileUtils;

public class BuildNumber
extends Task {
    private static final String DEFAULT_PROPERTY_NAME = "build.number";
    private static final String DEFAULT_FILENAME = "build.number";
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private File myFile;

    public void setFile(File file) {
        this.myFile = file;
    }

    @Override
    public void execute() throws BuildException {
        File file = this.myFile;
        this.validate();
        Properties properties = this.loadProperties();
        int n = this.getBuildNumber(properties);
        properties.put("build.number", String.valueOf(n + 1));
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.myFile);
            properties.store(fileOutputStream, "Build Number for ANT. Do not edit!");
        }
        catch (IOException iOException) {
            String string = "Error while writing " + this.myFile;
            throw new BuildException(string, iOException);
        }
        finally {
            if (null != fileOutputStream) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    this.log("error closing output stream " + iOException, 0);
                }
            }
            this.myFile = file;
        }
        this.getProject().setNewProperty("build.number", String.valueOf(n));
    }

    private int getBuildNumber(Properties properties) throws BuildException {
        String string = properties.getProperty("build.number", "0").trim();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = this.myFile + " contains a non integer build number: " + string;
            throw new BuildException(string2, numberFormatException);
        }
    }

    private Properties loadProperties() throws BuildException {
        FileInputStream fileInputStream = null;
        try {
            Properties properties = new Properties();
            fileInputStream = new FileInputStream(this.myFile);
            properties.load(fileInputStream);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
        finally {
            if (null != fileInputStream) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    this.log("error closing input stream " + iOException, 0);
                }
            }
        }
    }

    private void validate() throws BuildException {
        if (null == this.myFile) {
            this.myFile = FILE_UTILS.resolveFile(this.getProject().getBaseDir(), "build.number");
        }
        if (!this.myFile.exists()) {
            try {
                FILE_UTILS.createNewFile(this.myFile);
            }
            catch (IOException iOException) {
                String string = this.myFile + " doesn't exist and new file can't be created.";
                throw new BuildException(string, iOException);
            }
        }
        if (!this.myFile.canRead()) {
            String string = "Unable to read from " + this.myFile + ".";
            throw new BuildException(string);
        }
        if (!this.myFile.canWrite()) {
            String string = "Unable to write to " + this.myFile + ".";
            throw new BuildException(string);
        }
    }
}

