/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;

public class Available
extends Task
implements Condition {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private String property;
    private String classname;
    private String filename;
    private File file;
    private Path filepath;
    private String resource;
    private FileDir type;
    private Path classpath;
    private AntClassLoader loader;
    private String value = "true";
    private boolean isTask = false;
    private boolean ignoreSystemclasses = false;
    private boolean searchParents = false;

    public void setSearchParents(boolean bl) {
        this.searchParents = bl;
    }

    public void setClasspath(Path path) {
        this.createClasspath().append(path);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setFilepath(Path path) {
        this.createFilepath().append(path);
    }

    public Path createFilepath() {
        if (this.filepath == null) {
            this.filepath = new Path(this.getProject());
        }
        return this.filepath.createPath();
    }

    public void setProperty(String string) {
        this.property = string;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void setClassname(String string) {
        if (!"".equals(string)) {
            this.classname = string;
        }
    }

    public void setFile(File file) {
        this.file = file;
        this.filename = FILE_UTILS.removeLeadingPath(this.getProject().getBaseDir(), file);
    }

    public void setResource(String string) {
        this.resource = string;
    }

    public void setType(String string) {
        this.log("DEPRECATED - The setType(String) method has been deprecated. Use setType(Available.FileDir) instead.", 1);
        this.type = new FileDir();
        this.type.setValue(string);
    }

    public void setType(FileDir fileDir) {
        this.type = fileDir;
    }

    public void setIgnoresystemclasses(boolean bl) {
        this.ignoreSystemclasses = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        if (this.property == null) {
            throw new BuildException("property attribute is required", this.getLocation());
        }
        this.isTask = true;
        try {
            if (this.eval()) {
                String string = this.getProject().getProperty(this.property);
                if (null != string && !string.equals(this.value)) {
                    this.log("DEPRECATED - <available> used to override an existing property." + StringUtils.LINE_SEP + "  Build file should not reuse the same property" + " name for different values.", 1);
                }
                this.getProject().setProperty(this.property, this.value);
            }
        }
        finally {
            this.isTask = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean eval() throws BuildException {
        try {
            if (this.classname == null && this.file == null && this.resource == null) {
                throw new BuildException("At least one of (classname|file|resource) is required", this.getLocation());
            }
            if (this.type != null && this.file == null) {
                throw new BuildException("The type attribute is only valid when specifying the file attribute.", this.getLocation());
            }
            if (this.classpath != null) {
                this.classpath.setProject(this.getProject());
                this.loader = this.getProject().createClassLoader(this.classpath);
            }
            String string = "";
            if (this.isTask) {
                string = " to set property " + this.property;
            } else {
                this.setTaskName("available");
            }
            if (this.classname != null && !this.checkClass(this.classname)) {
                this.log("Unable to load class " + this.classname + string, 3);
                boolean bl = false;
                return bl;
            }
            if (this.file != null && !this.checkFile()) {
                StringBuffer stringBuffer = new StringBuffer("Unable to find ");
                if (this.type != null) {
                    stringBuffer.append(this.type).append(' ');
                }
                stringBuffer.append(this.filename).append(string);
                this.log(stringBuffer.toString(), 3);
                boolean bl = false;
                return bl;
            }
            if (this.resource != null && !this.checkResource(this.resource)) {
                this.log("Unable to load resource " + this.resource + string, 3);
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (this.loader != null) {
                this.loader.cleanup();
                this.loader = null;
            }
            if (!this.isTask) {
                this.setTaskName(null);
            }
        }
        return true;
    }

    private boolean checkFile() {
        if (this.filepath == null) {
            return this.checkFile(this.file, this.filename);
        }
        String[] stringArray = this.filepath.list();
        for (int i = 0; i < stringArray.length; ++i) {
            this.log("Searching " + stringArray[i], 3);
            File file = new File(stringArray[i]);
            if (file.exists() && (this.filename.equals(stringArray[i]) || this.filename.equals(file.getName()))) {
                if (this.type == null) {
                    this.log("Found: " + file, 3);
                    return true;
                }
                if (this.type.isDir() && file.isDirectory()) {
                    this.log("Found directory: " + file, 3);
                    return true;
                }
                if (this.type.isFile() && file.isFile()) {
                    this.log("Found file: " + file, 3);
                    return true;
                }
                return false;
            }
            File file2 = file.getParentFile();
            if (file2 != null && file2.exists() && this.filename.equals(file2.getAbsolutePath())) {
                if (this.type == null) {
                    this.log("Found: " + file2, 3);
                    return true;
                }
                if (this.type.isDir()) {
                    this.log("Found directory: " + file2, 3);
                    return true;
                }
                return false;
            }
            if (file.exists() && file.isDirectory() && this.checkFile(new File(file, this.filename), this.filename + " in " + file)) {
                return true;
            }
            while (this.searchParents && file2 != null && file2.exists()) {
                if (this.checkFile(new File(file2, this.filename), this.filename + " in " + file2)) {
                    return true;
                }
                file2 = file2.getParentFile();
            }
        }
        return false;
    }

    private boolean checkFile(File file, String string) {
        if (this.type != null) {
            if (this.type.isDir()) {
                if (file.isDirectory()) {
                    this.log("Found directory: " + string, 3);
                }
                return file.isDirectory();
            }
            if (this.type.isFile()) {
                if (file.isFile()) {
                    this.log("Found file: " + string, 3);
                }
                return file.isFile();
            }
        }
        if (file.exists()) {
            this.log("Found: " + string, 3);
        }
        return file.exists();
    }

    private boolean checkResource(String string) {
        if (this.loader != null) {
            return this.loader.getResourceAsStream(string) != null;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader != null) {
            return classLoader.getResourceAsStream(string) != null;
        }
        return ClassLoader.getSystemResourceAsStream(string) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkClass(String string) {
        try {
            if (this.ignoreSystemclasses) {
                this.loader = this.getProject().createClassLoader(this.classpath);
                this.loader.setParentFirst(false);
                this.loader.addJavaLibraries();
                if (this.loader == null) return false;
                try {
                    this.loader.findClass(string);
                    return true;
                }
                catch (SecurityException securityException) {
                    return true;
                }
            } else if (this.loader != null) {
                this.loader.loadClass(string);
                return true;
            } else {
                ClassLoader classLoader = this.getClass().getClassLoader();
                if (classLoader != null) {
                    Class.forName(string, true, classLoader);
                    return true;
                } else {
                    Class.forName(string);
                }
            }
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log("class \"" + string + "\" was not found", 4);
            return false;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.log("Could not load dependent class \"" + noClassDefFoundError.getMessage() + "\" for class \"" + string + "\"", 4);
            return false;
        }
    }

    public static class FileDir
    extends EnumeratedAttribute {
        private static final String[] VALUES = new String[]{"file", "dir"};

        @Override
        public String[] getValues() {
            return VALUES;
        }

        public boolean isDir() {
            return "dir".equalsIgnoreCase(this.getValue());
        }

        public boolean isFile() {
            return "file".equalsIgnoreCase(this.getValue());
        }
    }
}

