/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.RedirectorElement;
import org.apache.tools.ant.util.JavaEnvUtils;

public abstract class AbstractJarSignerTask
extends Task {
    protected File jar;
    protected String alias;
    protected String keystore;
    protected String storepass;
    protected String storetype;
    protected String keypass;
    protected boolean verbose;
    protected String maxMemory;
    protected Vector filesets = new Vector();
    protected static final String JARSIGNER_COMMAND = "jarsigner";
    private RedirectorElement redirector;
    private Environment sysProperties = new Environment();
    public static final String ERROR_NO_SOURCE = "jar must be set through jar attribute or nested filesets";
    private Path path = null;

    public void setMaxmemory(String string) {
        this.maxMemory = string;
    }

    public void setJar(File file) {
        this.jar = file;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public void setKeystore(String string) {
        this.keystore = string;
    }

    public void setStorepass(String string) {
        this.storepass = string;
    }

    public void setStoretype(String string) {
        this.storetype = string;
    }

    public void setKeypass(String string) {
        this.keypass = string;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void addSysproperty(Environment.Variable variable) {
        this.sysProperties.addVariable(variable);
    }

    public Path createPath() {
        if (this.path == null) {
            this.path = new Path(this.getProject());
        }
        return this.path.createPath();
    }

    protected void beginExecution() {
        this.redirector = this.createRedirector();
    }

    protected void endExecution() {
        this.redirector = null;
    }

    private RedirectorElement createRedirector() {
        RedirectorElement redirectorElement = new RedirectorElement();
        if (this.storepass != null) {
            StringBuffer stringBuffer = new StringBuffer(this.storepass).append('\n');
            if (this.keypass != null) {
                stringBuffer.append(this.keypass).append('\n');
            }
            redirectorElement.setInputString(stringBuffer.toString());
            redirectorElement.setLogInputString(false);
        }
        return redirectorElement;
    }

    public RedirectorElement getRedirector() {
        return this.redirector;
    }

    protected void setCommonOptions(ExecTask execTask) {
        if (this.maxMemory != null) {
            this.addValue(execTask, "-J-Xmx" + this.maxMemory);
        }
        if (this.verbose) {
            this.addValue(execTask, "-verbose");
        }
        Vector vector = this.sysProperties.getVariablesVector();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Environment.Variable variable = (Environment.Variable)enumeration.nextElement();
            this.declareSysProperty(execTask, variable);
        }
    }

    protected void declareSysProperty(ExecTask execTask, Environment.Variable variable) throws BuildException {
        this.addValue(execTask, "-J-D" + variable.getContent());
    }

    protected void bindToKeystore(ExecTask execTask) {
        if (null != this.keystore) {
            this.addValue(execTask, "-keystore");
            File file = this.getProject().resolveFile(this.keystore);
            String string = file.exists() ? file.getPath() : this.keystore;
            this.addValue(execTask, string);
        }
        if (null != this.storetype) {
            this.addValue(execTask, "-storetype");
            this.addValue(execTask, this.storetype);
        }
    }

    protected ExecTask createJarSigner() {
        ExecTask execTask = new ExecTask(this);
        execTask.setExecutable(JavaEnvUtils.getJdkExecutable(JARSIGNER_COMMAND));
        execTask.setTaskType(JARSIGNER_COMMAND);
        execTask.setFailonerror(true);
        execTask.addConfiguredRedirector(this.redirector);
        return execTask;
    }

    protected Vector createUnifiedSources() {
        Vector vector = (Vector)this.filesets.clone();
        if (this.jar != null) {
            FileSet fileSet = new FileSet();
            fileSet.setProject(this.getProject());
            fileSet.setFile(this.jar);
            fileSet.setDir(this.jar.getParentFile());
            vector.add(fileSet);
        }
        return vector;
    }

    protected Path createUnifiedSourcePath() {
        Path path = this.path == null ? new Path(this.getProject()) : (Path)this.path.clone();
        Vector vector = this.createUnifiedSources();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            path.add((FileSet)enumeration.nextElement());
        }
        return path;
    }

    protected boolean hasResources() {
        return this.path != null || this.filesets.size() > 0;
    }

    protected void addValue(ExecTask execTask, String string) {
        execTask.createArg().setValue(string);
    }
}

