/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.input;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputRequest;
import org.apache.tools.ant.taskdefs.StreamPumper;
import org.apache.tools.ant.util.FileUtils;

public class GreedyInputHandler
extends DefaultInputHandler {
    private static final int BUFFER_SIZE = 1024;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleInput(InputRequest inputRequest) throws BuildException {
        String string = this.getPrompt(inputRequest);
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream();
            System.err.println(string);
            System.err.flush();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamPumper streamPumper = new StreamPumper(inputStream, byteArrayOutputStream);
            Thread thread = new Thread(streamPumper);
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException2) {
                    // empty catch block
                }
            }
            inputRequest.setInput(new String(byteArrayOutputStream.toByteArray()));
            if (!inputRequest.isInputValid()) {
                throw new BuildException("Received invalid console input");
            }
            if (streamPumper.getException() != null) {
                throw new BuildException("Failed to read input from console", streamPumper.getException());
            }
        }
        finally {
            FileUtils.close(inputStream);
        }
    }
}

