/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.input;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.input.InputRequest;
import org.apache.tools.ant.input.MultipleChoiceInputRequest;

public class DefaultInputHandler
implements InputHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleInput(InputRequest inputRequest) throws BuildException {
        String string = this.getPrompt(inputRequest);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(this.getInputStream()));
            do {
                System.err.println(string);
                System.err.flush();
                try {
                    String string2 = bufferedReader.readLine();
                    inputRequest.setInput(string2);
                }
                catch (IOException iOException) {
                    throw new BuildException("Failed to read input from Console.", iOException);
                }
            } while (!inputRequest.isInputValid());
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    throw new BuildException("Failed to close input.", iOException);
                }
            }
        }
    }

    protected String getPrompt(InputRequest inputRequest) {
        String string = inputRequest.getPrompt();
        String string2 = inputRequest.getDefaultValue();
        if (inputRequest instanceof MultipleChoiceInputRequest) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(" (");
            Enumeration enumeration = ((MultipleChoiceInputRequest)inputRequest).getChoices().elements();
            boolean bl = true;
            while (enumeration.hasMoreElements()) {
                String string3;
                if (!bl) {
                    stringBuffer.append(", ");
                }
                if ((string3 = (String)enumeration.nextElement()).equals(string2)) {
                    stringBuffer.append('[');
                }
                stringBuffer.append(string3);
                if (string3.equals(string2)) {
                    stringBuffer.append(']');
                }
                bl = false;
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
        if (string2 != null) {
            return string + " [" + string2 + "]";
        }
        return string;
    }

    protected InputStream getInputStream() {
        return System.in;
    }
}

