/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;

public final class PrefixLines
extends BaseParamFilterReader
implements ChainableReader {
    private static final String PREFIX_KEY = "prefix";
    private String prefix = null;
    private String queuedData = null;

    public PrefixLines() {
    }

    public PrefixLines(Reader reader) {
        super(reader);
    }

    @Override
    public int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        int n = -1;
        if (this.queuedData != null && this.queuedData.length() == 0) {
            this.queuedData = null;
        }
        if (this.queuedData != null) {
            n = this.queuedData.charAt(0);
            this.queuedData = this.queuedData.substring(1);
            if (this.queuedData.length() == 0) {
                this.queuedData = null;
            }
        } else {
            this.queuedData = this.readLine();
            if (this.queuedData == null) {
                n = -1;
            } else {
                if (this.prefix != null) {
                    this.queuedData = this.prefix + this.queuedData;
                }
                return this.read();
            }
        }
        return n;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    private String getPrefix() {
        return this.prefix;
    }

    @Override
    public Reader chain(Reader reader) {
        PrefixLines prefixLines = new PrefixLines(reader);
        prefixLines.setPrefix(this.getPrefix());
        prefixLines.setInitialized(true);
        return prefixLines;
    }

    private void initialize() {
        Parameter[] parameterArray = this.getParameters();
        if (parameterArray != null) {
            for (int i = 0; i < parameterArray.length; ++i) {
                if (!PREFIX_KEY.equals(parameterArray[i].getName())) continue;
                this.prefix = parameterArray[i].getValue();
                break;
            }
        }
    }
}

